/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ 荞݃xN^ ]
 */

/*
 * #pragma interrupt`(CA78K0R)
 */
#ifdef __CA78K0R__
/* ^C} */
#pragma interrupt INTTM01 inttm01_isr

/* UART */
#pragma interrupt INTST0 intst0_isr
#pragma interrupt INTSR0 intsr0_isr
#pragma interrupt INTST1 intst1_isr
#pragma interrupt INTSR1 intsr1_isr

/* CAN */
#pragma interrupt INTCAN0ERR intcan0err_isr
#pragma interrupt INTCAN0TRM intcan0trm_isr
#pragma interrupt INTCANGRFR intcangrfr_isr
#pragma interrupt INTCANGERR intcangerr_isr
#endif /* __CA78K0R__*/

#include "common.h"
#include "iodefine.h"
#include "timer.h"
#include "uart.h"
#include "can.h"

/*
 * #pragma interrupt`(CC-RL)
 */
#ifdef __CCRL__
/* ^C} */
#pragma interrupt inttm01_isr(vect=INTTM01, bank=RB3)

/* UART */
#pragma interrupt intst0_isr(vect=INTST0, bank=RB2)
#pragma interrupt intsr0_isr(vect=INTSR0, bank=RB2)
#pragma interrupt intst1_isr(vect=INTST1, bank=RB2)
#pragma interrupt intsr1_isr(vect=INTSR1, bank=RB2)

/* CAN */
#pragma interrupt intcan0err_isr(vect=INTCAN0ERR, bank=RB1)
#pragma interrupt intcan0trm_isr(vect=INTCAN0TRM, bank=RB1)
#pragma interrupt intcangrfr_isr(vect=INTCANGRFR, bank=RB1)
#pragma interrupt intcangerr_isr(vect=INTCANGERR, bank=RB1)
#endif /* __CCRL__ */

/*
 * ^C}E`l1JEg(INTTM01)
 * 荞݃nh
 */
void inttm01_isr(void)
{
	/* ^C}hCoĂяo */
	timer_isr();
}

/*
 * UART0M(INTST0)
 * 荞݃nh
 */
void intst0_isr(void)
{
	/* UARThCoĂяo */
	uart_tx_isr(0);
}

/*
 * UART0M(INTSR0)
 * 荞݃nh
 */
void intsr0_isr(void)
{
	/* UARThCoĂяo */
	uart_rx_isr(0);
}

/*
 * UART1M(INTST1)
 * 荞݃nh
 */
void intst1_isr(void)
{
	/* UARThCoĂяo */
	uart_tx_isr(1);
}

/*
 * UART1M(INTSR1)
 * 荞݃nh
 */
void intsr1_isr(void)
{
	/* UARThCoĂяo */
	uart_rx_isr(1);
}

/*
 * CAN0`lEG[(INTCAN0ERR)
 * 荞݃nh
 */
void intcan0err_isr(void)
{
	/* CANhCoĂяo */
	can_cerr_isr();
}

/*
 * CAN0`lM(INTCAN0TRM)
 * 荞݃nh
 */
void intcan0trm_isr(void)
{
	/* CANhCoĂяo */
	can_tx_isr();
}

/*
 * CANO[oMFIFO(INTCANGRFR)
 * 荞݃nh
 */
void intcangrfr_isr(void)
{
	/* CANhCoĂяo */
	can_rx_isr();
}

/*
 * CANO[oEG[(INTCANGERR)
 * 荞݃nh
 */
void intcangerr_isr(void)
{
	/* CANhCoĂяo */
	can_gerr_isr();
}
