﻿// ThirdEyeen - Client of Twitter
// Copyright (c) 2014      hama_kai (@hama_kai) <http://hamakaiji.web.fc2.com/>
// All rights reserved.
// 
// This file is part of ThirdEyeen.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General public License
// for more details.
// 
// You should have received a copy of the GNU General public License along
// with this program. If not, see <http://www.gnu.org/licenses/>, or write to
// the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
// Boston, MA 02110-1301, USA.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OpenTween.Setting.Panel
{
    public partial class ThirdEyeenPanel : SettingPanelBase
    {
        public ThirdEyeenPanel()
        {
            InitializeComponent();
        }

        public void LoadConfig(SettingThirdEyeen settingThirdEyeen)
        {
            this.CheckEnableBothUserStreamPeriodicFetch.Checked = settingThirdEyeen.EnableBothUserStreamPeriodicFetch;
            this.CheckMoreGetsPreviousToLast.Checked = settingThirdEyeen.MoreGetsPreviousToLast;
            this.TextRepeatGetLoopCount.Text = settingThirdEyeen.RepeatGetLoopCount.ToString();
            this.TextRepeatGetCountApi.Text = settingThirdEyeen.RepeatGetCountApi.ToString();
            this.CheckRepeatGetInit.Checked = settingThirdEyeen.RepeatGetInit;
            this.LabelRepeatGetCountApi.Enabled = (settingThirdEyeen.RepeatGetLoopCount != 0);
            this.TextRepeatGetCountApi.Enabled = (settingThirdEyeen.RepeatGetLoopCount != 0);
            this.CheckRepeatGetInit.Enabled = (settingThirdEyeen.RepeatGetLoopCount != 0);
            this.CheckOsWokenDetectPowerTroubleshooter.Checked = settingThirdEyeen.OsWokenDetectPowerTroubleshooter;
            this.TextWokenWaitPeriod.Text = settingThirdEyeen.WokenWaitPeriod.ToString();
            this.TextWokenWaitPeriod.Enabled = settingThirdEyeen.OsWokenDetectPowerTroubleshooter;

            this.lblRTby.BackColor = settingThirdEyeen.ColorRTby;
            this.lblWhoRT.BackColor = settingThirdEyeen.ColorWhoRT;
            this.lblRTbyWhoRT.BackColor = settingThirdEyeen.ColorRTbyWhoRT;
            this.CheckEnableColorRTby.Checked = settingThirdEyeen.EnableColorRTby;
            this.lblRTby.Enabled = settingThirdEyeen.EnableColorRTby;
            this.btnRTby.Enabled = settingThirdEyeen.EnableColorRTby;
            this.CheckEnableColorWhoRT.Checked = settingThirdEyeen.EnableColorWhoRT;
            this.lblWhoRT.Enabled = settingThirdEyeen.EnableColorWhoRT;
            this.btnWhoRT.Enabled = settingThirdEyeen.EnableColorWhoRT;
            this.CheckEnableColorRTbyWhoRT.Checked = settingThirdEyeen.EnableColorRTbyWhoRT;
            this.lblRTbyWhoRT.Enabled = settingThirdEyeen.EnableColorRTbyWhoRT;
            this.btnRTbyWhoRT.Enabled = settingThirdEyeen.EnableColorRTbyWhoRT;
        }

        public void SaveConfig(SettingThirdEyeen settingThirdEyeen)
        {
            settingThirdEyeen.EnableBothUserStreamPeriodicFetch = this.CheckEnableBothUserStreamPeriodicFetch.Checked;
            settingThirdEyeen.MoreGetsPreviousToLast = this.CheckMoreGetsPreviousToLast.Checked;
            settingThirdEyeen.RepeatGetLoopCount = int.Parse(this.TextRepeatGetLoopCount.Text);
            settingThirdEyeen.RepeatGetCountApi = int.Parse(this.TextRepeatGetCountApi.Text);
            settingThirdEyeen.RepeatGetInit = this.CheckRepeatGetInit.Checked;
            settingThirdEyeen.OsWokenDetectPowerTroubleshooter = this.CheckOsWokenDetectPowerTroubleshooter.Checked;
            settingThirdEyeen.WokenWaitPeriod = int.Parse(this.TextWokenWaitPeriod.Text);

            settingThirdEyeen.ColorRTby = this.lblRTby.BackColor;
            settingThirdEyeen.ColorWhoRT = this.lblWhoRT.BackColor;
            settingThirdEyeen.ColorRTbyWhoRT = this.lblRTbyWhoRT.BackColor;
            settingThirdEyeen.EnableColorRTby = this.CheckEnableColorRTby.Checked;
            settingThirdEyeen.EnableColorWhoRT = this.CheckEnableColorWhoRT.Checked;
            settingThirdEyeen.EnableColorRTbyWhoRT = this.CheckEnableColorRTbyWhoRT.Checked;
        }

        private void TextRepeatGetLoopCount_Validating(object sender, CancelEventArgs e)
        {
            int cnt;
            try
            {
                cnt = int.Parse(TextRepeatGetLoopCount.Text);
            }
            catch (Exception)
            {
                MessageBox.Show("Input number 0 to 14.");
                e.Cancel = true;
                return;
            }

            if (cnt < 0 || cnt > 14)
            {
                MessageBox.Show("Input number 0 to 14");
                e.Cancel = true;
                return;
            }
        }

        private void TextRepeatGetLoopCount_TextChanged(object sender, EventArgs e)
        {
            int cnt;
            try
            {
                cnt = int.Parse(TextRepeatGetLoopCount.Text);
            }
            catch (Exception)
            {
                LabelRepeatGetCountApi.Enabled = false;
                TextRepeatGetCountApi.Enabled = false;
                CheckRepeatGetInit.Enabled = false;
                return;
            }

            //1以上の正しい値が入力されたときのみRepeatGetCountApiを入力可能にする
            if (cnt >= 1 && cnt <= 14)
            {
                LabelRepeatGetCountApi.Enabled = true;
                TextRepeatGetCountApi.Enabled = true;
                CheckRepeatGetInit.Enabled = true;
            }
            else
            {
                LabelRepeatGetCountApi.Enabled = false;
                TextRepeatGetCountApi.Enabled = false;
                CheckRepeatGetInit.Enabled = false;
            }
            return;
        }

        private void TextRepeatGetCountApi_Validating(object sender, CancelEventArgs e)
        {
            int cnt;
            try
            {
                cnt = int.Parse(TextRepeatGetCountApi.Text);
            }
            catch (Exception)
            {
                MessageBox.Show(Properties.Resources.TextCountApi_Validating1);
                e.Cancel = true;
                return;
            }

            if (cnt < 20 || cnt > 200)
            {
                MessageBox.Show(Properties.Resources.TextCountApi_Validating1);
                e.Cancel = true;
                return;
            }
        }

        private void CheckOsWokenDetectPowerTroubleshooter_CheckedChanged(object sender, EventArgs e)
        {
            LabelWokenWaitPeriod.Enabled = CheckOsWokenDetectPowerTroubleshooter.Checked;
            TextWokenWaitPeriod.Enabled = CheckOsWokenDetectPowerTroubleshooter.Checked;
        }

        private void TextWokenWaitPeriod_Validating(object sender, CancelEventArgs e)
        {
            int prd;
            try
            {
                prd = int.Parse(TextWokenWaitPeriod.Text);
            }
            catch (Exception)
            {
                MessageBox.Show("Input number 0 or over.");
                e.Cancel = true;
                return;
            }

            if (prd < 0)
            {
                MessageBox.Show("Input number 0 or over.");
                e.Cancel = true;
                return;
            }
        }

        private void CheckEnableColorRTby_CheckedChanged(object sender, EventArgs e)
        {
            lblRTby.Enabled = CheckEnableColorRTby.Checked;
            btnRTby.Enabled = CheckEnableColorRTby.Checked;
        }

        private void CheckEnableColorWhoRT_CheckedChanged(object sender, EventArgs e)
        {
            lblWhoRT.Enabled = CheckEnableColorWhoRT.Checked;
            btnWhoRT.Enabled = CheckEnableColorWhoRT.Checked;
        }

        private void CheckEnableColorRTbyWhoRT_CheckedChanged(object sender, EventArgs e)
        {
            lblRTbyWhoRT.Enabled = CheckEnableColorRTbyWhoRT.Checked;
            btnRTbyWhoRT.Enabled = CheckEnableColorRTbyWhoRT.Checked;
        }

        private void btnRTby_Click(object sender, EventArgs e)
        {
            this.ShowBackColorDialog(this.lblRTby);
        }

        private void btnWhoRT_Click(object sender, EventArgs e)
        {
            this.ShowBackColorDialog(this.lblWhoRT);
        }

        private void btnRTbyWhoRT_Click(object sender, EventArgs e)
        {
            this.ShowBackColorDialog(this.lblRTbyWhoRT);
        }
    }
}
