﻿// ThirdEyeen - Client of Twitter
// Copyright (c) 2012      kim_upsilon (@kim_upsilon) <https://upsilo.net/~upsilon/>
//           (c) 2014      hama_kai (@hama_kai) <http://hamakaiji.web.fc2.com/>
// All rights reserved.
// 
// This file is part of ThirdEyeen.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General public License
// for more details.
// 
// You should have received a copy of the GNU General public License along
// with this program. If not, see <http://www.gnu.org/licenses/>, or write to
// the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
// Boston, MA 02110-1301, USA.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OpenTween
{
    /// <summary>
    /// アプリケーション固有の情報を格納します
    /// </summary>
    /// <remarks>
    /// OpenTween の派生版を作る方法は http://sourceforge.jp/projects/opentween/wiki/HowToFork を参照して下さい。
    /// </remarks>
    internal sealed class ApplicationSettings
    {
        //=====================================================================
        // フィードバック送信先
        // 異常終了時などにエラーログ等とともに表示されます。
        
        /// <summary>
        /// フィードバック送信先 (メール)
        /// </summary>
        public const string FeedbackEmailAddress = "hamasawakai@gmail.com";

        /// <summary>
        /// フィードバック送信先 (Twitter)
        /// </summary>
        public const string FeedbackTwitterName = "@hama_kai";

        //=====================================================================
        // Web サイト

        /// <summary>
        /// 「ヘルプ」メニューの「(アプリ名) ウェブサイト」クリック時に外部ブラウザで表示する URL
        /// </summary>
        public const string WebsiteUrl = "https://sourceforge.jp/users/hama_kai/pf/ThirdEyeen/wiki/FrontPage";

        /// <summary>
        /// 「ヘルプ」メニューの「ショートカットキー一覧」クリック時に外部ブラウザで表示する URL
        /// </summary>
        /// <remarks>
        /// Tween の Wiki ページのコンテンツはプロプライエタリなため転載不可
        /// </remarks>
        public const string ShortcutKeyUrl = "http://sourceforge.jp/projects/tween/wiki/%E3%82%B7%E3%83%A7%E3%83%BC%E3%83%88%E3%82%AB%E3%83%83%E3%83%88%E3%82%AD%E3%83%BC";

        //=====================================================================
        // アップデートチェック関連

        /// <summary>
        /// 最新バージョンの情報を取得するためのURL
        /// </summary>
        /// <remarks>
        /// version.txt のフォーマットについては http://sourceforge.jp/projects/opentween/wiki/VersionTxt を参照。
        /// 派生プロジェクトなどでこの機能を無効にする場合は null をセットして下さい。
        /// </remarks>
        public static readonly string VersionInfoUrl = "http://hamakaiji.web.fc2.com/software/ThirdEyeen/version.txt";

        //=====================================================================
        // Twitter
        // https://dev.twitter.com/ から取得できます。

        /// <summary>
        /// Twitter コンシューマーキー
        /// </summary>
        public const string TwitterConsumerKey = "lE6Fh2pWfBlZDVlGPo5FQ";
        public const string TwitterConsumerSecret = "t0LfydfQzZpSa9yfbckU2VqoqqYsv3ibEKZ1TASHdI";

        //=====================================================================
        // Twitpic
        // http://dev.twitpic.com/apps/new から取得できます。

        /// <summary>
        /// Twitpic APIキー
        /// </summary>
        public const string TwitpicApiKey = "812287b94195765dc692b5eb118e9764";

        //=====================================================================
        // yfrog
        // http://stream.imageshack.us/api/ から取得できます。

        /// <summary>
        /// yfrog APIキー
        /// </summary>
        public const string YfrogApiKey = "579CPTWY388f126ebf99591cbf2b8682988cffc8";

        //=====================================================================
        // Foursquare
        // https://developer.foursquare.com/ から取得できます。

        /// <summary>
        /// Foursquare Client Id
        /// </summary>
        public const string FoursquareClientId = "M1HU0XDUCPOW4WUIWCDBEI05WF2KZGS4HSWRIUSH2SENJOH0";

        /// <summary>
        /// Foursquare Client Secret
        /// </summary>
        public const string FoursquareClientSecret = "I5UNIDF0MP1JV01IE21PMURPRIFF2N255RAEDM2KDQV5OHHU";

        //=====================================================================
        // bit.ly
        // https://bitly.com/a/account から取得できます。

        /// <summary>
        /// bit.ly ログイン名
        /// </summary>
        public const string BitlyLoginId = "o_3rs4tbd9t0";

        /// <summary>
        /// bit.ly APIキー
        /// </summary>
        public const string BitlyApiKey = "R_3d3e1fbf0aa64d3fb2c565938a8bd85b";

        //=====================================================================
        // TINAMI
        // http://www.tinami.com/api/ から取得できます。

        /// <summary>
        /// TINAMI APIキー
        /// </summary>
        public const string TINAMIApiKey = "5310ea84e9c18";

        //=====================================================================
        // Windows Azure Marketplace
        // https://datamarket.azure.com/account/keys から取得できます。

        /// <summary>
        /// Windows Azure Marketplace アカウントキー
        /// </summary>
        public const string AzureMarketplaceKey = "Ar31Kh7ne+3FQDyTZDxJeE7M6U98O+Ow1ULJ5pOJ0wk=";

        //=====================================================================
        // Imgur
        // https://api.imgur.com/oauth2/addclient から取得できます

        /// <summary>
        /// Imgur Client ID
        /// </summary>
        public readonly static string ImgurClientID = "e978175723d18b6";

        /// <summary>
        /// Imgur Client Secret
        /// </summary>
        public readonly static string ImgurClientSecret = "e7b50e0b9e8dcd486e589eb4309ab4265fafa39f";
    }
}
