/*!
 * @file GameWorld.h
 * @brief Q[Ẽvg^Cv錾
 * @date 2013/02/01
 * @author Deskull
 * 2013-2014 Sikabane Works.
 */

#pragma once

#include "stdafx.h"
#include "Authority.h"
#include "Building.h"
#include "Camp.h"
#include "Creature.h"
#include "CreatureTrait.h"
#include "Dice.h"
#include "Dungeon.h"
#include "Deeangband.h"
#include "Effect.h"
#include "Feature.h"
#include "FixedArtifact.h"
#include "Floor.h"
#include "GameSurface.h"
#include "Item.h"
#include "ItemBase.h"
#include "ItemEgo.h"
#include "ItemTrait.h"
#include "Karma.h"
#include "Skill.h"
#include "Species.h"
#include "Trap.h"
#include "TrapBase.h"

/*!
 * @class GameWorld
 * @brief Q[ẼNX
 */
class GameWorld
{
private:
	GameSurface *gameSurface;

	//ÓIf[^Xg
	map<TAG, shared_ptr<Authority>> authorityList;          /*!<S\Xg*/
	map<TAG, shared_ptr<Effect>> effectList;                /*!<SʑXg*/
	map<TAG, shared_ptr<FixedArtifact>> fixedArtifactList;  /*!<SŒA[eBt@NgXg*/
	map<TAG, shared_ptr<Feature>> featureList;              /*!<Sn`Xg*/
	map<TAG, shared_ptr<ItemBase>> itemBaseList;            /*!<SACex[XXg*/
	map<TAG, shared_ptr<ItemEgo>> itemEgoList;              /*!<SACeGSXg*/
	map<TAG, shared_ptr<ItemTrait>> itemTraitList;          /*!<SACeXg*/
	map<TAG, shared_ptr<Karma>> karmaList;                  /*!<SJ}Xg*/
	map<TAG, shared_ptr<Skill>> skillList;                  /*!<SXLXg*/
	map<TAG, shared_ptr<Species>> speciesList;              /*!<SN[`[ʃXg*/
	map<TAG, shared_ptr<TrapBase>> trapBaseList;            /*!<Sgbvx[XʃXg*/
	map<TAG, shared_ptr<Building>> buildingList;            /*!<S{݃Xg*/
	map<TAG, shared_ptr<Camp>> campList;                    /*!<SwcXg*/
	map<TAG, shared_ptr<Dungeon>> dungeonList;              /*!<S_WXg*/
	map<TAG, shared_ptr<CreatureTrait>> creatureTraitList;  /*!<SN[`[Xg*/

	//If[^Xg
	map<ID, shared_ptr<Item>> itemList;                    /*!<SACeXg*/
	map<ID, shared_ptr<Creature>> creatureList;            /*!<SN[`[Xg*/
	map<ID, shared_ptr<Floor>> floorList;                  /*!<StAXg*/
	map<ID, shared_ptr<Trap>> trapList;                    /*!<SgbvXg*/

public:

	/*!
	 * @brief GameWorldNX̃RXgN^
	 * @param gSurface Q[̃C^[tFCXƂȂ GameSurface Q
	 */
	GameWorld(GameSurface *gSurface);

	/*!
	 * @brief GameWorldNX̃fXgN^
	 */
	~GameWorld();

	/*!
	 * @brief GameWorldɑ݂錠\Ԃ
	 * @param TAG \̃^O
	 * @return \̎Qƃ|C^A݂ȂNULLԂB
	 */
	Authority *GameWorld::GetAuthority(TAG tag);

	/*!
	 * @brief GameWorldɑ݂N[`[Ԃ
	 * @param TAG N[`[̃^O
	 * @return N[`[̎Qƃ|C^A݂ȂNULLԂB
	 */
	CreatureTrait *GameWorld::GetCreatureTrait(TAG tag);

	/*!
	 * @brief GameWorldɑ݂ʑԂ
	 * @param TAG ʑ̃^O
	 * @return ʑ̎Qƃ|C^A݂ȂNULLԂB
	 */
	Effect *GameWorld::GetEffect(TAG tag);

	/*!
	 * @brief GameWorldɑ݂ŒA[eBt@NgԂ
	 * @param TAG ʑ̃^O
	 * @return ŒA[eBt@Ng̎Qƃ|C^A݂ȂNULLԂB
	 */
	FixedArtifact *GameWorld::GetFixedArtifact(TAG tag);

	/*!
	 * @brief GameWorldɑ݂n`Ԃ
	 * @param TAG n`̃^O
	 * @return n`̎Qƃ|C^A݂ȂNULLԂB
	 */
	Feature *GameWorld::GetFeature(TAG tag);

	/*!
	 * @brief GameWorldɑ݂x[XACeԂ
	 * @param TAG x[XACẽ^O
	 * @return x[XACe̎Qƃ|C^A݂ȂNULLԂB
	 */
	ItemBase *GameWorld::GetItemBase(TAG tag);

	/*!
	 * @brief GameWorldɑ݂ACeGSԂ
	 * @param TAG ACeGS̃^O
	 * @return ACeGS̎Qƃ|C^A݂ȂNULLԂB
	 */
	ItemEgo *GameWorld::GetItemEgo(TAG tag);

	/*!
	 * @brief GameWorldɑ݂ACeԂ
	 * @param TAG ACẽ^O
	 * @return ACe̎Qƃ|C^A݂ȂNULLԂB
	 */
	ItemTrait *GameWorld::GetItemTrait(TAG tag);

	/*!
	 * @brief GameWorldɑ݂J}Ԃ
	 * @param TAG J}̃^O
	 * @return J}̎Qƃ|C^A݂ȂNULLԂB
	 */
	Karma *GameWorld::GetKarma(TAG tag);

	/*!
	 * @brief GameWorldɑ݂XLԂ
	 * @param TAG XL̃^O
	 * @return XL̎Qƃ|C^A݂ȂNULLԂB
	 */
	Skill *GameWorld::GetSkill(TAG tag);

	/*!
	 * @brief GameWorldɑ݂XLԂ
	 * @param TAG XL̃^O
	 * @return XL̎Qƃ|C^A݂ȂNULLԂB
	 */
	Species *GameWorld::GetSpecies(TAG tag);

	/*!
	 * @brief GameWorldɑ݂gbvʂԂ
	 * @param TAG gbvʂ̃^O
	 * @return gbvʂ̎Qƃ|C^A݂ȂNULLԂB
	 */
	TrapBase *GameWorld::GetTrapBase(TAG tag);

	/*!
	 * @brief GameWorldɑ݂{݂Ԃ
	 * @param TAG {݂̃^O
	 * @return {݂̎Qƃ|C^A݂ȂNULLԂB
	 */
	Building *GameWorld::GetBuilding(TAG tag);

	/*!
	 * @brief GameWorldɑ݂wcԂ
	 * @param TAG wc̃^O
	 * @return wc̎Qƃ|C^A݂ȂNULLԂB
	 */
	Camp *GameWorld::GetCamp(TAG tag);

	/*!
	 * @brief GameWorldɑ݂_WԂ
	 * @param TAG _W̃^O
	 * @return _W̎Qƃ|C^A݂ȂNULLԂB
	 */
	Dungeon *GameWorld::GetDungeon(TAG tag);

	/*!
	 * @brief GameWorldɑ݂ACeԂ
	 * @param TAG ACẽ^O
	 * @return ACe̎Qƃ|C^A݂ȂNULLԂB
	 */
	Item *GameWorld::GetItem(ID id);

	/*!
	 * @brief GameWorldɑ݂tAԂ
	 * @param TAG tÃ^O
	 * @return tA̎Qƃ|C^A݂ȂNULLԂB
	 */
	Floor *GameWorld::GetFloor(ID id);

	/*!
	 * @brief GameWorldɑ݂N[`[Ԃ
	 * @param TAG N[`[̃^O
	 * @return N[`[̎Qƃ|C^A݂ȂNULLԂB
	 */
	Creature *GameWorld::GetCreature(ID id);

	/*
	 * @brief vCC[v
	 * @return Q[IR[h
	 */
	PLAY_EXIT_CODE PlayLoop(void);

	/*
	 * @brief 󂯎Q[R}h
	 * @param command sQ[R}h
	 * @return Q[IR[h
	 */
	PLAY_EXIT_CODE DoGameCommand(GAME_COMMAND command);
};
