/*!
 * @file Feature.cpp
 * @brief Q[̒n``
 * @date 2013/12/11
 * @author Deskull
 * 2013 Sikabane Works.
 */

#include "stdafx.h"
#include "Feature.h"


Feature::Feature(ID id, TAG tag, GameWorld *gameWorld) : GameElement(id, tag, gameWorld)
{
	SetDammyData();
}

Feature::Feature(void)
{
	SetDammyData();
}

Feature::~Feature(void)
{
}

void Feature::SetDammyData(void)
{
	this->name = "m̒n`";
	this->SetID(0);
	this->SetTag("UNKNOWN_FEATURE");
	this->symbol = 'X';
	this->symColor.r = 40;
	this->symColor.g = 40;
	this->symColor.b = 40;
	this->symColor.a = 255;
	this->backColor.r = 0;
	this->backColor.g = 0;
	this->backColor.b = 0;
	this->backColor.a = 255;
}

ID Feature::GetTileID(void)
{
	return this->tileID;
}

ID Feature::GetSymbol(void)
{
	return this->symbol;
}

Color Feature::GetSymColor(void)
{
	return this->symColor;
}

Color Feature::GetBackColor(void)
{
	return this->backColor;
}
