/*!
 * @file Creature.h
 * @brief Q[̃N[`[ƕtvf̃vg^Cv
 * @date 2013/12/11
 * @author Deskull
 * 2013 Sikabane Works.
 */

#pragma once

#include "stdafx.h"
#include "BaseStatusTable.h"
#include "Coordinates.h"
#include "Discipline.h"
#include "Effect.h"
#include "Floor.h"
#include "Item.h"
#include "GameElement.h"
#include "SavingTable.h"
#include "Species.h"

/*!
 * @class Creature
 * @brief N[`[̃NX
 */
class Creature : public GameElement
{
private:

	static const SOUL soulLevel[CREATURE_MAX_LEVEL]; //!< Kv\Exe[u

	string name;      //!< N[`[̖O
	HP currentHp;     //!< ݂HP
	HP max_hp;        //!< ݂̍őHP
	MP currentMp;     //!< ݂MP
	MP maxMp;         //!< ݂̍őMP
	MP maxMaxMp;      //!< {̍őMP
	SOUL currentSoul; //!< ݂̃\El
	SOUL maxSoul;     //!< \Eő哞Bl

	HEIGHT height;    //!< g
	HEIGHT weight;    //!< ̏d

	FEED currentFeed; //!< ݎ{l
	FEED maxFeed;     //!< ő厠{l

	Discipline currentDiscipilne; /*!< ݂̏C{l */
	LEVEL divineLevel; //!< _x

	BaseStatusTable currentStatus; /*!< ݂̃Xe[^X */
	BaseStatusTable maxStatus;     /*!< ʏ̃Xe[^X */
	BaseStatusTable maxMaxStatus;  /*!< ẼXe[^X */

	SavingTable savings; /*!< Z[rO */

	ID floorID; /*!< ݂tAID */
	Coordinates position; /*!< W */
	map<ID, TAG, Item> itemList; /*!< ACeXg */
	char symbol; /*!< V{L */
	Color symbolColor; /*!< V{J[ */
	ID tileID ;/*!< ^CID */

	HP hpTable[CREATURE_MAX_LEVEL]; //!< qbg_CXɊÂꂽx̊{HP

	/*!
	 * @brief N[`[S̏s
	 */
	void Creature::die(void);

	/*!
	 * @brief N[`[̌HP𑝌
	 */
	void Creature::calcHP(HP amount);

	/*!
	 * @brief N[`[̌MP𑝌
	 */
	void Creature::calcMP(MP amount);

	/*!
	 * @brief N[`[̌HPݒ肷
	 */
	void Creature::setHP(HP amount);

	/*!
	 * @brief N[`[̌MPݒ肷
	 */
	void Creature::setMP(MP amount);

	/*!
	 * @brief N[`[tȀWɈړ
	 * @param floorID ړtAID
	 * @param x ړxW
	 * @param y ړyW
	 * @return ړłȂꍇ̃G[ID
	 */
	int Creature::move(ID floor_ID, int x, int y);

	/*!
	 * @brief N[`[tȀWɈړ
	 * @param floorID ړtAID
	 * @param coord ړW
	 * @return ړłȂꍇ̃G[ID
	 */
	int Creature::move(ID floor_ID, Coordinates coord);

	/*!
	 * @brief N[`[̃x{HPČvZ
	 */
	void Creature::calcHPTable(void);

public:

	/*! 
	 * @brief CreatureNXRXgN^(GameElementoΉ)
	 * @param speciesPtr ƂȂN[`[
	 * @param id GameElementID
	 * @param TAG GameElement̃^O
	 * @param gameWorld gameWorldQƃ|C^
	 */
	Creature::Creature(Species *speciesPtr, ID id, TAG tag, GameWorld *gameWorld);

	/*! 
	 * @brief CreatureNXRXgN^(GameElementoΉ)
	 * @param id GameElementID
	 * @param TAG GameElement̃^O
	 * @param gameWorld gameWorldQƃ|C^
	 */
	Creature::Creature(ID id, TAG tag, GameWorld *gameWorld);

	/*! 
	 * @brief CreatureNXRXgN^
	 */
	Creature::Creature(void);

	/*! 
	 * @brief CreatureNXfXgN^
	 */
	Creature::~Creature(void);

	/*!
	 * @brief N[`[̖OԂ
	 * @return N[`[
	 */
	const string Creature::GetName(void);

	/*!
	 * @brief N[`[ĂԂԂ
	 * @return ĂȂtrueԂ
	 */
	bool Creature::IsAlive(void);

	/*!
	 * @brief 󂯂ʂ
	 * @param effectPtr
	 * @param amount
	 */
	bool Creature::TakeEffect(Effect* effectPtr, POWER amount);

	/*! 
	 * @brief N[`[̌xԂ
	 * @return N[`[̌x
	 */
	LEVEL Creature::GetLevel(void);

	/*!
	 * @brief N[`[̌HPԂ
	 * @return N[`[̌HP
	 */
	const HP Creature::GetCurHP(void);

	/*!
	 * @brief N[`[̌őHPԂ
	 * @return N[`[̌őHP
	 */
	const HP Creature::GetMaxHP(void);

	/*!
	 * @brief N[`[̒ʏőHPԂ
	 * @return N[`[̒ʏőHP
	 */
	const HP Creature::GetNorMaxHP(void);

	/*!
	 * @brief N[`[̌MPԂ
	 * @return N[`[̌MP
	 */
	const MP Creature::GetCurMP(void);

	/*!
	 * @brief N[`[̌őMPԂ
	 * @return N[`[̌őMP
	 */
	const MP Creature::GetMaxMP(void);

	/*!
	 * @brief N[`[̒ʏőMPԂ
	 * @return N[`[̒ʏőMP
	 */
	const MP Creature::GetNorMaxMP(void);

	/*!
	 * @brief N[`[̌bZ[rOlԂ
	 * @return N[`[̌bZ[rOl
	 */
	const AC Creature::GetArmorSaving(void);

	/*!
	 * @brief N[`[̌Z[rOlԂ
	 * @return N[`[̌Z[rOl
	 */
	const EV Creature::GetEvasionSaving(void);

	/*!
	 * @brief N[`[̌ӎvZ[rOlԂ
	 * @return N[`[̌ӎvZ[rOl
	 */
	const VO Creature::GetVolitionSaving(void);

	/*!
	 * @brief N[`[݈̌ʒuԂ
	 * @return N[`[݈ʒuCoordinates
	 */
	const Coordinates *Creature::getCorrdinates(void);

	/*!
	 * @brief N[`[̏iXgԂ
	 * @return N[`[iXg}bv
	 */
	const map<ID, TAG, Item> *Creature::getItemList(void);

	/*!
	 * @brief N[`[̌\ElԂ
	 * @return N[`[̌\El
	 */
	const SOUL Creature::GetCurrentSoul(void);

	/*!
	 * @brief N[`[̃\Eő哞BlԂ
	 * @return N[`[̃\Eő哞Bl
	 */
	const SOUL Creature::GetMaxSoul(void);

	/*!
	 * @brief N[`[̌b\͒lԂ
	 * @param stat 擾b\͒lID
	 * @return b\͒ľݒl
	 */
	const BASE_STATUS Creature::GetCurrentStatus(CREATURE_STATUS stat);

	/*!
	 * @brief N[`[̕b\͒lԂ
	 * @param stat 擾\͒lID
	 * @return b\͒l̕l
	 */
	const BASE_STATUS Creature::GetMaxStatus(CREATURE_STATUS stat);

	/*!
	 * @brief N[`[̌Eb\͒lԂ
	 * @param stat 擾E\͒lID
	 * @return b\͒ľEl
	 */
	const BASE_STATUS Creature::GetMaxMAXStatus(CREATURE_STATUS stat);

	/*!
	 * @brief N[`[̌ݏC{lԂ
	 * @param stat 擾ݏC{lID
	 * @return ݏC{l
	 */
	const int Creature::GetDiscipilnePoint(DISCIPLINE_TYPE typ);

	/*!
	 * @brief N[`[̌ݏC{NԂ
	 * @param stat 擾ݏC{NID
	 * @return ݏC{N
	 */
	const int Creature::GetDiscipilneRank(DISCIPLINE_TYPE typ);

	/*!
	 * @brief N[`[̐gԂ
	 * @param stat 擾ݏC{NID
	 * @return g
	 */
	const HEIGHT Creature::GetHeight(void);

	/*!
	 * @brief N[`[̑̏dԂ
	 * @return ̏d
	 */
	const WEIGHT Creature::GetWeight(void);

	/*!
	 * @brief N[`[̑̊ilԂ
	 * @return ̊il
	 */
	const BODY_SIZE Creature::GetSize(void);

	/*!
	 * @brief \El̐VKZ
	 * @plus VKZ\E
	 * @return Ȃ
	 */
	void Creature::GainSoul(SOUL plus);

	/*!
	 * @brief \El̑r
	 * @plus r\E
	 * @return Ȃ
	 */
	void Creature::LostSoul(SOUL amount);

	/*!
	 * @brief N[`[̐_xԂ
	 * @return _x
	 */
	const LEVEL Creature::GetDivineLevel(void);

	/*!
	 * @brief ݎ{lԂ
	 * @return ݎ{l
	 */
	const FEED Creature::GetCurrentFeedPoint(void);

	/*!
	 * @brief ő厠{lԂ
	 * @return ő厠{l
	 */
	const FEED Creature::GetMaxFeedPoint(void);

};

