﻿/*
 *  Original source:
 *  server invoked via inetd (multi-protocol support)
 *  by Jun-ichiro itojun Hagino. in public domain.
 *  http://www.v6pc.jp/jp/upload/pdf/socket-sample-20121203.pdf
 */
/*  Modification:
 *  2013-06-08  GMA0BN
 *      Ported to Windows Vista/7 (Winsock 2.0).
 *      (Slight change was required.)
 */
#include "stdafx.h"

#define MAXSOCK 20

WSADATA g_WSAData;

static const int TCTmoIn_ms = 60 * 1000;

int main(int argc, char* argv[])
{
    struct addrinfo hints, *res, *res0;
    struct sockaddr_storage from;
    socklen_t fromlen;
    SOCKET ls;
    SOCKET s[MAXSOCK];
    int scnt;
    int sockmax;
    fd_set rfd, rfd0;
    struct timeval tmv, tmv0;
    int i, n;
    char hbuf[NI_MAXHOST];
#ifdef IPV6_V6ONLY
    const int on = 1;
#endif
    int nRet;
    INT nErr;

    for (i = 0; i < MAXSOCK; ++i) {
        s[i] = INVALID_SOCKET;
    }

    nRet = WSAStartup(MAKEWORD(2,0), &g_WSAData);
    if (nRet != 0) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nERROR: WSAStartup() failed. (err=0x%08lx)\n", err);
        return EXIT_FAILURE;
    }

    if (argc != 2) {
        fprintf(stderr, "usage: %s <port>\n", argv[0]);
        goto on_error;
    }

    memset(&hints, 0, sizeof(hints));
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags = AI_PASSIVE;
    hints.ai_family = AF_UNSPEC;
    nErr = getaddrinfo(NULL, argv[1], &hints, &res0);
    if (nErr != 0) {
        fprintf(stderr, "\nERROR: " __FUNCTION__ ": %s\n", gai_strerrorA(nErr));
        goto on_error;
    }

    scnt = 0;
    sockmax = -1;
    for (res = res0; res && scnt < MAXSOCK; res = res->ai_next) {
        s[scnt] = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
        if (s[scnt] < 0) {
            continue;
        }
#if defined(_MSC_VER)
        /* NOP */
#else
        /* avoid FD_SET overrun */
        if (s[scnt] >= FD_SETSIZE) {
            closesocket(s[scnt]);
            s[scnt] = -1;
            continue;
        }
#endif
#ifdef IPV6_V6ONLY
        if (res->ai_family == AF_INET6) {
            nRet = setsockopt(s[scnt], IPPROTO_IPV6, IPV6_V6ONLY, (const char*)&on, sizeof(on));
            if (nRet == SOCKET_ERROR) {
                int err = WSAGetLastError();
                fprintf(stderr, "\nERROR: " __FUNCTION__ ": setsockopt() failed. (err=%d)\n", err);
                goto on_error;
            }
        }
#endif

        nRet = bind(s[scnt], res->ai_addr, res->ai_addrlen);
        if (nRet == SOCKET_ERROR) {
            int err = WSAGetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": bind() failed. (err=%d)\n", err);
            goto on_error;
        }

        nRet = listen(s[scnt], 5);
        if (nRet == SOCKET_ERROR) {
            int err = WSAGetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": listen() failed. (err=%d)\n", err);
            goto on_error;
        }

        if (s[scnt] > (SOCKET)sockmax) {
            sockmax = s[scnt];
        }

        ++scnt;
    }

    if (scnt <= 0) {
        fprintf(stderr, "\nWARNING: " __FUNCTION__ ": No socket to listen to.\n");
        goto exit_immediately;
    }

    FD_ZERO(&rfd0);
    for (i = 0; i < scnt; i++) {
        FD_SET(s[i], &rfd0);
    }

    tmv0.tv_sec  = (TCTmoIn_ms / 1000);
    tmv0.tv_usec = (TCTmoIn_ms % 1000) * 1000;

    for (;;) {
        // 受信待ち listening
        rfd = rfd0;
        tmv = tmv0;
        n = select(sockmax + 1, &rfd, NULL, NULL, &tmv);
        if (n == SOCKET_ERROR) {
            int err = WSAGetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": select() failed. (err=%d)\n", err);
            goto on_error;
        }

        // 処理 call-handling
        for (i = 0; i < scnt; ++i) {
            if (FD_ISSET(s[i], &rfd)) {
                fromlen = sizeof(from);
                ls = accept(s[i], (struct sockaddr*)&from, &fromlen);
                if (ls == INVALID_SOCKET) {
                    int err = WSAGetLastError();
                    fprintf(stderr, "\nWARNING: " __FUNCTION__ ": accept() failed. (err=%d)\n", err);
                    continue;
                }

                nErr = getnameinfo((struct sockaddr*)&from, fromlen, hbuf, sizeof(hbuf), NULL, 0, NI_NUMERICHOST);
                if (nErr != 0) {
                    int err = WSAGetLastError();
                    fprintf(stderr, "\nERROR: " __FUNCTION__ ": getnameinfo() failed. (err=%d)\n", err);
                    goto on_error;
                }

                send(ls, "Hello ", sizeof("Hello ") - 1, 0);
                send(ls, hbuf, strlen(hbuf), 0);
                send(ls, "\r\n", 1, 0);

                Sleep(1000);
                closesocket(ls);
            }
        }
    }

exit_immediately:
    for (i = 0; i < MAXSOCK; ++i) {
        if (s[i] != INVALID_SOCKET) {
            closesocket(s[i]);
        }
    }

    nRet = WSACleanup();
    if (nRet == SOCKET_ERROR) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nERROR: WSACleanup() failed. (err=0x%08lx)\n", err);
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;

on_error:
    for (i = 0; i < MAXSOCK; ++i) {
        if (s[i] != INVALID_SOCKET) {
            closesocket(s[i]);
        }
    }
    WSACleanup();
    return EXIT_FAILURE;
}
