﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
// TestClient.cpp : コンソール アプリケーションのエントリ ポイントを定義します。
//

#include "stdafx.h"
#include "TestClient.h"

#define TEST_ALL_CONNECTION     0
#define DATALENMAX              (RAND_MAX + 1)
#define NUMTHREADSMAX           1
/*= 現状sockutil_clモジュールの制限によりNUMTHREADSMAXを2以上にできない。
 *  (サーバ側で"ERROR: recv() failed. (err=10053)"が報告される。)
 *  これは、cli_enum_means()の先頭で、接続中のソケットを後始末しているためと思われる。
 *  Winsockの機能としては、同一サーバの同一ポートに対して複数スレッドから同時に
 *  connectできるようなので、sockutil_clで対策可能と思われる。
 *  TODO: 対策。
 */

WSADATA g_WSAData;

static const BOOL g_bAsync = FALSE;
volatile BOOL g_bTermClient;

static CRITICAL_SECTION g_syncRoot;

/// スレッドセーフなrand()。
int rand_safe(void)
{
    int nRet;

    EnterCriticalSection(&g_syncRoot);
    nRet = rand();
    LeaveCriticalSection(&g_syncRoot);

    return nRet;
}

/// クライアント機能を実現します。
unsigned __stdcall ClientThreadFunc(void* exinf)
{
    DWORD tickCnt;
    int nRet, i, n;
    ClientCB cb[MAXCONN];
    ClientCB* p;
    const char** argv;
    BOOL suc;

    argv = (char**)exinf;
    suc = TRUE;

    // Randomize
    tickCnt = GetTickCount();
    srand((unsigned)tickCnt);

    // クライアント機能初期化
    cli_init_sockutil();

    // 接続手段列挙
    nRet = cli_enum_means(argv[1], argv[2], cb, MAXCONN);
    if (nRet < 0) {
        suc = FALSE;
        goto exit_immediately;
    }
#if TEST_ALL_CONNECTION
    n = nRet;
#else
    n = (nRet > 0) ? 1 : 0;
#endif

    // 接続
    for (i = 0; i < n; ++i) {
        p = &(cb[i]);
        p->exinf2 = (void*)(rand_safe() % DATALENMAX);
        if (!cli_connect(p, SessionThreadFunc, g_bAsync)) {
            suc = FALSE;
        }
    }

    // 完了待ち
    if (!g_bAsync) {
        for (i = 0; i < n; ++i) {
            p = &(cb[i]);
            if (!cli_wai_cmpl(p)) {
                suc = FALSE;
            }
        }
    }

exit_immediately:
    return suc;
}

/// メイン。
int main(int argc, char* argv[])
{
    int i;
    int nRet;
    DWORD dwRet;
    uintptr_t upRet;
    BOOL suc;
    HANDLE ahClientThread[NUMTHREADSMAX];

    // コマンドライン引数チェック
    if (argc != 3) {
        fprintf(stderr, "usage: %s <host> <port>\n", argv[0]);
        return EXIT_FAILURE;
    }

    // Winsock初期化
    nRet = WSAStartup(MAKEWORD(2,0), &g_WSAData);
    if (nRet != 0) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nERROR: WSAStartup() failed. (err=0x%08lx)\n", err);
        return EXIT_FAILURE;
    }

    suc = TRUE;

    InitializeCriticalSection(&g_syncRoot);
    init_session_cl();

    for (i = 0; i < NUMTHREADSMAX; ++i) {
        // Clientスレッド起動
        g_bTermClient = FALSE;
        upRet = _beginthreadex(NULL, THREAD_STKSZ, ClientThreadFunc, argv, 0, NULL);
        if (upRet == 0) {
            perror(__FUNCTION__);
            suc = FALSE;
            goto exit_immediately;
        } else {
            ahClientThread[i] = (HANDLE)upRet;
        }
    }

    // 全Clientスレッド終了待ち
    for (i = 0; i < NUMTHREADSMAX; ++i) {
        // Clientスレッド[i]終了待ち
        dwRet = WaitForSingleObject(ahClientThread[i], INFINITE);
        if (dwRet != WAIT_OBJECT_0) {
            suc = FALSE;
            goto exit_immediately;
        }

        // スレッド終了コードチェック
        if (!GetExitCodeThread(ahClientThread[i], &dwRet)) {
            DWORD err = GetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": GetExitCodeThread() failed. (err=0x%08lx)\n", err);
            suc = FALSE;
            goto exit_immediately;
        } else if (!dwRet) {
            fprintf(stderr, "\nWarning: " __FUNCTION__ ": Client thread failed.\n");
        }
    }

exit_immediately:
    term_session_cl();

    // Winsock後始末
    nRet = WSACleanup();
    if (nRet == SOCKET_ERROR) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nWarning: " __FUNCTION__ ": WSACleanup() failed. (err=0x%08lx)\n", err);
    }

    DeleteCriticalSection(&g_syncRoot);

    return (suc) ? EXIT_SUCCESS : EXIT_FAILURE;
}
