﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#include "stdafx.h"
#include "EchoServer.h"

#define RECVBUFSZ   1024

/// セッションスレッドのサンプルです。(Echoサービスを行います。)
unsigned __stdcall SessionThreadFunc(void* exinf)
{
    ServerCB* p_cb;
    char buf[RECVBUFSZ];
    int i, n;
    char c;

    p_cb = (ServerCB*)exinf;

    // グリーティングメッセージ送信
    switch (p_cb->from.ss_family) {
    case AF_INET:
        {
            struct sockaddr_in* p = (struct sockaddr_in*)&(p_cb->from);
            assert(p->sin_family == AF_INET);
            n = sprintf_s(
                buf, sizeof(buf),
                "Hello. Session %d started. (Host=\"%s\", IP=0x%08lx, Address family AF_INET)\r\n",
                p_cb->sessionID,
                p_cb->hostName,
                ntohl(p->sin_addr.s_addr)
                );
        }
        break;
    case AF_INET6:
        {
            struct sockaddr_in6* p = (struct sockaddr_in6*)&(p_cb->from);
            assert(p->sin6_family == AF_INET6);
            n = sprintf_s(
                buf, sizeof(buf),
                "Hello. Session %d started. (Host=\"%s\", IP=%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x, Address family AF_INET6)\r\n",
                p_cb->sessionID,
                p_cb->hostName,
                ntohs(p->sin6_addr.u.Word[0]),
                ntohs(p->sin6_addr.u.Word[1]),
                ntohs(p->sin6_addr.u.Word[2]),
                ntohs(p->sin6_addr.u.Word[3]),
                ntohs(p->sin6_addr.u.Word[4]),
                ntohs(p->sin6_addr.u.Word[5]),
                ntohs(p->sin6_addr.u.Word[6]),
                ntohs(p->sin6_addr.u.Word[7])
                );
        }
        break;
    default:
        n = sprintf_s(
            buf, sizeof(buf),
            "Hello. Session %d started. (Host=\"%s\", Address family UNKNOWN(%d))\r\n",
            p_cb->sessionID,
            p_cb->hostName,
            p_cb->from.ss_family
            );
        break;
    };
    send(p_cb->res.socket, buf, n, 0);

    // エコーサービス
    if (n > 0) {
        memset(buf, 0, sizeof(buf));
        i = 0;
        for (;;) {
            do {
                n = recv(p_cb->res.socket, &c, 1, 0);   // 1文字づつ受信 (´Ａ`)
                if (n < 0) {
                    int err = WSAGetLastError();
                    fprintf(stderr, "\nERROR: recv() failed. (err=%d)\n", err);
                    goto last;
                } else if (n == 0) {
                    fprintf(stderr, "\nInfo: Connection closed.\n");
                    goto last;
                }
            } while (!(isprint(c) || c == '\r'));

            if (c != '\r') {
                if (i < RECVBUFSZ - 1) {
                    buf[i++] = c;
                }
                send(p_cb->res.socket, &c, 1, 0);       // 1文字づつ送信 (´Ａ`)
            } else {
                send(p_cb->res.socket, "\r\n", 2, 0);
                if (strcmp(buf, "bye") == 0) {
                    break;      // "bye\r"を受信したら終了
                } else {
                    memset(buf, 0, sizeof(buf));
                    i = 0;
                }
            }
        }
last:
        ;
    }

    return 0;
}
