﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
// TestClient.cpp : コンソール アプリケーションのエントリ ポイントを定義します。
//

#include "stdafx.h"
#include "EchoServer.h"

static const int TCTmoIn_ms = 1000;

WSADATA g_WSAData;

volatile BOOL g_bTermServer;

/// サーバ機能を実現します。
unsigned __stdcall ServerThreadFunc(void* exinf)
{
    SOCKET s[MAXLISTEN];
    int sockCnt;
    int nRet;
    char** argv;
    BOOL suc;

    argv = (char**)exinf;
    suc = TRUE;

    // サーバ機能初期化
    init_sockutil_sv();

    // Listen開始
    sockCnt = start_listen(argv[1], s, MAXLISTEN);
    if (sockCnt < 0) {
        suc = FALSE;
        goto exit_immediately;
    } else if (sockCnt <= 0) {
        fprintf(stderr, "WARNING: " __FUNCTION__ ": No socket to listen to.\n");
        goto exit_immediately;
    }

    // 接続を処理
    while (!g_bTermServer) {
        nRet = wait_connection(s, sockCnt, TCTmoIn_ms, SessionThreadFunc);
        if (nRet < 0) {
            suc = FALSE;
            goto exit_immediately;
        }
    }

exit_immediately:
    // スレッド完了待ち
    if (!wait_completion_all()) {
        suc = FALSE;
    }

    // サーバ機能後始末
    term_sockutil_sv();
    /*= この呼び出しで、start_listen()が返したlisten用ソケットも
     *  自動的にクローズされる。
     *  wait_completion_all()抜きでいきなり呼んでも良い。
     *  (内部でwait_completion_all()を呼ぶ。)
     */

    return suc;
}

/// メイン。
int main(int argc, char* argv[])
{
    int nRet;
    uintptr_t upRet;
    DWORD dwRet;
    HANDLE hServerThread;
    BOOL suc;

    // コマンドライン引数チェック
    if (argc != 2) {
        fprintf(stderr, "usage: %s <port>\n", argv[0]);
        return EXIT_FAILURE;
    }

    // Winsock初期化
    nRet = WSAStartup(MAKEWORD(2,0), &g_WSAData);
    if (nRet != 0) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nERROR: WSAStartup() failed. (err=0x%08lx)\n", err);
        return EXIT_FAILURE;
    }

    suc = TRUE;
    hServerThread = NULL;

    // Serverスレッド起動
    g_bTermServer = FALSE;
    upRet = _beginthreadex(NULL, THREAD_STKSZ, ServerThreadFunc, argv, 0, NULL);
    if (upRet == 0) {
        perror(__FUNCTION__);
        suc = FALSE;
        goto exit_immediately;
    } else {
        hServerThread = (HANDLE)upRet;
    }

    // 終了指令待ち
    while (getchar() != '#') {
        clearerr(stdin);
        dwRet = WaitForSingleObject(hServerThread, 0);
        if (dwRet != WAIT_TIMEOUT) {
            fprintf(stderr, "\nWarning: " __FUNCTION__ ": Server thread dead.\n");
            break;
        }
    }

    // Serverスレッド終了待ち
    g_bTermServer = TRUE;
    dwRet = WaitForSingleObject(hServerThread, INFINITE);
    if (dwRet != WAIT_OBJECT_0) {
        DWORD err = GetLastError();
        fprintf(stderr, "\nERROR: " __FUNCTION__ ": WaitForSingleObject() failed. (err=0x%08lx)\n", err);
        suc = FALSE;
        goto exit_immediately;
    }

    // スレッド終了コードチェック
    if (!GetExitCodeThread(hServerThread, &dwRet)) {
        DWORD err = GetLastError();
        fprintf(stderr, "\nERROR: " __FUNCTION__ ": GetExitCodeThread() failed. (err=0x%08lx)\n", err);
        suc = FALSE;
        goto exit_immediately;
    } else if (!dwRet) {
        fprintf(stderr, "\nWarning: " __FUNCTION__ ": Server thread failed.\n");
    }

exit_immediately:
    // Winsock後始末
    nRet = WSACleanup();
    if (nRet == SOCKET_ERROR) {
        int err = WSAGetLastError();
        fprintf(stderr, "\nWarning: WSACleanup() failed. (err=0x%08lx)\n", err);
    }

    return (suc) ? EXIT_SUCCESS : EXIT_FAILURE;
}
