package jp.operation.search;

import java.util.Random;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 自己組織化探索
 * 特徴
 *  O = n
 *  要素の並び順を探索試行毎に入れ替えて、より頻繁に探索されるものほど先頭に置かれるようにする。
 *
 * @author yasuda
 *
 */
public class SelfOrganizationSearchTest {

	private static final Logger log = LoggerFactory.getLogger(SelfOrganizationSearchTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * 探索用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("自己組織化探索準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testSelfOrganizationSearch() {
		
		log.debug("サーチ開始 : " + sort[N / 2]);
		int target = sort[N / 2];
		int pos = SelfOrganizationSearch.search(target, sort);
		Assert.assertEquals(target, sort[pos]);

	}

}