package jp.operation.search;

import java.util.Random;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * リニアサーチ（順検索、逐次検索）テスト
 * 特徴
 *  O = n
 *  データを一つ一つ順に端から調べるだけ
 *
 * @author yasuda
 *
 */
public class LenearSearchTest {

	private static final Logger log = LoggerFactory.getLogger(LenearSearchTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * 探索用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("リニアサーチ準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testLenearSearch() {
		
		log.debug("サーチ開始 : " + sort[N / 2]);
		int pos = LenearSearch.search(sort[N / 2], sort);
		Assert.assertEquals(sort[N / 2], sort[pos]);

	}

}