package jp.operation.search;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * LCSテスト
 *
 * @author yasuda
 *
 */
public class LCSTest {

	private static final Logger log = LoggerFactory.getLogger(LCSTest.class);

	private static List<Object[]> testData;
	
	@Before
	public void setup() {

		log.debug("LCS準備");
		Object[][] param = {
			{"BCBA", "BCBA".length(), "ABCBDAB", "BDCABA"},
			{"GTCGTCGGAAGCCGGCCGAA", "GTCGTCGGAAGCCGGCCGAA".length(), "ACCGGTCGAGTGCGCGGAAGCCGGCCGAA", "GTCGTTCGGAATGCCGTTGCTCTGTAAA"},
			{"SUZUKI", "SUZUKI".length(), "AMEASUZUKAI", "YSUZZUAKBI"},
			{"YSUZUKI", "YSUZUKI".length(), "YAMEASUZUKAI", "YSUZZUAKBI"},
		};
		
		testData = new ArrayList<Object[]>();
		for(int i = 0; i < param.length; i++) {
			Object[] val = {param[i][0], param[i][1], param[i][2], param[i][3]};
			testData.add(val);
		}
		
	}
	
	@Test
	public void testLongestCommonSubsequence() {
		
		log.debug("LCS開始 : ");
		for(int i = 0; i < testData.size(); i++) {
			LCS lcs = new LCS(testData.get(i)[2].toString(), testData.get(i)[3].toString());
			Assert.assertEquals(testData.get(i)[1], lcs.length());
			Assert.assertEquals(testData.get(i)[0], lcs.getText());
		}

	}

}