package jp.operation.search;

import java.util.Random;

import jp.operation.sort.QuickSort;
import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * バイナリサーチ（二分探索）テスト
 * 特徴
 *  O = log(n)
 *  ソート済みのリストや配列に入ったデータに対する検索を行うにあたって、
 *  中央の値を見て、検索したい値との大小関係を用いて、右にあるか、左にあるかを判断して、片側には存在しないことを確かめながら検索していく
 *
 * @author yasuda
 *
 */
public class BinarySearchTest {

	private static final Logger log = LoggerFactory.getLogger(BinarySearchTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * 探索用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("バイナリサーチ準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testBinarySearch() {
		
		// 事前ソート
		QuickSort qSort = new QuickSort();
		qSort.sort(sort);

		log.debug("サーチ開始 : " + sort[N / 2]);
		int pos = BinarySearch.search(sort[N / 2], sort);
		Assert.assertEquals(sort[N / 2], sort[pos]);

	}

}