package jp.operation.distance.vector;

import jp.operation.distance.vector.Mahalanobis;
import junit.framework.Assert;
import junit.framework.TestCase;

import org.apache.commons.math.DimensionMismatchException;
import org.junit.Before;
import org.junit.Test;


public class MahalanobisTest extends TestCase {

	private double[] p1 = {2.5d,2d,2d};
	private double[] p2 = {3d,3d,3d};
	private double[] p3 = {5d,6d,4.5d};
	private double[] p4 = {1d,1.5d,4.5d};
	private double[] p5 = {8d,7.5d,7.5d};
	private double[] p6 = {100d,1.5d,1.5d};
	private double[] p7 = {100d,100d,100d};
	
	@Before
	public void setup() {
		
	}
	
	@Test
	public void testManhattan() throws DimensionMismatchException {
		
		Mahalanobis maharanobis = new Mahalanobis(p1.length);
		// 相関のあるデータを追加
		maharanobis.add(p1);
		maharanobis.add(p2);
		maharanobis.add(p3);
		maharanobis.add(p4);
		maharanobis.add(p5);
		
		// 相関のあるデータの方が距離が近い
		Assert.assertEquals(true, maharanobis.distance(p6) > maharanobis.distance(p7));
		
	}
	
}