package jp.operation.structure.trie;

import java.util.Collection;

public interface Trie {

	void extractWords(Collection<Word> result, String context, boolean isDuplicatable);

	void extractStringWords(Collection<String> result, String context, boolean isDuplicatable);

	void extractIntWords(Collection<Integer> result, String context, boolean isDuplicatable);

	void build(Words words);

	void build(Collection<String> list);

	void add(Word word);

	void remove(String word);

	boolean contains(String str);

	int size();

}