package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * マージソート
 * 特徴
 *  O = n*log(n)
 *  最悪の計算量も n*log(n)で、安定ソートだが、O(n)の外部記憶(メモリ)を必要とする
 *
 * @author yasuda
 *
 */
public class MergeSort {

	private static final Logger log = LoggerFactory.getLogger(MergeSort.class);

	private int step = 0;

	public void sort(int[] data) {
		
		// 初期化
		int offset = 0;
		int N = data.length;
		
		mergeSort(N, data, offset);
		log.debug("ソート終了 step:" + step);

	}
	
	private void mergeSort(int length, int[] data, int offset) {

		if(length <= 1)
			return;

		int middle = length / 2;
		log.debug("middle=" + middle + ",offset=" + offset + ",length=" + length);

		// ブロックを前半と後半に分ける
		mergeSort(middle, data, offset);						// LEFT SIDE
		mergeSort(length - middle, data, offset + middle);		// RIGHT SIDE
		// マージ操作
		merge(data, offset, length);
		
	}

	private void merge(int[] data, int offset, int length) {
		
		int middle = length / 2;
		int[] leftSide = new int[middle];
		for(int i = 0; i < middle; i++) {
			leftSide[i] = data[offset + i];
		}

//		StringBuilder bufferData = new StringBuilder();
//		for(int i = 0; i < leftSide.length; i++) {
//			bufferData.append(leftSide[i] + " ");
//		}
//		log.debug("[LEFT SIDE] " + bufferData.toString());
		
		int rightAfterOffsetIndex = middle;
		int dataAfterOffsetIndex = 0;
		int leftAfterOffsetIndex = 0;
		while(leftAfterOffsetIndex < middle && rightAfterOffsetIndex < length) {
//			log.debug("leftSide[" + leftAfterOffsetIndex + "]=" + leftSide[leftAfterOffsetIndex]
//					+ ",rightSide[" + (rightAfterOffsetIndex - middle) + "]=" + data[offset + rightAfterOffsetIndex]
//					+ ",dataAfterOffsetIndex=" + dataAfterOffsetIndex
//					+ ",rightAfterOffsetIndex=" + rightAfterOffsetIndex);
//			StringBuilder beforeX = new StringBuilder();

			if(leftSide[leftAfterOffsetIndex] <= data[offset + rightAfterOffsetIndex]) {
//				log.debug("[ADD] x[" + offset + "+" + dataAfterOffsetIndex + "]=leftSide[" + leftAfterOffsetIndex + "]");
				data[offset + dataAfterOffsetIndex++] = leftSide[leftAfterOffsetIndex++];
			} else {
//				log.debug("[ADD] x[" + offset + "+" + dataAfterOffsetIndex + "]=rightSide[" + (rightAfterOffsetIndex - middle) + "]");
				data[offset + dataAfterOffsetIndex++] = data[offset + rightAfterOffsetIndex++];
			}
			step++;
			
			StringBuilder progress = new StringBuilder();
			for(int num = 0; num < data.length; num++) {
				progress.append(data[num] + " ");
			}
			log.debug("[PROGRESS] " + progress.toString());
		}

		while(leftAfterOffsetIndex < middle) {
//			log.debug("i=" + leftAfterOffsetIndex + ",middle=" + middle + ",leftSideAfterOffsetIndex=" + dataAfterOffsetIndex);
//			log.debug("[ADD END] x[" + offset + "+" + dataAfterOffsetIndex + "]=leftSide[" + leftAfterOffsetIndex + "]");
			data[offset + dataAfterOffsetIndex++] = leftSide[leftAfterOffsetIndex++];
			step++;
		}

		StringBuilder progress = new StringBuilder();
		for(int num = 0; num < data.length; num++) {
			progress.append(data[num] + " ");
		}
		log.debug("[PROGRESS] " + progress.toString());
	}

}
