package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * バブルソート改良版
 * 特徴
 *  O = n^2/2
 *  後方の配列要素は確実にソート済みなので、後方の検査を行わないように改良
 *
 * @author yasuda
 *
 */
public class BubbleSortImprovement {

	private static final Logger log = LoggerFactory.getLogger(BubbleSortImprovement.class);

	public static void sort(int[] sort) {

		boolean flag = false;
		int N = sort.length;		// データ件数
		int step = 0;

		int k = 0;
		do {
			flag = false;
			for(int i = 0; i < N - 1 - k; ++i) {
				if(sort[i] > sort[i + 1]) {
					flag = true;
					// 左右の並びがおかしければ入れ替える
					int j = sort[i];
					sort[i] = sort[i + 1];
					sort[i + 1] = j;
				}
				step++;
			}
			k++;

			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(sort[i] + " ");
			}
			log.debug(progress.toString());
	
		} while(flag);
		log.debug("ソート終了 step:" + step);

	}

}
