package jp.operation.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 自己組織化探索
 * 特徴
 *  O = n
 *  要素の並び順を探索試行毎に入れ替えて、より頻繁に探索されるものほど先頭に置かれるようにする。
 *
 * @author yasuda
 *
 */
public class SelfOrganizationSearch {

	private static final Logger log = LoggerFactory.getLogger(SelfOrganizationSearch.class);

	public static int search(int x, int[] list) {

		int step = 0;
		int n = 0;
		// 目的の値を探す
		while(n < list.length && list[n] != x) {
			step++;
			n++;
		}
		
		if(n < list.length) {
			log.debug("探索終了 step:" + step);
			if(n > 0) {
				// 1つ前と入れ替える
				int tmp = list[n - 1];
				list[n - 1] = list[n];
				list[n] = tmp;
				return n - 1;
			}
			return n;
		}
			
		// 一致するものは存在しなかった
		return -1;
		
	}

}