package jp.operation.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * LCS問題(Dynamic Programming implementation)
 * http://en.wikipedia.org/wiki/Longest_common_subsequence_problem
 * http://www.geeksforgeeks.org/archives/12998
 * 
 * O(m*n)
 * ※Naive recursive implementation is O(2^n)
 * 
 * @author yasuda_masahiro
 *
 */
public class LCS {

	private static final Logger log = LoggerFactory.getLogger(LCS.class);
	
	private String str1;
	private String str2;
	private int[][] lcsTable;
	private String lcsText;
	boolean finishFlg;
	
	@SuppressWarnings("unused")
	private LCS() {
	}
	
	public LCS(String str1, String str2) {
		this.str1 = str1;
		this.str2 = str2;
		this.lcsText = "";
	}

	public int length() {

		int len1 = str1.length();
		int len2 = str2.length();
		lcsTable = new int[len1][len2]; // LCS長を格納した表
		

		log.debug("LCS - " + str1 + ", " + str2);
		for (int i = 0; i < len1; i++) {
			for (int j = 0; j < len2; j++) {
				if (str1.charAt(i) == str2.charAt(j)) {
//					System.out.println("i=" + i + ",j=" + j + ",char=" + String.valueOf(str1.charAt(i)));
					lcsTable[i][j] = ((i == 0 || j == 0) ? 0 : lcsTable[i - 1][j - 1]) + 1;
				} else if (str1.charAt(i) != str2.charAt(j))
					lcsTable[i][j] = Math.max(i == 0 ? 0 : lcsTable[i - 1][j],
												j == 0 ? 0 : lcsTable[i][j - 1]);
			}
		}

		// LCS表の表示
		StringBuilder builder = new StringBuilder();
		builder.append("\n  ");
		for(char param : str2.toCharArray()) {
			builder.append(String.valueOf(param) + "  ");
		}
		builder.append("\n");
		
		for (int i = 0; i < len1; i++) {
			builder.append(str1.charAt(i) + " ");
			for (int j = 0; j < len2; j++) {
				String space = lcsTable[i][j] < 10 ? "  " : " "; 
				builder.append(lcsTable[i][j] + space);
			}
			builder.append("\n");
		}
		log.debug(builder.toString());

		// LCS表の最も右下にLCS長が格納されている
		return lcsTable[len1 - 1][len2 - 1];
	}
	
	public String getText() {
		backtrack(str1.length() - 1, str2.length() - 1);
		return lcsText;
	}

	private void backtrack(int len1, int len2) {

//		log.info(len1 + "," + len2 + "," + this.lcsText);
		if(finishFlg) {
			return;
		} else if(len1 > 0 && len2 < 0) {
			len2 = 0;
			len1--;
		} else if(len1 < 0 && len2 > 0) {
			len1 = 0;
			len2--;
		}
//		log.info(String.valueOf(str1.charAt(len1)) + "," + String.valueOf(str2.charAt(len2)) + "," + this.lcsText);


		if(str1.charAt(len1) == str2.charAt(len2) && (len1 == 0 || len2 == 0)) {
			lcsText += str1.charAt(len1);
			finishFlg = true;
		} else if(str1.charAt(len1) == str2.charAt(len2)) {
			backtrack(len1 - 1, len2 - 1);
			lcsText += str1.charAt(len1);
		} else if(len1 == 0 && len2 == 0) {
			return;
		} else if(len1 == 0) {
			backtrack(len1, len2 - 1);
		} else if(len2 == 0) {
			backtrack(len1 - 1, len2);
		} else if(lcsTable[len1 - 1][len2] >= lcsTable[len1][len2 - 1]) {
			backtrack(len1 - 1, len2);
		} else {
			backtrack(len1, len2 - 1);
		}

	}

}