package jp.operation.distance.vector;

import jp.operation.stat.Variance;

/**
 * copy from commons-math
 * n次元ユークリッド空間上でのベクトルx,yであらわされる２点の幾何学的な直線距離
 * 
 * @author yasuda_masahiro
 *
 */
public class Euclidean implements Minkowski {

    /**
     * Calculates the L<sub>2</sub> (Euclidean) distance between two points.
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>2</sub> distance between the two points
     */
    public static double distance2(double[] p1, double[] p2) {
        double sum = 0;
        for (int i = 0; i < p1.length; i++) {
            final double dp = p1[i] - p2[i];
            sum += dp * dp;
        }
        return Math.sqrt(sum);
    }

    /**
     * Calculates the L<sub>2</sub> (Euclidean) distance between two points.
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>2</sub> distance between the two points
     */
    public static double distance2(int[] p1, int[] p2) {
      double sum = 0;
      for (int i = 0; i < p1.length; i++) {
          final double dp = p1[i] - p2[i];
          sum += dp * dp;
      }
      return Math.sqrt(sum);
    }


    /**
     * Calculates the L<sub>2</sub> (Standard Euclidean) distance between two points.
     *　標準ユークリッド距離
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>2</sub> distance between the two points
     */
	public static double standardDistance2(int[] p1, int[] p2) {

        Variance[] v = new Variance[p1.length];
        for (int i = 0; i < p1.length; i++) {
        	Variance variance = new Variance();
        	variance.increment(p1[i]);
        	variance.increment(p2[i]);
        	v[i] = variance;
        }

        double sum = 0;
        for (int i = 0; i < p1.length; i++) {
            final int dp = p1[i] - p2[i];
            sum += (dp * dp) / v[i].getSampleVariance();
        }
        return Math.sqrt(sum);
    }

    /**
     * Calculates the L<sub>2</sub> (Standard Euclidean) distance between two points.
     *　標準ユークリッド距離
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>2</sub> distance between the two points
     */
	public static double standardDistance2(double[] p1, double[] p2) {

        Variance[] v = new Variance[p1.length];
        for (int i = 0; i < p1.length; i++) {
        	Variance variance = new Variance();
        	variance.increment(p1[i]);
        	variance.increment(p2[i]);
        	v[i] = variance;
        }

        double sum = 0;
        for (int i = 0; i < p1.length; i++) {
            final double dp = p1[i] - p2[i];
            sum += (dp * dp) / v[i].getSampleVariance();
        }
        return Math.sqrt(sum);
    }

}
