﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Tateyomi_Support
{
    public partial class Console : Form
    {
        /// <summary>
        /// 初期化処理。
        /// </summary>
        public Console()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 「生成」ボタンを押したときの処理。
        /// </summary>
        private void Generate_Click(object sender, EventArgs e)
        {
            resultText.Text = "";

            String[] tateyomi = this.makeStringArray(Tateyomi.Text);
            String[] result = { "", "", "", "", "", "", "", "", "", "" };

            //resultTextの左側に1文字ずつ配置する。
            char01.Text = tateyomi[0];
            char02.Text = tateyomi[1];
            char03.Text = tateyomi[2];
            char04.Text = tateyomi[3];
            char05.Text = tateyomi[4];
            char06.Text = tateyomi[5];
            char07.Text = tateyomi[6];
            char08.Text = tateyomi[7];
            char09.Text = tateyomi[8];
            char10.Text = tateyomi[9];

            //入力された文章を後ろから、縦読み文字列の最後の文字から順に検索する。
            String source = sourceText.Text;
            for (int i = tateyomi.Length - 1; i > -1; i--)
            {
                int index = source.LastIndexOf(tateyomi[i]);
                if (index != -1 && !tateyomi[i].Equals(""))
                {
                    result[i] = source.Substring(index, source.Length - index);
                    source = source.Remove(index, source.Length - index);
                }
                else if (index != -1 && tateyomi[i].Equals(""))
                {
                    result[i] = "";
                }
                else
                {
                    result[i] = "（足りない）";
                }
            }

            //格納された分割結果をresultTextに出力する。
            for (int j = 0; j < result.Length; j++)
            {
                resultText.AppendText(result[j] + System.Environment.NewLine);
            }
        }

        /// <summary>
        /// 縦読み文字列をString[]に格納します。
        /// 縦読み文字列は入力時点で10文字までに制限されています。
        /// </summary>
        /// <param name="target">(String)縦読み文字列</param>
        /// <returns>(String[])縦読み文字列を1文字ずつ格納した配列</returns>
        private String[] makeStringArray(String target)
        {
            String[] stringArray = { "", "", "", "", "", "", "", "", "", "" };
            int length = target.Length;

            try
            {
                for (int i = 0; i < length; i++)
                {
                    stringArray[i] = target.Substring(i, 1);
                }
            }
            catch (Exception exception)
            {
                //何かするべきか。
            }

            return stringArray;
        }

    }
}
