#ifndef XPMHEADER_H_
#define XPMHEADER_H_
#include "VioletVreath.h"
#include "jp/ggaf/core/GgafObject.h"

#include <map>
#include <vector>

namespace VioletVreath {

/**
 * ȈXPM(Pixmap)xNX .
 * @version 1.00
 * @since 2013/07/16
 * @author Masatoshi Tsuge
 */
class XpmHeader : public GgafCore::GgafObject {
public:
    /** [r] */
    int columns_;
    /** [r]s */
    int rows_;
    /** [r]F */
    int colors_;
    /** [r]Fł͖sNZ̐ */
    int num_color_pixels_;
    /** [r]sNZ̕ */
    char c_px_non_;
    /** [r]sNZF̔̕z */
    std::vector<char> c_px;
    /** [r]sNZF̕ɑΉAۂRGBl */
    std::map<char, GgafCore::GgafRgb*> c_rgb_;
    const char** xpm_hd_;
    const char** pixels_;
public:
    /**
     * RXgN^ .
     * @param prm_xpm Pixmapւ̃|C^BlێȂ̂ŃXR[vɒӁB(static Ȃǂz)
     */
    XpmHeader(const char** prm_xpm);

    /**
     * Pixmap̗񐔂擾 .
     * @return 
     */
    inline int getColumns() {
        return columns_;
    }

    /**
     * Pixmap̍s擾 .
     * @return s
     */
    inline int getRows() {
        return rows_;
    }

    /**
     * Pixmap̂ĂF̐擾 .
     * @return F̐
     */
    inline int getColorNum() {
        return colors_;
    }

    /**
     * Pixmap̃sNZ̐(F)擾 .
     * @return
     */
    inline int getPixelNum() {
        return num_color_pixels_;
    }

    /**
     * Pixmap̎w̃sNZ̐F擾 .
     * @param prm_row sڂw
     * @param prm_col ڂw
     * @return F
     */
    inline GgafCore::GgafRgb* getColor(int prm_row, int prm_col) {
        return c_rgb_[pixels_[prm_row][prm_col]];
    }

    /**
     * Pixmap̎w̃sNZ̐FFۂ擾 .
     * @param prm_row sڂw
     * @param prm_col ڂw
     * @return true:F / false:FȊO
     */
    inline bool isNonColor(int prm_row, int prm_col) {
        if (pixels_[prm_row][prm_col] == c_px_non_) {
            return true;
        } else {
            return false;
        }
    }

    virtual ~XpmHeader();
};
}
#endif /*XPMHEADER_H_*/
