#include "jp/ggaf/lib/util/spline/FixedFrameSplineManufacture.h"

#include "jp/ggaf/lib/util/spline/SplineLine.h"
#include "jp/ggaf/lib/util/spline/FixedFrameSplineKurokoLeader.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

FixedFrameSplineManufacture::FixedFrameSplineManufacture(const char* prm_source_file,
                                                         frame prm_spent_frame,
                                                         angvelo prm_angveloRzRyMv,
                                                         int prm_turn_way,
                                                         bool prm_turn_optimaize) :
        SplineManufacture(prm_source_file) {
    _spent_frame = prm_spent_frame;
    _angveloRzRyMv = prm_angveloRzRyMv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;

    //PԂ̎gp\t[
    _frame_of_segment = 1.0*_spent_frame / (_sp->_rnum-1);
    if (_frame_of_segment < 1.0) {
        _TRACE_("xFixedFrameSplineManufacture ["<<prm_source_file<<"] _frame_of_segment="<<_frame_of_segment<<" < 1.0f łB"<<
                "⊮_("<<(_sp->_rnum)<<")An_`I_t[("<<_spent_frame<<")̂ŁA⊮_̔тȂ߁AI_frame_of_segment1.0ɏ㏑B"<<
                "]Ĉړɂ"<<(_sp->_rnum)<<"t[܂BB");
        _frame_of_segment = 1.0;
    }
    _paSPMvVeloTo = NEW velo[_sp->_rnum];
}

FixedFrameSplineManufacture::FixedFrameSplineManufacture(SplineSource* prm_pSplSrc,
                                                         frame prm_spent_frame,
                                                         angvelo prm_angveloRzRyMv,
                                                         int prm_turn_way,
                                                         bool prm_turn_optimaize) :
      SplineManufacture(prm_pSplSrc) {
    _spent_frame = prm_spent_frame;
    _angveloRzRyMv = prm_angveloRzRyMv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;

    //PԂ̎gp\t[
    _frame_of_segment = 1.0*_spent_frame / (_sp->_rnum-1);
    if (_frame_of_segment < 1.0) {
        _TRACE_("xFixedFrameSplineManufacture  _frame_of_segment="<<_frame_of_segment<<" < 1.0f łB"<<
                "⊮_("<<(_sp->_rnum)<<")An_`I_t[("<<_spent_frame<<")̂ŁA⊮_̔тȂ߁AI_frame_of_segment1.0ɏ㏑B"<<
                "]Ĉړɂ"<<(_sp->_rnum)<<"t[܂BB");
        _frame_of_segment = 1.0;
    }
    _paSPMvVeloTo = NEW velo[_sp->_rnum];
}


void FixedFrameSplineManufacture::calculate() {
    //̂Q̃e[uČvZXV܂B
    // _paDistance_to[] : ̕⊮_܂ł̋
    // _paSPMvVeloTo[] : ̕⊮_BɕKvȑx

    //e_̎_́AƑx\ߑS߂Ă
    // _[2][3] = { {1000,2000,3000}, {2000,1000,0}, {3900, 0, 1000} }
    // point_num = 3          //_̐
    // accuracy = 0.25(=1/4)  //⊮_x
    // spent_frame = 120      //₷t[
    // ̏ꍇA}̂悤ɂȂ܂B
    //
    // X:_
    // o:_Ԃ̕⊮_iXvCȐʉߓ_j
    // X--o: ړ\̍W
    // _paDistance_to[] : ̕⊮_܂ł̋
    // _paSPMvVeloTo[] : ̕⊮_BɕKvȑx
    //
    // sp._rnum ͍v̓_̐ԂB sp._rnum = 9 ɂȂB
    // accuracy YȕɂȂȂꍇA_ɕ⊮_J邩ƂAʓ|Ȃ̂ŁAsp._rnumKgp
    // }YɏdȂꍇ̐}łB
    //
    //           v = _paSPMvVeloTo[1]                           v = _paSPMvVeloTo[8]
    //               _paDistance_to[1]     _paDistance_to[5]          _paDistance_to[8]
    //                    ||                     ||                         ||
    //                   <-->                 <------>                    <----->
    //                  X----o----o----o-----X--------o---------o--------o-------X
    //                  ^                    ^        ^                          ^
    //                  |                    |        |                          |
    //            (sp._x_compute[0],         | (sp._x_compute[5],        sp._x_compute[8]
    //             sp._y_compute[0],         |  sp._y_compute[5],        sp._y_compute[8]
    //             sp._z_compute[0])         |  sp._z_compute[5])        sp._z_compute[8]
    //                  |                    |                                   |
    //              (_[0][0],       (_[1][0],                       (_[2][0],
    //               _[0][1],        _[1][1],                        _[2][1],
    //               _[0][2])        _[1][2])                        _[2][2])
    //            = (1000,2000,3000)    = (2000,1000,0)                      = (3900, 0, 1000)
    //
    //                 <--------------------------------------------------------->
    //                                 120Frame₵Ĉړ(=_spent_frame)
    //                  <-->
    //                  _spent_frame = PԂ 120/8 Frame = _spent_frame / (sp._rnum-1);
    SplineManufacture::calculate();
    int rnum = _sp->_rnum;
    for (int t = 1; t < rnum; t++) {
        // paDistanceTo[t] Afrm_segment ňړ邽߂ɕKvȑx߂B
        //
        _paSPMvVeloTo[t] = ((velo)(_paDistance_to[t] / _frame_of_segment)) + 1; //+1͐؂グ
    }
    _paSPMvVeloTo[0] = 0; //n_܂ł̑xȂǕȂB
    _paDistance_to[0] = 0;   //n_܂ł̋ȂǕȂB
}

SplineKurokoLeader* FixedFrameSplineManufacture::createKurokoLeader(GgafDxCore::GgafDxKuroko* const prm_pKuroko) {
    return NEW FixedFrameSplineKurokoLeader(this, prm_pKuroko);
}

FixedFrameSplineManufacture::~FixedFrameSplineManufacture() {
    //CjVCYOɉ邩Ȃ
    GGAF_DELETEARR_NULLABLE(_paDistance_to);
    //CjVCYOɉ邩Ȃ
    GGAF_DELETEARR_NULLABLE(_paSPMvVeloTo);
}
