#ifndef GGAFLIB_SPLINELINE_H_
#define GGAFLIB_SPLINELINE_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <math.h>
#define MaxSplineSize 1001

namespace GgafLib {

/**
 * B-XvCȐNX .
 * <pre>
 * {NXIshida So 쐬̃TvQlɍ쐬܂B
 * @\IȃTv쐬ꂽIshida SoɊӂ܂B
 * QlTCg
 * uSamayou Oharikuiv
 * http://www5d.biglobe.ne.jp/~stssk/
 * ̃Rec
 * uȗRXvCȐ̐@v
 * http://www5d.biglobe.ne.jp/~stssk/maze/spline.html
 * </pre>
 * @version 1.00
 * @since 2009/10/16
 * @author Masatoshi Tsuge
 */
class SplineLine : public GgafCore::GgafObject {

public:
    /**
     * ȈՂRXvC .
     */
    class BSpline {
    public:
        int num;
        double a[MaxSplineSize + 1], b[MaxSplineSize + 1], c[MaxSplineSize + 1], d[MaxSplineSize + 1];
    public:
        BSpline() {
            num = 0;
        }
        void init(double *sp, int spnum) {
            double tmp, w[MaxSplineSize + 1];
            int i;
            num = spnum - 1;
            // R0W(a)ݒ
            for (i = 0; i <= num; i++) {
                a[i] = sp[i];
            }
            // R2W(c)vZ
            // AB
            // AAʉ@łȂXvCvZɃ`[jO@
            c[0] = c[num] = 0.0;
            for (i = 1; i < num; i++) {
                c[i] = 3.0 * (a[i - 1] - 2.0 * a[i] + a[i + 1]);
            }
            // 
            w[0] = 0.0;
            for (i = 1; i < num; i++) {
                tmp = 4.0 - w[i - 1];
                c[i] = (c[i] - c[i - 1]) / tmp;
                w[i] = 1.0 / tmp;
            }
            // E
            for (i = num - 1; i > 0; i--) {
                c[i] = c[i] - c[i + 1] * w[i];
            }
            // R1W(b)3W(b)vZ
            b[num] = d[num] = 0.0;
            for (i = 0; i < num; i++) {
                d[i] = (c[i + 1] - c[i]) / 3.0;
                b[i] = a[i + 1] - a[i] - c[i] - d[i];
            }
        }
        double compute(double t) {
            int j;
            double dt;
            j = (int)floor(t); // _ȉ؎̂
            if (j < 0) j = 0;
            else if (j >= num) j = num - 1; // ۂߌ덷l

            dt = t - (double)j;
            return a[j] + (b[j] + (c[j] + d[j] * dt) * dt) * dt;
        }
    };

    struct RotMat {
        double _11, _12, _13, _14;
        double _21, _22, _23, _24;
        double _31, _32, _33, _34;
        double _41, _42, _43, _44;
        RotMat() {
            _11 = 1.0; _12 = 0.0; _13 = 0.0; _14 = 0.0;
            _21 = 0.0; _22 = 1.0; _23 = 0.0; _24 = 0.0;
            _31 = 0.0; _32 = 0.0; _33 = 1.0; _34 = 0.0;
            _41 = 0.0; _42 = 0.0; _43 = 0.0; _44 = 1.0;
        }
        void set(double d11, double d12, double d13, double d14,
                 double d21, double d22, double d23, double d24,
                 double d31, double d32, double d33, double d34,
                 double d41, double d42, double d43, double d44 ) {
            _11 = d11; _12 = d12; _13 = d13; _14 = d14;
            _21 = d21; _22 = d22; _23 = d23; _24 = d24;
            _31 = d31; _32 = d32; _33 = d33; _34 = d34;
            _41 = d41; _42 = d42; _43 = d43; _44 = d44;
        }
    };
public:
    /**
     * RXgN^ .
     *  init() ĂяoĉB
     */
    SplineLine();

    /**
     * RXgN^ .
     *  init() ĂяoȂėǂB
     * @param prm_paaBase _W̔z
     *                    [][0] XW
     *                    [][1] YW
     *                    [][2] ZW
     * @param num         _W̔z
     * @param prm_accuracy ⊮_}xB
     *                     1.0ŕ⊮_ȂB
     *                     0.5Ő_Ԓ_ǉB
     *                     0.11_Ԃ10_⊮AƂ
     * @return
     */
    SplineLine(double prm_paaBase[][3], int num, double prm_accuracy);

    SplineLine(double prm_paaBase[][3], int num, double prm_accuracy, RotMat& prm_rotmat);

    /**
     * ⊮_AgpłԂɂ܂ .
     * @param prm_paaBase _W̔z
     *                    [][0] XW
     *                    [][1] YW
     *                    [][2] ZW
     * @param num         _W̔z
     * @param prm_accuracy ⊮_}xB
     *                     1.0ŕ⊮_ȂB
     *                     0.5Ő_Ԓ_1ǉB
     *                     0.11_Ԃ9̕⊮_AƂ
     */
    void init(double prm_paaBase[][3], int num, double prm_accuracy);
    void init(double prm_paaBase[][3], int num, double prm_accuracy, RotMat& prm_rotmat);
    /**
     * ⊮_vZ
     * @param prm_accuracy ⊮_}xB
     *                     1.0ŕ⊮_ȂB
     *                     0.5Ő_Ԃɒ_1ǉB
     *                     0.1Ɛ_Ԃ9̕⊮_AƂ
     */
    void compute(double prm_accuracy);

    /** _XW̔z */
    double* _x_basepoint;
    /** _YW̔z */
    double* _y_basepoint;
    /** _ZW̔z */
    double* _z_basepoint;
    /** _W */
    int _num_basepoint;

    BSpline _xs;
    BSpline _ys;
    BSpline _zs;

    /** ⊮_i_܂ށjXW̔z */
    double* _x_compute;
    /** ⊮_i_܂ށjYW̔z */
    double* _y_compute;
    /** ⊮_i_܂ށjZW̔z */
    double* _z_compute;
    /** ⊮_W */
    int _rnum;
    /** ⊮x(1.0 Ő_⊮_A0.5 ŁA_Ԃɕ⊮_P}A0.1ŕ⊮_X */
    double _accuracy;

    virtual ~SplineLine();

};

}
#endif /*GGAFLIB_SPLINELINE_H_*/

