#include "Stage01WalledScene.h"

#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/dxcore/scene/supporter/GgafDxBgmPerformerForScene.h"
#include "jp/ggaf/lib/actor/WallAABActor.h"
#include "jp/ggaf/lib/scene/FormationTableScene.h"
#include "Stage01WalledSection001.h"
#include "jp/gecchi/VioletVreath/actor/chikei/wall/Wall001.h"
#include "jp/gecchi/VioletVreath/actor/chikei/wall/Wall001Prism.h"
#include "jp/gecchi/VioletVreath/actor/VVEnemysHeader.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/CommonScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "../Stage01PartController.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

Stage01WalledScene::Stage01WalledScene(const char* prm_name) : WalledScene(prm_name) {
    _class_name = "Stage01WalledScene";

    //********* Ǐ ***********
    coord wall_dep    = DX_C(40);  //ǃubNfPX̕ݒiXt@Cɂ茈܂j
    coord wall_width  = DX_C(10);  //ǃubNfPZ̕ݒiXt@Cɂ茈܂j
    coord wall_height = DX_C(10);  //ǃubNfPY̕ݒiXt@Cɂ茈܂j
    float scale_r = 3.0f;        //ǃubN̊g嗦iŐݒ\j
    //****************************

    //ǃubN()f|Wg
    WallAABActor* pWallAABActor;
    GgafActorDepository* pDepo_wall = NEW GgafActorDepository("Dp_WallAAB");
    for (int i = 0; i < 2000; i++) {
        std::string name = "Wall001_"+XTOS(i);
        pWallAABActor = NEW Wall001(name.c_str());
        pWallAABActor->setScaleR(scale_r);
        pDepo_wall->put(pWallAABActor);
    }
    bringDirector()->addSubGroup(pDepo_wall);

    //ǃubN(vY)f|Wg
    WallAAPrismActor* pWallAAPrismActor;
    GgafActorDepository* pDepo_prism = NEW GgafActorDepository("Dp_WallAAPrism");
    for (int i = 0; i < 1000; i++) {
        std::string name = "Wall001Prism_"+XTOS(i);
        pWallAAPrismActor = NEW Wall001Prism(name.c_str());
        pWallAAPrismActor->setScaleR(scale_r);
        pDepo_prism->put(pWallAAPrismActor);
    }
    bringDirector()->addSubGroup(pDepo_prism);

//    //V[ZNV
//    WalledSectionScene* apSection[] = {
//        NEW Stage01WalledSection001("Stage01-001-0", this, "scene5_wall_0.dat"),
//        NEW Stage01WalledSection001("Stage01-001-1", this, "scene5_wall_1.dat"),
//        NEW Stage01WalledSection001("Stage01-001-2", this, "scene5_wall_2.dat"),
//        NEW Stage01WalledSection001("Stage01-001-3", this, "scene5_wall_3.dat"),
//        NEW Stage01WalledSection001("Stage01-001-4", this, "scene4_wall_0.dat"),
//        NEW Stage01WalledSection001("Stage01-001-5", this, "scene4_wall_1.dat"),
//        NEW Stage01WalledSection001("Stage01-001-6", this, "scene4_wall_2.dat"),
//        NEW Stage01WalledSection001("Stage01-001-7", this, "scene4_wall_3.dat"),
//    };
//    //\z
//    buildWalledScene(
//        wall_dep*scale_r, wall_width*scale_r, wall_height*scale_r,
//        P_GOD->getSpacetime()->_x_bound_right,
//        (WalledSectionScene**)&apSection, 8,
//        pDepo_wall ,pDepo_prism
//    );
    //V[ZNV
    WalledSectionScene* apSection[] = {
        NEW Stage01WalledSection001("Stage01-001-0", this, "scene4_wall_0.dat"),
        NEW Stage01WalledSection001("Stage01-001-1", this, "scene4_wall_1.dat"),
        NEW Stage01WalledSection001("Stage01-001-2", this, "scene4_wall_2.dat"),
        NEW Stage01WalledSection001("Stage01-001-3", this, "scene4_wall_3.dat"),
    };
    //\z
    buildWalledScene(
        wall_dep*scale_r, wall_width*scale_r, wall_height*scale_r,
        P_GOD->getSpacetime()->_x_bound_right,
        (WalledSectionScene**)&apSection, 4,
        pDepo_wall ,pDepo_prism
    );


    //XN[Xs[h
    setScrollSpeed(PX_C(5));

    // ȉ gen01 start ` end Excel}Nɂ莩ꂽR[hłB
    // R[h̕ύX́uV[Creater.xlsvsƂimۂ̂߁jB
    // gen01 start
    frame f[] = {1,100,1400,2000,5400,6000};
    _paFrame_NextEvent = new frame[6];
    memcpy(_paFrame_NextEvent, f, sizeof(f));
    _event_num = 6;
    orderActorToFactory(50000002, EnemyHisbe, "EnemyHisbe-50000002");
    // gen01 end
}

void Stage01WalledScene::initialize() {
    WalledScene::initialize(); //dvBǃf|Wg̏V[z
}

void Stage01WalledScene::onActive() {
    P_COMMON_SCENE->setScrollingFunction(_pFuncScrolling);
    P_COMMON_SCENE->setScrollSpeed(getScrollSpeed());
    _TRACE_(FUNC_NAME<<"  CommonScene ɂXN[ݒ肵܂B");
    //P_COMMON_SCENE->dump();
    WalledScene::onActive();
}

void Stage01WalledScene::processBehavior() {
    WalledScene::processBehavior();

    // ȉ gen02 start ` end Excel}Nɂ莩ꂽR[hłB
    // R[h̕ύX́uV[Creater.xlsvsƂimۂ̂߁jB
    // gen02 start
    if (getBehaveingFrame() == _paFrame_NextEvent[_cnt_event]) {
        switch (getBehaveingFrame()) {
            case 1: {
                break;
            }
            case 100: {
                EnemyHisbe* p = (EnemyHisbe*)obtainActorFromFactory(50000002);
                bringDirector()->addSubGroup(p);
                p->_x = PX_C(2000);
                p->_y = 0;
                p->_z = 1000000;
                //a
                break;
            }
            case 1400: {
                orderActorToFactory(50000000, FormationUnomia001a, "FormationUnomia001a-50000000");
                break;
            }
            case 2000: {
                bringDirector()->addSubGroup(obtainActorFromFactory(50000000));
                break;
            }
            case 5400: {
                orderActorToFactory(50000001, FormationUnomia001b, "FormationUnomia001b-50000001");
                break;
            }
            case 6000: {
                bringDirector()->addSubGroup(obtainActorFromFactory(50000001));
                break;
            }
            default :
                break;
        }
        _cnt_event = (_cnt_event < 6-1 ? _cnt_event+1 : _cnt_event);
    }
    // gen02 end

///////////////fobO///////////////////////////////
    if (GgafDxInput::isPressedKey(DIK_PGUP)) {
        addScrollSpeed(PX_C(1));
        P_COMMON_SCENE->addScrollSpeed(PX_C(1));
    }
    if (GgafDxInput::isPressedKey(DIK_PGDN)) {
        addScrollSpeed(PX_C(-1));
        P_COMMON_SCENE->addScrollSpeed(PX_C(-1));
    }
//////////////////////////////////////////////////////
}

void Stage01WalledScene::onFinishedAllSection() {
    _TRACE_(" Stage01WalledScene::onFinishedAllSection()  CommonScene ̃XN[܂B");
    P_COMMON_SCENE->setScrollingFunction(nullptr);
    P_COMMON_SCENE->setScrollSpeed(0);
    throwEventUpperTree(EVENT_STG01_WALLED_WAS_BROKEN);
}

Stage01WalledScene::~Stage01WalledScene() {

}
