#ifndef SPACETIME_H_
#define SPACETIME_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/scene/DefaultSpacetime.h"

#include "jp/gecchi/VioletVreath/actor/camera/Camera.h"
#include "jp/gecchi/VioletVreath/manager/CameraWorkerManager.h"
#include "jp/gecchi/VioletVreath/manager/CameraWorkerConnection.h"

/**
 * ̐ێ CameraWorkerManager ɐڑARlNV擾B
 * XFʕiCameraWorkerManager::processCreateResource(const char* prm_idstr, void* prm_pConnector)  prm_idstr ɓn)
 * pCAMERAFJn
 * ܂ACameraWorkerManager::processCreateResource(const char* prm_idstr, void* prm_pConnector)  prm_p ɂ nullptr ZbgĂB
 */
#define CAM_WORKER_STACK_NUM (30)

namespace VioletVreath {

/**
 * ̓IȂ̐ .
 * {NX́A̐̐U镑܂B<BR>
 * ɐE(World)foJ(Camera)ÃJ
 * ܂Ȑ䃁\bh܂B<BR>
 * @version 1.00
 * @since 2009/04/24
 * @author Masatoshi Tsuge
 */
class Spacetime : public GgafLib::DefaultSpacetime {

    class CameraWorkerHistory {
    public:
        CameraWorkerConnection* apCamWorkerConnection_[CAM_WORKER_STACK_NUM];
        uint32_t p_;
        CameraWorkerHistory();
        CameraWorkerConnection* getLast();
        void push(CameraWorkerConnection* prm_pCamWorkerCon);
        CameraWorkerConnection* pop();
        void clear();
        void dump();
        ~CameraWorkerHistory();
    };


public:
    /** [r]݂̃J} */
    GgafLib::CameraWorker* pActiveCamWorker_;
    /** [r]J}̃}l[W[ */
    CameraWorkerManager* pCamWorkerManager_;
    /** [r]J}̃X^bN */
    CameraWorkerHistory stack_CamWorkerConnection_;
    /** [r]E */
    World* pWorld_;

public:
    Spacetime(const char* prm_name, Camera* prm_pCamera);

    void initialize() override;

    void processBehavior() override;

    void processJudgement() override;

    /**
     * ݂̃J}Ԃ .
     * Ԃ́AftHgJ}(DefaultCamWorker)l܂B
     * @return ݂̃J}
     */
    GgafLib::CameraWorker* getActiveCamWorker() {
        return pActiveCamWorker_;
    }

    /**
     * J}ꎞIɐ؂ւ .
     * VJ}PlǉAɃJ̎哱؂ւ܂B
     * ȌAundoCameraWork() s܂ł̂܂܂łB
     * @param prm_pID VJ}IDiID CameraWorkerManager ɎOo^vj
     * @return VJ}
     */
    GgafLib::CameraWorker* changeCameraWork(const char* prm_pID);

    /**
     * ݂̃J}rAÕJ}ɖ߂B .
     * O changeCameraWork() PȏsĂKv܂B
     * @return XA߂̃J}
     */
    GgafLib::CameraWorker* undoCameraWork();

    /**
     * J}ZbgB
     *  changeCameraWork() sĂ悤ƁAftHgJ}(DefaultCamWorker)
     * Pl̏Ԃɖ߂܂B
     */
    void resetCamWorker();

    virtual Camera* getCamera() override { //ς̖߂l
        return (Camera*)_pCamera;
    }

    World* getWorld() {
        return pWorld_;
    }
    virtual ~Spacetime();
};

}
#endif /*SPACETIME_H_*/
