#include "EffectLaserMagic.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EffectLaserMagic::EffectLaserMagic(const char* prm_name) :
        DefaultSpriteActor(prm_name, "EffectLaserMagic", nullptr) {
    _class_name = "EffectLaserMagic";
    pScaler_ = NEW GgafDxScaler(this);
    effectBlendOne(); //ZTechnique
    setZEnableDraw(true);       //`掞AZobt@l͍l
    setZWriteEnable(false); //gZobt@݂Ȃ
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RzBxyzMv); //ϊsr{[h
    setHitAble(false);
}

void EffectLaserMagic::initialize() {
    setAlpha(0.9);
    getUvFlipper()->exec(FLIP_ORDER_LOOP, 1);
}

void EffectLaserMagic::onActive() {
}

void EffectLaserMagic::processBehavior() {
    getUvFlipper()->behave();
    getKuroko()->behave();
    pScaler_->behave();
}

void EffectLaserMagic::processJudgement() {
}

void EffectLaserMagic::onInactive() {
}

EffectLaserMagic::~EffectLaserMagic() {
    GGAF_DELETE(pScaler_);
}
