#include "MyBunshinWateringLaserChip001.h"

#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/Bunshin/MyBunshin.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/core/util/GgafResourceConnection.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/texture/GgafDxTexture.h"
#include "jp/ggaf/lib/actor/laserchip/WateringLaserChip.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/LaserMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/EffectLockon001_Main.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

const velo MyBunshinWateringLaserChip001::MAX_VELO_RENGE = PX_C(190); //̒l傫ƁAōxȂB
const int MyBunshinWateringLaserChip001::R_MAX_ACCE = 16; //̒l傫ƁAJ[uɂȂ
const velo MyBunshinWateringLaserChip001::INITIAL_VELO = MAX_VELO_RENGE*0.7; //[U[ˎ̏x
const double MyBunshinWateringLaserChip001::RR_MAX_ACCE = 1.0 / R_MAX_ACCE; //vZȑfp
const float MyBunshinWateringLaserChip001::MAX_ACCE_RENGE = MAX_VELO_RENGE/R_MAX_ACCE;

GgafDxCore::GgafDxModel* MyBunshinWateringLaserChip001::pModel_  = nullptr;
int MyBunshinWateringLaserChip001::tex_no_ = 0;


#define AIM_TIME_OUT (600)

MyBunshinWateringLaserChip001::MyBunshinWateringLaserChip001(const char* prm_name) :
        WateringLaserChip(prm_name, "MyLaserChip001", STATUS(MyBunshinWateringLaserChip001)) {
    _class_name = "MyBunshinWateringLaserChip001";
    pAxsMver_ = NEW GgafDxAxesMover(this);
    default_stamina_ = getStatus()->get(STAT_Stamina);
    pOrg_ = nullptr;
    pLockon_ = nullptr;
    is_lockon_ = false;
    GgafDxModel* pModel = getModel();
    if (!MyBunshinWateringLaserChip001::pModel_) {
        if (pModel->_num_materials != MAX_LASER_LEVEL) {
            throwGgafCriticalException("MyBunshinWateringLaserChip001f́AeNX`i}eAj"<<MAX_LASER_LEVEL<<"KvłB");
        }
        MyBunshinWateringLaserChip001::pModel_ = pModel;
    }
    tmp_x_ = _x;
    tmp_y_ = _y;
    tmp_z_ = _z;
    tmp_acc_vx_ = tmp_acc_vy_ = tmp_acc_vz_ = 0;
    pAimInfo_ = nullptr;
}

void MyBunshinWateringLaserChip001::initialize() {
    getKuroko()->linkFaceAngByMvAng(true);
    registerHitAreaCube_AutoGenMidColli(40000);
    setHitAble(true);
    setScaleR(6.0);
    setAlpha(0.99);
    pAxsMver_->forceVxyzMvVeloRange(-MAX_VELO_RENGE, MAX_VELO_RENGE);
    pAxsMver_->forceVxyzMvAcceRange(-MAX_ACCE_RENGE, MAX_ACCE_RENGE);
}

void MyBunshinWateringLaserChip001::onCreateModel() {

}

void MyBunshinWateringLaserChip001::setOrg(MyBunshin* prm_pOrg) {
    pOrg_ = prm_pOrg;
    pLockon_ = pOrg_->pLockonCtrler_->pMainLockonEffect_;
}

void MyBunshinWateringLaserChip001::onActive() {
    getStatus()->reset();
    default_stamina_ = getStatus()->get(STAT_Stamina);
    WateringLaserChip::onActive();
    pAimInfo_ = nullptr;
}

void MyBunshinWateringLaserChip001::processBehavior() {
    frame active_frame = getActiveFrame();
    MyBunshin::AimInfo* pAimInfo = pAimInfo_;
    if (active_frame >= AIM_TIME_OUT*2) {
        sayonara(); //ی̃^CAEg
//        P_GAME_SCENE->pauseGame();
    } else if (active_frame < 6 || pAimInfo->pTarget == nullptr) {
        //ȂɂȂ
    } else {
        GgafDxGeometricActor* pAimTarget = pAimInfo->pTarget;
        if (pAimTarget) {

            //[`bvi\̂LeaderChipɂ炸IjAT1ς炸bNI^[QbgȂ΍XV
            if (getInfrontChip() == nullptr && pAimTarget == pLockon_->pTarget_ && pAimInfo_->_spent_frames_to_t1 < AIM_TIME_OUT) {
                pAimInfo->t1_x = pAimTarget->_x; //t1XV
                pAimInfo->t1_y = pAimTarget->_y;
                pAimInfo->t1_z = pAimTarget->_z;
            }

            MyBunshinWateringLaserChip001* pAimLeaderChip = pAimInfo->pLeaderChip_;
            if (this == pAimLeaderChip) {

                if (pAimInfo->_spent_frames_to_t1 == 0) {
                    //Leader  t1  Aim
                    if (pAimTarget->isActiveInTheTree() && active_frame < AIM_TIME_OUT)  {
                        //pAimTarget 
                        aimChip(pAimInfo->t1_x,
                                pAimInfo->t1_y,
                                pAimInfo->t1_z );
                        static const coord renge = MyBunshinWateringLaserChip001::MAX_VELO_RENGE;
                        if (_x >= pAimInfo->t1_x - renge) {
                            if (_x <= pAimInfo->t1_x + renge) {
                                if (_y >= pAimInfo->t1_y - renge) {
                                    if (_y <= pAimInfo->t1_y + renge) {
                                        if (_z >= pAimInfo->t1_z - renge) {
                                            if (_z <= pAimInfo->t1_z + renge) {
                                                 pAimInfo_->_spent_frames_to_t1 = getActiveFrame(); //Aim t1 I
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        //߂ pAimTarget ̂ɁArŏB
                        pAimInfo_->_spent_frames_to_t1 = getActiveFrame(); //Aim t1 I
                    }


                } else if (pAimInfo->_spent_frames_to_t2 == 0) {
                    //Leader  t1  Aim I
                    //t2߂
                    static const Spacetime* pSpaceTime =  P_GOD->getSpacetime();
                    static const double zf_r = UTIL::getDistance(
                                                      0.0, 0.0, 0.0,
                                                      (double)(pSpaceTime->_x_bound_right),
                                                      (double)(pSpaceTime->_y_bound_top),
                                                      (double)(pSpaceTime->_z_bound_far)
                                                     ) * 1.2;
                    MyBunshinWateringLaserChip001* pB = (MyBunshinWateringLaserChip001*)getBehindChip();
                    if (pB) {
                        pAimInfo->setT2(zf_r, pB->_x, pB->_y, pB->_z, _x, _y, _z);
                        pAimInfo->_spent_frames_to_t2 = getActiveFrame()+AIM_TIME_OUT;
                    } else {
                        pAimInfo->setT2(zf_r, pOrg_->_x, pOrg_->_y, pOrg_->_z, _x, _y, _z);
                        pAimInfo->_spent_frames_to_t2 = getActiveFrame()+AIM_TIME_OUT;
                    }
                    aimChip(pAimInfo->t2_x,
                            pAimInfo->t2_y,
                            pAimInfo->t2_z );
                } else {
                    //Leader  t2 ݒ肵ƁB
                    if (active_frame < AIM_TIME_OUT)  {
                        aimChip(pAimInfo->t2_x,
                                pAimInfo->t2_y,
                                pAimInfo->t2_z );
                    } else {
                        aimChip(_x + pAxsMver_->_velo_vx_mv*4+1,
                                _y + pAxsMver_->_velo_vy_mv*4+1,
                                _z + pAxsMver_->_velo_vz_mv*4+1 );
                    }
                }

            } else {
                //LeaderȊO
                if (pAimInfo->_spent_frames_to_t1 == 0) {
                    //LeaderȊO t1 ܂܂ł̓
                    aimChip(pAimInfo->t1_x,
                            pAimInfo->t1_y,
                            pAimInfo->t1_z );
                } else if (active_frame < pAimInfo->_spent_frames_to_t1) {
                    //LeaderȊO t1 ܂Ă t1 B܂ł̓
                    aimChip(pAimInfo->t1_x,
                            pAimInfo->t1_y,
                            pAimInfo->t1_z );
                } else if (active_frame >= pAimInfo->_spent_frames_to_t1) {
                    //LeaderȊO t1 ʉ
                    if (pAimInfo->_spent_frames_to_t2 == 0) {
                        //̌ LeaderȊO t2 ܂܂ł̓
                        if (pAimLeaderChip) {
                            aimChip(pAimLeaderChip->_x,
                                    pAimLeaderChip->_y,
                                    pAimLeaderChip->_z );
                        } else {
                            aimChip(_x + pAxsMver_->_velo_vx_mv*4+1,
                                    _y + pAxsMver_->_velo_vy_mv*4+1,
                                    _z + pAxsMver_->_velo_vz_mv*4+1 );
                        }
                    } else if (active_frame < pAimInfo->_spent_frames_to_t2) {
                        //̌ LeaderȊO t2 ܂āAt2Ɍ܂ł̓
                        aimChip(pAimInfo->t2_x,
                                pAimInfo->t2_y,
                                pAimInfo->t2_z );
                    } else if (active_frame >= pAimInfo->_spent_frames_to_t2) {
                        //̌ LeaderȊO t2 ʉ߂̓
                        if (pAimLeaderChip) {
                            aimChip(pAimLeaderChip->_x,
                                    pAimLeaderChip->_y,
                                    pAimLeaderChip->_z );
                        } else {
                            aimChip(_x + pAxsMver_->_velo_vx_mv*4+1,
                                    _y + pAxsMver_->_velo_vy_mv*4+1,
                                    _z + pAxsMver_->_velo_vz_mv*4+1 );
                        }
                    }
                }
            }

        }

    }

    pAxsMver_->behave();
    WateringLaserChip::processBehavior();
    tmp_x_ = _x;
    tmp_y_ = _y;
    tmp_z_ = _z;
    tmp_acc_vx_ =  pAxsMver_->_acce_vx_mv;
    tmp_acc_vy_ =  pAxsMver_->_acce_vy_mv;
    tmp_acc_vz_ =  pAxsMver_->_acce_vz_mv;
}

void MyBunshinWateringLaserChip001::processSettlementBehavior() {
    //gFKȂ̂ŁA΍W̊m肪 processSettlementBehavior() ȍ~ƂȂ邽߁Aŏݒ肪Kv
    if (hasJustChangedToActive()) {
        //`bv̏ݒ

        //bNÏp
        MyBunshinWateringLaserChip001* pF = (MyBunshinWateringLaserChip001*) getInfrontChip();
        if (pF == nullptr) {
            //[`bv
            GgafDxGeometricActor* pLockonTarget = pLockon_->pTarget_;
            if (pLockonTarget && pLockonTarget->isActiveInTheTree()) {
                //[ŃbNI
                pAimInfo_ = pOrg_->getAimInfo();
                pAimInfo_->pLeaderChip_ = this;
                pAimInfo_->pTarget = pLockonTarget;
                pAimInfo_->t1_x = pAimInfo_->pTarget->_x;
                pAimInfo_->t1_y = pAimInfo_->pTarget->_y;
                pAimInfo_->t1_z = pAimInfo_->pTarget->_z;
                pAxsMver_->forceVxyzMvVeloRange(-MAX_VELO_RENGE, MAX_VELO_RENGE);
            } else {
                //[ŃbNIĂȂ
                pAimInfo_ = pOrg_->getAimInfo();
                pAimInfo_->pLeaderChip_ = this;
                pAimInfo_->pTarget = nullptr;
                pAxsMver_->forceVxyzMvVeloRange(-MAX_VELO_RENGE, MAX_VELO_RENGE);
            }
        } else {
            //[ȊO͑Ô󂯌p
            pAimInfo_ = pF->pAimInfo_; //󂯌p
            coord velo = pF->pAxsMver_->_top_velo_vx_mv - PX_C(0.5);
            pAxsMver_->forceVxyzMvVeloRange(-velo, velo);
#ifdef MY_DEBUG
if (pAimInfo_ == nullptr) {
throwGgafCriticalException("pAimInfo_ pĂ܂I"<<this<<
                           " _frame_of_life_when_activation="<<_frame_of_life_when_activation);
}
#endif
        }

        //Jnt[A`bv̑xƌ̏ݒ
        setFaceAngAs(pOrg_);
        setPositionAt(pOrg_);
        pAxsMver_->setVxyzMvVeloTwd(_rz, _ry, INITIAL_VELO); //͂
        pAxsMver_->setZeroVxyzMvAcce();
    }

    //ϋȐWݒB([U[炩ɂm[}CYj
    //processSettlementBehavior() ̃\bḧӋ`Ƃ͗čWړĂB
    //{ processBehaviorAfter() IȈӖ̏ł邪AS[U[`bvړłȂƈӖȂ̂
    //dȂ̂processSettlementBehavior()ɐHł܂B
    //Ė{NXpꍇApNXprocessSettlementBehavior()ł́A擪ŌĂяoǂB
    if (getActiveFrame() > 4) { //FKIuWFNg̃[U[˂lƁA_tmpXYZ ܂̂3t[ȍ~B
        MyBunshinWateringLaserChip001* pF = (MyBunshinWateringLaserChip001*)getInfrontChip();
        MyBunshinWateringLaserChip001* pB = (MyBunshinWateringLaserChip001*)getBehindChip();
        if (pF && pB && pF->isActive() && pB->isActive()) {
            //_pChip_behind == nullptr ̔肾ł͂߁B_pChip_behind->_is_active_flg Ɣ肷邱
            //ȂȂ dispatch ̏uԂ_pChip_behind != nullptr ƂȂ邪Aactive()ɂLɂȂ͎̂t[
            //_x,_y,_z ɂ͂܂ςȒlĂB
            //ԍWɍĐݒ
            _x = ((pF->tmp_x_ + pB->tmp_x_)/2 + tmp_x_)/2;
            _y = ((pF->tmp_y_ + pB->tmp_y_)/2 + tmp_y_)/2;
            _z = ((pF->tmp_z_ + pB->tmp_z_)/2 + tmp_z_)/2;
            pAxsMver_->setVxyzMvAcce( ( ((pF->tmp_acc_vx_ + pB->tmp_acc_vx_)/2) + tmp_acc_vx_)/2,
                                      ( ((pF->tmp_acc_vy_ + pB->tmp_acc_vy_)/2) + tmp_acc_vy_)/2,
                                      ( ((pF->tmp_acc_vz_ + pB->tmp_acc_vz_)/2) + tmp_acc_vz_)/2 );
        }
    }
    WateringLaserChip::processSettlementBehavior();
}

void MyBunshinWateringLaserChip001::processJudgement() {
    if (isOutOfSpacetime()) {
        if (pAimInfo_->pLeaderChip_ == this) {
            pAimInfo_->t2_x = _x;
            pAimInfo_->t2_y = _y;
            pAimInfo_->t2_z = _z;
            pAimInfo_->_spent_frames_to_t2 = getActiveFrame();

            if (pAimInfo_->_spent_frames_to_t1 == 0) {
                pAimInfo_->t1_x = pAimInfo_->t2_x;
                pAimInfo_->t1_y = pAimInfo_->t2_y;
                pAimInfo_->t1_z = pAimInfo_->t2_z;
                pAimInfo_->_spent_frames_to_t1 = getActiveFrame();
            }
        }
        sayonara();
    }
}


void MyBunshinWateringLaserChip001::aimChip(int tX, int tY, int tZ) {
    //    |                            vVT I                        |
    //    |                                ^                         |
    //    |                 |I| > 5*vM /    _  vVP I      |      I
    //    |                 ƂȂ悤 /       _                    |       
    //    |                 vVTݒ   /                            |      
    //    |                            /        ^vVM              |       
    //    |                           /       ^  (vVMx,vVMy,vVMz)     |       b
    //    |                          /      ^                         |       b
    //    |                         /     ^                           |       b
    //    |                        /    ^ || = lVM * 5            |       b
    //    |                   vT I   ^                               |       I
    //    |                    ^  ^                                 |       
    //    |               _    / vM ݂̈ړxNg          |       b
    //    | vVP I  _ /^ (veloVxMv_,veloVyMv_,veloVzMv_)     |       b
    //    |                                                          |       
    // ---+------------------------------------------               ---+---------------------------
    //    |                                                            |
    //
    // vVP BvVP߂I
#ifdef MY_DEBUG
    if (tX == INT_MAX) {
        throwGgafCriticalException("");
    }
#endif
    GgafDxAxesMover* pAxsMver = pAxsMver_;

    //I
    const int vTx = tX - _x;
    const int vTy = tY - _y;
    const int vTz = tZ - _z;

    //B
    const int vVMx = pAxsMver->_velo_vx_mv;
    const int vVMy = pAxsMver->_velo_vy_mv;
    const int vVMz = pAxsMver->_velo_vz_mv;
    //|| = lVM * 5
    const int lVM = MAX3(ABS(vVMx), ABS(vVMy), ABS(vVMz)); //xNg傫ȈՔ
    //|I|
    const int lT =  MAX3(ABS(vTx), ABS(vTy), ABS(vTz)); //IxNg傫ȈՔ
    //||/|I|      vT ̉{ vVT I ɂȂ̂߂B
    const double r = (lVM*5 * 1.5) / lT;
    //* 1.5 E}̂悤Ɉ꒼ɕ񂾍ۂAisێ邽߂ɁA
    //|I| > || Ƃ֌Wێ邽߂ɂKȊ

    //vVP I ̉xݒ
    const double accX = ((vTx * r) - vVMx*5) * RR_MAX_ACCE;
    const double accY = ((vTy * r) - vVMy*5) * RR_MAX_ACCE;
    const double accZ = ((vTz * r) - vVMz*5) * RR_MAX_ACCE;

    pAxsMver->setVxyzMvAcce(accX + SGN(accX)*3.0,
                            accY + SGN(accY)*3.0,
                            accZ + SGN(accZ)*3.0);
}

void MyBunshinWateringLaserChip001::onHit(const GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*) prm_pOtherActor;
    //qbgGtFNg
    UTIL::activateExplosionEffectOf(this); //GtFNgo

    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
        //bNI\AN^[Ȃ烍bNI
        if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
            pOrg_->pLockonCtrler_->lockon(pOther);
        }

        int stamina = UTIL::calcMyStamina(this, pOther);
        if (stamina <= 0) {
            //ꌂŃ`bvł̍U
            getStatus()->set(STAT_Stamina, default_stamina_);
            sayonara();
        } else {
            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
            getStatus()->set(STAT_Stamina, default_stamina_);
        }
        MyBunshin::AimInfo* pAimInfo = pAimInfo_;
        if (this == pAimInfo->pLeaderChip_ && pAimInfo->pTarget == prm_pOtherActor) {
            //[ڕWɌꍇT1I
            pAimInfo->t1_x = _x;
            pAimInfo->t1_y = _y;
            pAimInfo->t1_z = _z;
            pAimInfo->_spent_frames_to_t1 = getActiveFrame();
        }

    } else if (pOther->getKind() & KIND_CHIKEI) {
        //n`͖悤Ȃ
        sayonara();
    }
}

void MyBunshinWateringLaserChip001::onInactive() {
    MyBunshin::AimInfo* pAimInfo = pAimInfo_;

    if (pAimInfo->pLeaderChip_ == this) {
        if (pAimInfo->_spent_frames_to_t2 == 0) {
            static const Spacetime* pSpaceTime =  P_GOD->getSpacetime();
            static const double zf_r = UTIL::getDistance(
                                              0.0, 0.0, 0.0,
                                              (double)(pSpaceTime->_x_bound_right),
                                              (double)(pSpaceTime->_y_bound_top),
                                              (double)(pSpaceTime->_z_bound_far)
                                             ) * 1.2;

            MyBunshinWateringLaserChip001* pB = (MyBunshinWateringLaserChip001*)getBehindChip();
            if (pB) {
                pAimInfo->setT2(zf_r, pB->_x, pB->_y, pB->_z, _x, _y, _z);
                pAimInfo->_spent_frames_to_t2 = getActiveFrame()+AIM_TIME_OUT;
            } else {
                pAimInfo->setT2(zf_r, pOrg_->_x, pOrg_->_y, pOrg_->_z, _x, _y, _z);
                pAimInfo->_spent_frames_to_t2 = getActiveFrame()+AIM_TIME_OUT;
            }

            if (pAimInfo->_spent_frames_to_t1 == 0) {
                pAimInfo->t1_x = pAimInfo->t2_x;
                pAimInfo->t1_y = pAimInfo->t2_y;
                pAimInfo->t1_z = pAimInfo->t2_z;
                pAimInfo->_spent_frames_to_t1 = getActiveFrame()+AIM_TIME_OUT;
            }

        }
        pAimInfo->pLeaderChip_ = nullptr;
    }

    pOrg_ = nullptr;
    pLockon_ = nullptr;
    pAimInfo_ = nullptr;

    WateringLaserChip::onInactive();
}

void MyBunshinWateringLaserChip001::chengeTex(int prm_tex_no) {
    if (MyBunshinWateringLaserChip001::pModel_) {
        MyBunshinWateringLaserChip001::tex_no_ = prm_tex_no;
        MyBunshinWateringLaserChip001::pModel_->setDefaultTextureMaterialNo(prm_tex_no);
    }
}

MyBunshinWateringLaserChip001::~MyBunshinWateringLaserChip001() {
    GGAF_DELETE(pAxsMver_);
    MyBunshinWateringLaserChip001::pModel_ = nullptr;
}

