#include "MenuSelectSub.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/gecchi/VioletVreath/God.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

MenuSelectSub::MenuSelectSub(const char* prm_name, const char* prm_model) :
        FontBoardMenu(prm_name, prm_model) {
    _class_name = "MenuSelectSub";
    target_x_ = _x;
    target_y_ = _y;
    GgafDxSeTransmitterForActor* pSe = getSeTransmitter();
    pSe->set(SE_MOVE_CURSOR   , "WAVE_MENU_MOVE_CURSOR"   );
    setFadeFrames(0);
    activateImmed(); //Ij[Ȃ̂ŁAԂ͊ԂftHgƂ
}

bool MenuSelectSub::condDecision() {
    if (VB->isPushedDown(VB_UI_EXECUTE)) {
        //uj[ACeFCӁvŁAVB_UI_EXECUTE {^̏ꍇ
        //̃ACeuvƂB(O)
        return true;
    } else if (VB->isPushedDown(VB_UI_CANCEL) &&
               _lstItems.getRelation(ITEM_RELATION_TO_CANCEL) != nullptr &&
               _lstItems.getCurrent() == _lstItems.getRelation(ITEM_RELATION_TO_CANCEL)) {
        //ʂɁuj[ACeFLZvɃJ[\ꍇłAVB_UI_CANCEL {^̏ꍇ́A
        //uj[ACeFLZvuvƂɂB
        //J[\uj[ACeFLZvɂ邩ǂ̔f́A
        //relateAllItemToCancel() Œ`ꂽACẽCfbNXǂŔfB
        return true;
    } else {
        return false;
    }
}
bool MenuSelectSub::condCancel() {
    if (VB->isPushedDown(VB_UI_CANCEL)) {
        //uj[ACeFCӁvŁAVB_UI_CANCEL {^̏ꍇ
        //̃ACeuLZvƂB(O)
        return true;
    } else {
        return false;
    }
}
bool MenuSelectSub::condSelectNext() {
    return false;
}
bool MenuSelectSub::condSelectPrev() {
    return false;
}
bool MenuSelectSub::condSelectExNext() {
    return false;
}
bool MenuSelectSub::condSelectExPrev() {
    return false;
}
bool MenuSelectSub::condSelectCancel() {
    return hasJustCancelled();
}

void MenuSelectSub::riseMe() {
    target_x_ = _x;
    target_y_ = _y;
    FontBoardMenu::riseMe();
}

void MenuSelectSub::rise(coord prm_target_x, coord prm_target_y) {
    target_x_ = prm_target_x;
    target_y_ = prm_target_y;
    FontBoardMenu::riseMe();
}

void MenuSelectSub::riseSubMenu(int prm_index, coord prm_target_x, coord prm_target_y) {
    FontBoardMenu::getSubMenu(prm_index)->setPosition(prm_target_x, prm_target_y); //ɂvoid MenuSelectSub::riseMe() ɗɃ^[Qbgݒ肳
    FontBoardMenu::riseSubMenu(prm_index);
}

void MenuSelectSub::moveCursor(bool prm_smooth) {
    FontBoardMenu::moveCursor(prm_smooth);
    if (prm_smooth) { //X[YړtrueȂ킿AԁB
        getSeTransmitter()->play(SE_MOVE_CURSOR);
    }
}

void MenuSelectSub::onMoveCursor(int prm_from, int prm_to) {
}


void MenuSelectSub::onSelect(int prm_from, int prm_to) {
}

void MenuSelectSub::initialize() {
}

void MenuSelectSub::onRise() {
}

void MenuSelectSub::processBehavior() {
    setPosition(target_x_, target_y_);
    getKuroko()->behave();
    FontBoardMenu::processBehavior();
    //j[IACeA\ACeAJ[\́A
    //{[hWɂĂ邽߁Ag̍Wm
    // processBehavior() R[قǂB
}

void MenuSelectSub::processJudgement() {
}

void MenuSelectSub::onSink() {
}

MenuSelectSub::~MenuSelectSub() {
}
