#include "EnemyEresShot001.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyEresShot001::EnemyEresShot001(const char* prm_name) :
        DefaultMeshSetActor(prm_name, "myvic", STATUS(EnemyEresShot001)) {
    _class_name = "EnemyEresShot001";
    inactivateTree();

    /** ȍ */
    velo1st_ = 13000;
    /** ỏxiŒxȂj */
    iMoveAcce_1st_ = -150;
    /** goĂA@̕ɕ]Jnt[ */
    frame_TurnBegin_ = 60;
    /** ړx */
    veloTop_ = 30000;
    /** Œۏ؈ړx */
    veloBottom_ = 0;
    /** ]ɔ₷Ƃłt[ */
    frame_TurnInterval_ = 400;
    /** ]̊pxAOl(̒l) */
    angVelo_Turn_ = 7000;
    /** ]Jniframe_TurnBegin_jĐݒ肳x */
    iMoveAcce_2nd_ = 100;

    GgafDxSeTransmitterForActor* pSe = getSeTransmitter();
    pSe->set(ERESSHOT001_SE_EXPLOSION, "WAVE_EXPLOSION_002");
}

void EnemyEresShot001::initialize() {
    GgafDxKuroko* const pKuroko = getKuroko();
    pKuroko->forceMvVeloRange(veloTop_, veloBottom_);
    pKuroko->linkFaceAngByMvAng(true);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAABox(0, -30000, -30000, 30000, 30000);
    setHitAble(true);
}

void EnemyEresShot001::onActive() {
    getStatus()->reset();

    //o
    GgafDxKuroko* const pKuroko = getKuroko();
    pKuroko->setMvVelo(velo1st_);
    pKuroko->setMvAcce(iMoveAcce_1st_);

    setHitAble(true);
}

void EnemyEresShot001::processBehavior() {
    GgafDxKuroko* const pKuroko = getKuroko();
    //]Jn
    if (getActiveFrame() == frame_TurnBegin_) {
        pKuroko->turnMvAngTwd(P_MYSHIP,
                              angVelo_Turn_, 0,
                              TURN_CLOSE_TO, true);
        pKuroko->setMvAcce(iMoveAcce_2nd_);
    }

    //]I
    if (getActiveFrame() == frame_TurnBegin_ + frame_TurnInterval_) {
        pKuroko->setRzRyMvAngVelo(0,0);
        pKuroko->_is_targeting_ry_mv = false;
        pKuroko->_is_targeting_rz_mv = false;
    }

    //behaveUvFlip();
    //Wɔf
    pKuroko->behave();
    //getSeTransmitter()->behave();
}

void EnemyEresShot001::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void EnemyEresShot001::onHit(const GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(ERESSHOT001_SE_EXPLOSION);
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
    }
}

void EnemyEresShot001::onInactive() {
    sayonara();
}

EnemyEresShot001::~EnemyEresShot001() {
}
