#include "Shot004.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/effect/EffectExplosion001.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/CommonScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

Shot004::Shot004(const char* prm_name) :
        DefaultMassMeshActor(prm_name, "Shot004", STATUS(Shot004)) { //SingleLaser͍ő27Zbgł
        //SingleLaser(prm_name, "27/laser_single") { //SingleLaser͍ő27Zbgł
    _class_name = "Shot004";
    view_in_ = false;
}

void Shot004::initialize() {
    setHitAble(false);
    setZEnableDraw(true);   //`掞AZobt@l͍l
    setZWriteEnable(false); //gZobt@݂Ȃ
    effectBlendOne();       //Z
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAABox_Cube(0, PX_C(16));
}
void Shot004::onReset() {
    setScaleR(3.0);
    setAlpha(0.99); //ɂ邱Ƃŗʃ_O
    GgafDxKuroko* const pKuroko = getKuroko();
    pKuroko->setRollFaceAngVelo(D_ANG(3));
    pKuroko->setMvVelo(30000);
    pKuroko->setMvAcce(1000);
    pKuroko->linkFaceAngByMvAng(true);
}

void Shot004::onActive() {
    setHitAble(true, false);
    view_in_ = false;
}

void Shot004::processBehavior() {
    //eȂ̂ŕsv

    //Wɔf
    getKuroko()->behave();
}

void Shot004::processJudgement() {
    if (isOutOfView()) {
        if (view_in_) {
            sayonara();
        }
        if (getActiveFrame() > 60) {
            sayonara();
        }
    } else {
        view_in_ = true;
    }
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void Shot004::onHit(const GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
    }
}

Shot004::~Shot004() {
}
