#ifndef GAMEGLOBAL_H_
#define GAMEGLOBAL_H_
#include "VioletVreath.h"

#include "jp/gecchi/VioletVreath/util/RankingTable.h"

#define G_MIN_RANK (0.0)
#define G_MAX_RANK (1.0)
/** N (0.0 ` 1.0) */
#define G_RANK (VioletVreath::GameGlobal::rank_)
/** N\pN[g */
#define G_RANK_R (1000.0)
/** \pNl */
#define G_RANK_DISP ((int)(G_RANK*G_RANK_R))

/** NAbvxlBStageWorld::processBehavior()G_RANKɒǏ] */
#define G_RANKUP_LEVEL (VioletVreath::GameGlobal::rank_up_level_)
/** XRA */
#define G_SCORE (VioletVreath::GameGlobal::score_)
/** XRA */
#define G_ZANKI (VioletVreath::GameGlobal::zanki_)
/** LOXRA */
#define G_RANKING_TABLE (VioletVreath::GameGlobal::tblRanking_)


#define G_MAX_RANKUP_LEVEL (1230)

/**
 * Np֐() .
 * ̃Nl(RANK_VAL)A
 * G_MIN_RANK ` G_MAX_RANK ɐڂɔ MIN_VAL`MAX_VAL ɐڂl擾B
 */
#define RF(RANK_VAL, MIN_VAL, MAX_VAL)  ( RCNV( (G_MIN_RANK), (G_MAX_RANK), (RANK_VAL), (MIN_VAL), (MAX_VAL) ) )

/**
 * Np֐(L) .
 * ̃Nl(RANK_VAL)AG_MIN_RANK ` G_MAX_RANK ɐڂɔ MIN_VAL`MAX_VAL ɐڂl擾B
 * AA`(RANK_VAL)FG_MIN_RANK <= RANK_VAL <= G_MIN_RANK  ɑ΂āA
 *         l(N)       F   MIN_VAL <=    N     <= MAX_VAL     ԂB
 * Nl(RANK_VAL)G_MIN_RANKꍇ́AMIN_VALɌŒB
 * Nl(RANK_VAL)G_MAX_RANKꍇ́AMAX_VALɌŒB
 */
#define RF_ULL(RANK_VAL, MIN_VAL, MAX_VAL)  ( ((RANK_VAL) < (G_MIN_RANK)) ? (MIN_VAL) : ( ((RANK_VAL) > (G_MAX_RANK)) ? (MAX_VAL) : (RCNV((G_MIN_RANK), (G_MAX_RANK), (RANK_VAL), (MIN_VAL), (MAX_VAL))) ) )

/**
 * Np֐(̂ݗL) .
 * ̃Nl(RANK_VAL)AG_MIN_RANK ` G_MAX_RANK ɐڂɔ MIN_VAL`MAX_VAL ɐڂl擾B
 * AA`(RANK_VAL)FG_MIN_RANK <= RANK_VAL  ɑ΂āA
 *         l(N)       F   MIN_VAL <=    N      ԂB
 * Nl(RANK_VAL)G_MIN_RANKꍇ́AMIN_VALɌŒB
 */
#define RF_LL(RANK_VAL, MIN_VAL, MAX_VAL)  ( ((RANK_VAL) < (G_MIN_RANK)) ? (MIN_VAL) : (RCNV((G_MIN_RANK), (G_MAX_RANK), (RANK_VAL), (MIN_VAL), (MAX_VAL))) )

/**
 * Np֐(̂ݗL) .
 * ̃Nl(RANK_VAL)AG_MIN_RANK ` G_MAX_RANK ɐڂɔ MIN_VAL`MAX_VAL ɐڂl擾B
 * AA`(RANK_VAL)FRANK_VAL <= G_MIN_RANK  ɑ΂āA
 *         l(N)       F   N     <= MAX_VAL     ԂB
 * Nl(RANK_VAL)G_MAX_RANKꍇ́AMAX_VALɌŒB
 */
#define RF_UL(RANK_VAL, MIN_VAL, MAX_VAL)  ( ((RANK_VAL) > (G_MAX_RANK)) ? (MAX_VAL) : (RCNV((G_MIN_RANK), (G_MAX_RANK), (RANK_VAL), (MIN_VAL), (MAX_VAL))) )


namespace VioletVreath {

class GameGlobal {
public:
    static bool is_init_;
    /** XRA */
    static int score_;
    /** Nli0.0 ` 1.0B 1.0MAXNƂ) */
    static double rank_;
    /** c@ */
    static int zanki_;
    /** Nxl */
    static int rank_up_level_;
    /** LOe[u */
    static RankingTable tblRanking_;
    /** f */
    static int prime_n_[];

    /**
     * G_RANKQƂAG_RANKUP_LEVELZ܂B
     * @return true:G_RANKUP_LEVELZ /false:G_RANKUP_LEVEL͕ωȂ
     */
    static bool updateRankUpLebel();
};

}
#endif /*GAMEGLOBAL_H_*/

