#include "GgafEffectConst.fxh" 
////////////////////////////////////////////////////////////////////////////////
// GgafCuAGgafDxMeshModelpVF[_[
//
// author : Masatoshi Tsuge
// date:2009/03/06 
////////////////////////////////////////////////////////////////////////////////
//G[̂߂ɂƂ肠ǉłƂ
float3 g_posCam_World;
float g_specular;
float g_specular_power;


float4x4 g_matWorld;  //Worldϊs
float4x4 g_matView;   //Viewϊs
float4x4 g_matProj;   //ˉeϊs

float3 g_vecLightFrom_World; // Cg̕
float4 g_colLightAmbient;   // AmbienCgFiːFj
float4 g_colLightDiffuse;   // DiffuseCgFiːFj

float4 g_colMaterialDiffuse;  //}eA̐F
float g_tex_blink_power;   
float g_tex_blink_threshold;
float g_alpha_master;
float g_zf;

float g_offset_u;
float g_offset_v;

//s0WX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//texture g_diffuseMap;
//sampler MyTextureSampler = sampler_state {
//	texture = <g_diffuseMap>;
//};

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj    : POSITION;
	float2 uv     : TEXCOORD0;
	float4 color    : COLOR0;
};


///////////////////////////////////////////////////////////////////////////

//bVW_VF[_[
OUT_VS GgafDxVS_SpriteMesh(
    float4 prm_posModel_Local  : POSITION, // f̒_
    float3 prm_vecNormal_Local : NORMAL,   // f̒_̖@
    float2 prm_uv              : TEXCOORD0 // f̒_UV
) {
	OUT_VS out_vs = (OUT_VS)0;

	//_vZ
	out_vs.posModel_Proj = mul( mul( mul(prm_posModel_Local, g_matWorld), g_matView), g_matProj);  //World*View*ˉeϊ
    //UV
	out_vs.uv.x = prm_uv.x + g_offset_u;
	out_vs.uv.y = prm_uv.y + g_offset_v;

	//@ World ϊĐK
    const float3 vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld)); 	
    //@ƁADiffuseCg̓ςvZAʂɑ΂郉Cg̓ˊpɂ錸߂B
	const float power = max(dot(vecNormal_World, -g_vecLightFrom_World ), 0);      
	//AmbientCgFADiffuseCgFADiffuseCgA}eAF lJ[쐬B      
	out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power)) * g_colMaterialDiffuse;
	//tHO
	out_vs.color.a = g_colMaterialDiffuse.a;
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {   
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
	return out_vs;
}

OUT_VS VS_NoLight(
    float4 prm_posModel_Local  : POSITION,  // f̒_
    float3 prm_vecNormal_Local : NORMAL,    // f̒_̖@
    float2 prm_uv              : TEXCOORD0  // f̒_UV
) {
	OUT_VS out_vs = (OUT_VS)0;
	//_vZ
	out_vs.posModel_Proj = mul( mul( mul(prm_posModel_Local, g_matWorld), g_matView), g_matProj);  //World*View*ˉeϊ
    //UV
	out_vs.uv.x = prm_uv.x + g_offset_u;
	out_vs.uv.y = prm_uv.y + g_offset_v;
	//A}eAF lJ[쐬B      
	out_vs.color = g_colMaterialDiffuse;
	return out_vs;
}


//bVWsNZVF[_[ieNX`Lj
float4 GgafDxPS_SpriteMesh(
	float2 prm_uv	 : TEXCOORD0,
    float4 prm_color : COLOR0
) : COLOR  {
	//eNX`TvOĐF擾iF擾j
	const float4 colTex = tex2D( MyTextureSampler, prm_uv);        
	float4 colOut = colTex * prm_color;
    //Blinkerl
	if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
		colOut *= g_tex_blink_power; //ă{|B_łڗB
	} 
	//}X^[
	colOut.a *= g_alpha_master;
	return colOut;
}

float4 PS_Flush( 
	float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
	float4 colOut = tex2D( MyTextureSampler, prm_uv) * prm_color * FLUSH_COLOR;
	colOut.a *= g_alpha_master;
	return colOut;
}

float4 PS_NoLight(
	float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
	float4 colOut = tex2D( MyTextureSampler, prm_uv) * prm_color;
    //Blinkerl
//	if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
//		colOut *= g_tex_blink_power; //ă{|B_łڗB
//	} 
	colOut.a *= g_alpha_master;
	return colOut;
}

technique SpriteMeshTechnique
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		VertexShader = compile VS_VERSION GgafDxVS_SpriteMesh();
		PixelShader  = compile PS_VERSION GgafDxPS_SpriteMesh();
	}
}

technique DestBlendOne
{
	pass P0 {
        //SeparateAlphaBlendEnable = true;
		AlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;   
		DestBlend = One; //Z
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_SpriteMesh();
		PixelShader  = compile PS_VERSION GgafDxPS_SpriteMesh();
	}
}

technique Flush
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_SpriteMesh();
		PixelShader  = compile PS_VERSION PS_Flush();
	}
}

technique NoLight
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION VS_NoLight();
		PixelShader  = compile PS_VERSION PS_NoLight();
	}
}

