#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// GgafCuAFontBoardActorpVF[_[
//
// author : Masatoshi Tsuge
// date:2016/03/14
////////////////////////////////////////////////////////////////////////////////
float g_game_buffer_width; //ʕ(px)
float g_game_buffer_height; //ʍ(px)
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;


//s0WX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj : POSITION;
    float4 color         : COLOR0;
    float2 uv            : TEXCOORD0;
};


///////////////////////////////////////////////////////////////////////////

//FontBoardActorW_VF[_[
OUT_VS GgafDxVS_FontBoard(
      float4 prm_posModel_Local   : POSITION,      // f̒_
      float3 prm_vecNormal_Local  : NORMAL,        // f̒_̖@(gp)
      float2 prm_uv               : TEXCOORD0,     // f̒_UV

      float3 prm_pos              : TEXCOORD1,     // px_x, px_y, depth_z
      float3 prm_info             : TEXCOORD2      // offset_u, offset_v, alpha
) {
    OUT_VS out_vs = (OUT_VS)0;
    float px_x = prm_pos.x; //ϊςXW(px)
    float px_y = prm_pos.y; //ϊςYW(px)
    float depthZ = prm_pos.z; //[xZ (0 ` +1)
    float offset_u = prm_info.x; //eNX`UW
    float offset_v = prm_info.y; //eNX`VW
    float alpha = prm_info.z; //

    //XWYW -1 ` +1 ɉ߂B
    out_vs.posModel_Proj.x = - 1 + ((2*prm_posModel_Local.x + 2*px_x - 1) / g_game_buffer_width);
    out_vs.posModel_Proj.y =   1 - ((2*prm_posModel_Local.y + 2*px_y - 1) / g_game_buffer_height);
    out_vs.posModel_Proj.z = depthZ;
    out_vs.posModel_Proj.w = 1.0;
    //UṼItZbgZ
    out_vs.uv.x = prm_uv.x + offset_u;
    out_vs.uv.y = prm_uv.y + offset_v;
    out_vs.color.a = alpha;
    return out_vs;
}


//FontBoardActorWsNZVF[_[
float4 GgafDxPS_FontBoard(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color  : COLOR0
) : COLOR  {
    float4 colOut = tex2D( MyTextureSampler, prm_uv);
    if (colOut.r >= g_tex_blink_threshold || colOut.g >= g_tex_blink_threshold || colOut.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power;
    }
    //l
    colOut.a = colOut.a * prm_color.a * g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
    //eNX`TvOĐF擾iF擾j
    float4 colOut = tex2D( MyTextureSampler, prm_uv) * FLUSH_COLOR * prm_color;
    //l
    colOut.a = colOut.a * prm_color.a * g_alpha_master;
    return colOut;

}

//eNjbNFFontBoardTechnique
//y@\z
//FontBoardActorpWVF[_[
//yTvz
//D3DFVF_XYZRHW ŕ`悵悤ȎdlłQc\܂B
//ʍ(0,0)ŉʉEiʕ(px), ʍ(px))ƂȂWn
//v~eBui|j̊_͍ɂȂ܂B
//--- VS ---
//E_ -1 ` +1։(ˉeϊ)AYW]
//--- PS ---
//EIuWFNg̃eNX`
//E
//
//yݒO[oz
// float g_alpha			:	l
// float g_px_x		: 	ϊςXW(px)
// float g_px_y		:	ϊςYW(px)
// float g_depth_z			:	[xZ (0 ` +1)
// float g_game_buffer_width		:	ʕ(px)
// float g_game_buffer_height		:	ʍ(px)
// float g_offset_u			:	eNX`UW
// float g_offset_v			:	eNX`VW
// s0WX^				:	2DeNX`
technique FontBoardTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_FontBoard();
        PixelShader  = compile PS_VERSION GgafDxPS_FontBoard();
    }
}

technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_FontBoard();
        PixelShader  = compile PS_VERSION GgafDxPS_FontBoard();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_FontBoard();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}
