#include "jp/ggaf/lib/util/spline/FixedFrameSplineKurokoLeader.h"

#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/lib/util/StgUtil.h"
#include "jp/ggaf/lib/util/spline/SplineLine.h"
#include "jp/ggaf/lib/util/spline/SplineSource.h"
#include "jp/ggaf/lib/util/spline/FixedFrameSplineManufacture.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

FixedFrameSplineKurokoLeader::FixedFrameSplineKurokoLeader(SplineManufacture* prm_pManufacture, GgafDxKuroko* prm_pKuroko_target) :
        SplineKurokoLeader(prm_pManufacture, prm_pKuroko_target) {
    _pFixedFrameSplManuf = (FixedFrameSplineManufacture*)prm_pManufacture;
    _leading_frames = 0;
    _point_index = 0;
    _prev_point_index = -1;
    _hosei_frames = 0;
}
FixedFrameSplineKurokoLeader::FixedFrameSplineKurokoLeader(GgafDxKuroko* prm_pKuroko_target,
                                                           SplineLine* prm_pSpl,
                                                           frame prm_spent_frame,
                                                           angvelo prm_angvelo_rzry_mv):
        SplineKurokoLeader(nullptr, prm_pKuroko_target) {  //nullptrœnɂA_is_created_pManufacture  falseɂȂ

    _pFixedFrameSplManuf = NEW FixedFrameSplineManufacture(NEW SplineSource(prm_pSpl), prm_spent_frame, prm_angvelo_rzry_mv);
    _pFixedFrameSplManuf->calculate();//YȂ悤ɁBꂱ̃^Cv͏
    _pManufacture = _pFixedFrameSplManuf;
    _leading_frames = 0;
    _point_index = 0;
    _prev_point_index = -1;
    _hosei_frames = 0;
}

void FixedFrameSplineKurokoLeader::restart() {
    SplineKurokoLeader::restart();
    _leading_frames = 0;
    _hosei_frames = 0;
    _point_index = 0;
    _prev_point_index = -1;


    //n_֍sʏB
    //n_ւ̋(_distance_to_begin) 킩Ă̂ŁA
    //
    // n_ւ̑x = (velo)(_distance_to_begin / _pFixedFrameSplManuf->_frame_of_segment)
    //
    //ƂA
    //_pFixedFrameSplManuf->_frame_of_segment ́AW`n_ 
    //vZŋ߂Ă̂ŁA⊮_ȂꍇA₳t[v̌덷傫B
    //Ŏn_ւ̋0Ƃ݂Ȃꍇɂ́AW`n_ ȂRgɂB
    //łȂΎdȂ̂ŁA₳t[v̌덷F߂dlƂB
    if (ABS(_distance_to_begin) <= PX_C(1)) {
        //n_ւ̋AԈB
        //_TRACE_("xFixedFrameSplineKurokoLeader::start("<<prm_option<<") _pActor_target="<<_pActor_target->getName()<<
        //    " W`n_[0]ւ̋ 0 ł邽߁AW`n_ւ̈ړvZX̓Jbg܂B");
        _hosei_frames = _pFixedFrameSplManuf->_frame_of_segment;
        //ɂA_point_index ́A񂢂Ȃ1n܂B
    } else {
        _TRACE_("xFixedFrameSplineKurokoLeader::restart("<<_option<<") _pActor_target="<<_pActor_target->getName()<<
            " W`n_[0]ւ̋("<<_distance_to_begin<<" coord)Ă邽߁AW`n_ւ̈ړvZXƂăZOg{P܂B"<<
            "̂߁Avړt[ԂɌ덷(+"<<_pFixedFrameSplManuf->_frame_of_segment<<"t[)܂B܂B");
        _hosei_frames = 0;
        //ɂA_point_index ́A0n܂B
    }

}

void FixedFrameSplineKurokoLeader::behave() {
    if (_is_leading) {
        GgafDxKuroko* const pKuroko_target = _pActor_target->getKuroko();
        //݂̓_INDEX
        _point_index = (_leading_frames+_hosei_frames) / _pFixedFrameSplManuf->_frame_of_segment;
        if ( _point_index == _pFixedFrameSplManuf->_sp->_rnum) {
            if (_cnt_loop == _max_loop) {
                //I
                _is_leading = false;
                pKuroko_target->stopTurningMvAng();
                return;
            } else {
                //[v
                _cnt_loop++;
                restart();
                _point_index = (_leading_frames+_hosei_frames) / _pFixedFrameSplManuf->_frame_of_segment;
            }
        }

        //ς
        if (_prev_point_index != _point_index) {
            _prev_point_index = _point_index;
            coord x, y, z;
            getPointCoord(_point_index, x, y, z);
            pKuroko_target->turnMvAngTwd(x, y, z,
                                         _pFixedFrameSplManuf->_angvelo_rzry_mv, 0,
                                         _pFixedFrameSplManuf->_turn_way, _pFixedFrameSplManuf->_turn_optimize);

            if (_point_index == 0) {
                //WƊJnĂB
                //덷dȂ̂ _frame_of_segment Ŏn_Ɉړ鑬xt^
                pKuroko_target->setMvVelo((velo)(_distance_to_begin / _pFixedFrameSplManuf->_frame_of_segment));
            } else {
                const coord d = UTIL::getDistance(
                                        _pActor_target->_x,
                                        _pActor_target->_y,
                                        _pActor_target->_z,
                                        x, y, z);
                if (_pFixedFrameSplManuf->_paDistance_to[_point_index]*1.1 < d) {
                    //␳F\zJĂ̂ŏ}(1.1{̃Xs[hɂ)
                    pKuroko_target->setMvVelo(_pFixedFrameSplManuf->_paSPMvVeloTo[_point_index] * 1.1) ;
                    //pKuroko_target->setMvVelo(((velo)(d / _pFixedFrameSplManuf->_frame_of_segment)) + 1);
                } else {
                    pKuroko_target->setMvVelo(_pFixedFrameSplManuf->_paSPMvVeloTo[_point_index]);
                }
            }
        }
        _leading_frames++;
    }
    //_TRACE_(_pActor_target->getBehaveingFrame()<<": "<<_leading_frames<<": _cnt_loop="<<_cnt_loop<<"  _point_index="<<_point_index<<" velo="<<_pActor_target->getKuroko()->getMvVelo()<<" xyz="<<_pActor_target->_x<<","<<_pActor_target->_y<<","<<_pActor_target->_z);
}
FixedFrameSplineKurokoLeader::~FixedFrameSplineKurokoLeader() {

}
