#include "jp/ggaf/lib/util/CollisionChecker.h"

#include "jp/ggaf/core/actor/GgafGroupHead.h"
#include "jp/ggaf/core/util/GgafTreeElem.hpp"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/util/GgafDxCollisionArea.h"
#include "jp/ggaf/lib/DefaultGod.h"
#include "jp/ggaf/lib/scene/DefaultSpacetime.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/ggaf/lib/util/ColliAABox.h"
#include "jp/ggaf/lib/util/ColliSphere.h"
#include "jp/ggaf/lib/util/ColliAAPrism.h"
#include "jp/ggaf/lib/util/ColliAAPyramid.h"
#include "jp/ggaf/lib/util/StgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

#ifdef MY_DEBUG
unsigned int CollisionChecker::_num_check = 0;
#endif

CollisionChecker::CollisionChecker(GgafDxGeometricActor* prm_pActor) : GgafDxChecker(prm_pActor) {
    _need_update_aabb = true;
}

void CollisionChecker::setColliSphere(int prm_index, coord x, coord y, coord z, coord r, bool rot_x, bool rot_y, bool rot_z) {
#ifdef MY_DEBUG
    if (_pCollisionArea == nullptr) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  ܂ createCollisionArea sāAvf錾ĂB");
    }
    if (prm_index > _pCollisionArea->_colli_part_num) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"͔͈͊OB");
    }
#endif
    if (_pCollisionArea->_papColliPart[prm_index] == nullptr) {
        _pCollisionArea->_papColliPart[prm_index] = NEW ColliSphere();
    }
#ifdef MY_DEBUG
    if (_pCollisionArea->_papColliPart[prm_index]->_shape_kind != COLLI_SPHERE) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"SPHEREłȂ߁AXV͂ł܂B");
    }
#endif
#ifdef MY_DEBUG
    if (r < 0) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"SPHERE̔a̐łBr="<<r);
    }
#endif
    ColliSphere* pSphere = (ColliSphere*)_pCollisionArea->_papColliPart[prm_index];
    pSphere->_shape_kind = COLLI_SPHERE;
    pSphere->_is_valid_flg = true;
    pSphere->set(x, y, z, r, rot_x, rot_y, rot_z);
    _need_update_aabb = true;
}


void CollisionChecker::setColliAABox(int prm_index,
                                     coord x1,
                                     coord y1,
                                     coord z1,
                                     coord x2,
                                     coord y2,
                                     coord z2,
                                     bool rot_x,
                                     bool rot_y,
                                     bool rot_z) {
#ifdef MY_DEBUG
    if (_pCollisionArea == nullptr) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  ܂ createCollisionArea sāAvf錾ĂB");
    }
    if (prm_index > _pCollisionArea->_colli_part_num) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"͔͈͊OB");
    }
#endif
    if (_pCollisionArea->_papColliPart[prm_index] == nullptr) {
        _pCollisionArea->_papColliPart[prm_index] = NEW ColliAABox();
    }
#ifdef MY_DEBUG
    if (_pCollisionArea->_papColliPart[prm_index]->_shape_kind != COLLI_AABOX) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"AABBłȂ߁AXV͂ł܂B");
    }
#endif
    ColliAABox* pAABox = (ColliAABox*)_pCollisionArea->_papColliPart[prm_index];
    pAABox->_shape_kind = COLLI_AABOX;
    pAABox->_is_valid_flg = true;
    pAABox->set(x1, y1, z1, x2, y2, z2, rot_x, rot_y, rot_z);
    _need_update_aabb = true;
}

void CollisionChecker::setColliAAPrism(int prm_index,
                                         coord x1, coord y1, coord z1,
                                         coord x2, coord y2, coord z2,
                                         int pos_prism,
                                         bool rot_x, bool rot_y, bool rot_z) {
#ifdef MY_DEBUG
    if (_pCollisionArea == nullptr) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  ܂ createCollisionArea sāAvf錾ĂB");
    }
    if (prm_index > _pCollisionArea->_colli_part_num) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"͔͈͊OB");
    }
#endif
    if (_pCollisionArea->_papColliPart[prm_index] == nullptr) {
        _pCollisionArea->_papColliPart[prm_index] = NEW ColliAAPrism();
    }
#ifdef MY_DEBUG
    if (_pCollisionArea->_papColliPart[prm_index]->_shape_kind != COLLI_AAPRISM) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"AAPRISMłȂ߁AXV͂ł܂B");
    }
#endif
    ColliAAPrism* pAAPrism = (ColliAAPrism*)_pCollisionArea->_papColliPart[prm_index];
    pAAPrism->_shape_kind = COLLI_AAPRISM;
    pAAPrism->_is_valid_flg = true;
    pAAPrism->set(x1, y1, z1, x2, y2, z2, pos_prism, rot_x, rot_y, rot_z);
    _need_update_aabb = true;
}

void CollisionChecker::setColliAAPyramid(int prm_index,
                                           coord x1, coord y1, coord z1,
                                           coord x2, coord y2, coord z2,
                                           int pos_pyramid,
                                           bool rot_x, bool rot_y, bool rot_z) {
#ifdef MY_DEBUG
    if (_pCollisionArea == nullptr) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  ܂ createCollisionArea sāAvf錾ĂB");
    }
    if (prm_index > _pCollisionArea->_colli_part_num) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"͔͈͊OB");
    }
#endif
    if (_pCollisionArea->_papColliPart[prm_index] == nullptr) {
        _pCollisionArea->_papColliPart[prm_index] = NEW ColliAAPyramid();
    }
#ifdef MY_DEBUG
    if (_pCollisionArea->_papColliPart[prm_index]->_shape_kind != COLLI_AAPYRAMID) {
        throwGgafCriticalException("["<<getTargetActor()->getName()<<"]  vfCfbNX"<<prm_index<<"COLLI_AAPYRAMIDłȂ߁AXV͂ł܂B");
    }
#endif
    ColliAAPyramid* pAAPyramid = (ColliAAPyramid*)_pCollisionArea->_papColliPart[prm_index];
    pAAPyramid->_shape_kind = COLLI_AAPYRAMID;
    pAAPyramid->_is_valid_flg = true;
    pAAPyramid->set(x1, y1, z1, x2, y2, z2, pos_pyramid, rot_x, rot_y, rot_z);
    _need_update_aabb = true;
}


CollisionChecker::~CollisionChecker() {
    //蔻͂ȂȂB̏ꍇ_pElem͖ʂȐƉ邱ƂɂȂBB
}
