#include "jp/ggaf/lib/actor/SpriteMeshWorldBoundActor.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/lib/DefaultGod.h"
#include "jp/ggaf/lib/actor/camera/DefaultCamera.h"
#include "jp/ggaf/lib/scene/DefaultSpacetime.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#ifdef MY_DEBUG
#include "jp/ggaf/lib/actor/ColliAABoxActor.h"
#include "jp/ggaf/lib/actor/ColliAAPrismActor.h"
#include "jp/ggaf/lib/actor/ColliAAPyramidActor.h"
#include "jp/ggaf/lib/actor/ColliSphereActor.h"
#endif

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

SpriteMeshWorldBoundActor::SpriteMeshWorldBoundActor(const char* prm_name,
                                                     const char* prm_model,
                                                     GgafStatus* prm_pStat) :
        GgafDxSpriteMeshActor(prm_name,
                               prm_model,
                               prm_pStat,
                               nullptr) {

    _class_name = "SpriteMeshWorldBoundActor";
    changeEffectTechnique("NoLight"); //NoLightŃx^heNjbN
    setSpecialRenderDepthIndex(RENDER_DEPTH_INDEX_SP_BACK(1));
}

void SpriteMeshWorldBoundActor::processSettlementBehavior() {
    DefaultCamera* pCam = P_GOD->getSpacetime()->getCamera();
    //ʊO薳ɔȂȗB
    //̏𖳎Ă܂
    //Eg{[̍l
    //Eؓo^
    //E䂩̋vZ
    //GgafDxGeometricActor::processSettlementBehavior() Ɠ鎖I
    setPositionAt(pCam);
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);
    UTIL::setWorldMatrix_ScMv(this, _matWorld); //[hϊ
}
//void SpriteMeshWorldBoundActor::processPreDraw() {
//    //ʊO薳ɔȂȗ
//    //̏𖳎Ă܂
//    //EiK_O̐[xvZ
//    //EꎞeNjbNl
//    //GgafDxFigureActor::processPreDraw() Ɠ鎖I
//    if (_pModel->_is_init_model == false) {
//        onCreateModel(); //f쐬̏
//        _pModel->_is_init_model = true;
//    }
//    GgafDxSpacetime::registerFigureActor(REGULAR_RENDER_DEPTH_INDEXS_NUM,this); //Ő[
//}

SpriteMeshWorldBoundActor::~SpriteMeshWorldBoundActor() {
}

