#ifndef GGAFLIB_VBREPLAYRECORDER_H_
#define GGAFLIB_VBREPLAYRECORDER_H_
#include "GgafLibCommonHeader.h"

#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/lib/util/VirtualButton.h"
#include <fstream>

namespace GgafLib {

/**
 * vCf[^NX .
 * z{^Xe[^X(VirtualButton  _state)́A
 * ݓǂݎAt@Co荞݋@\񋟁B
 * @version 1.00
 * @since 2010/04/20
 * @author Masatoshi Tsuge
 */
class VBReplayRecorder : public GgafCore::GgafObject {

public:
    /**
     * vCf[^vf .
     */
    class VBRecordNote {
    public:
        /** [r]̃vCf[^vf */
        VBRecordNote* _pNext;
        /** [r]z{^Xe[^X */
        vb_sta _state;
        /** [r]Xe[^Xpt[ */
        frame _frame_of_keeping;
    public:
        /**
         * RXgN^ .
         */
        VBRecordNote() : _pNext(nullptr),_state(0),_frame_of_keeping(0) {
        }

        /**
         * RXgN^ .
         * @param state z{^Xe[^X
         * @param frame_of_keeping Xe[^Xpt[
         */
        VBRecordNote(vb_sta state, frame frame_of_keeping) : _pNext(nullptr),_state(state),_frame_of_keeping(frame_of_keeping) {
        }

        ~VBRecordNote() {
        }
    };

    /** [r]vCf[^vfXg̐擪vf */
    VBRecordNote* _pFirstVBNote;
    /** [r]vCf[^vfJ[\|C^ */
    VBRecordNote* _pRecNote;
    VBRecordNote* _pRecNote_read_prev;
    /** [r]Xe[^Xpt[JE^ */
    frame _frame_of_the_same_vb_sta_reading;

    std::ofstream _ofs_realtime;

    bool _write_realtime;

public:
    /**
     * RXgN^ .
     */
    VBReplayRecorder();


    /**
     * J[\擪ɎĂ .
     */
    void first();

    /**
     * z{^Xe[^Xǂݍ݁AԂȀԂ֑J .
     * @return z{^Xe[^X
     */
    vb_sta read();

    /**
     * ǂݍރR[h݂邩ǂ
     * @return true:݂^false:݂Ȃ
     */
    bool hasNextRecord() {
        return _pRecNote ? true : false;
    }
    /**
     * A^CLq[hIɂ(ɃfobOp) .
     * write(vb_sta) s̓xɁAA^CŃt@CɏLqĂ܂B
     * @param prm_filename A^Cɏt@C
     * @return
     */
    bool setRealtimeOutputFile(const char* prm_filename);
    /**
     * z{^Xe[^X݁AԂȀԂ֑J .
     * @param state
     */
    void write(vb_sta state);

    /**
     * t@CɃvCf[^B
     * @param prm_filename t@C
     */
    void outputFile(const char* prm_filename);

    /**
     * t@C烊vCf[^ǂݍށB
     * @param prm_filename ǂݍރt@C
     * @return true:/false:s
     */
    bool importFile(const char* prm_filename);

    virtual ~VBReplayRecorder();
};

}
#endif /*GGAFLIB_FONTSPRITESTRING_H_*/
