#ifndef GGAFLIB_STGUTIL_H_
#define GGAFLIB_STGUTIL_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

#include "jp/ggaf/lib/util/ColliAABox.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

#ifdef UTIL
    #undef UTIL
#endif
#define UTIL GgafLib::StgUtil

namespace GgafLib {

/**
 * [eBeB .
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class StgUtil: public GgafDxCore::GgafDxUtil {
public:

    static bool _was_StgUtil_inited_flg;

    static void init();

    /**
     * a 1000  1/4 ~̉e[u .
     * <pre><code>
     *      ______________
     * y = (1000^2-x^2)
     * </code></pre>
     *  vf[x] ɑ΂ y
     */
    static float ROOT_1_MINUS_XX[1000];

    static uint32_t BITNUM[];

    static GgafDxCore::GgafDxChecker* createChecker(GgafDxCore::GgafDxGeometricActor* prm_pActor);

    static inline bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAABox* const pAABox01,
                             const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox* const pAABox02 ) {
        //AAB  AAB
        //vȂmȏ(X>Z>Y)ɔ
        if (pActor01->_x + pAABox01->_x2 >= pActor02->_x + pAABox02->_x1) {
            if (pActor01->_x + pAABox01->_x1 <= pActor02->_x + pAABox02->_x2) {
                if (pActor01->_z + pAABox01->_z2 >= pActor02->_z + pAABox02->_z1) {
                    if (pActor01->_z + pAABox01->_z1 <= pActor02->_z + pAABox02->_z2) {
                        if (pActor01->_y + pAABox01->_y2 >= pActor02->_y + pAABox02->_y1) {
                            if (pActor01->_y + pAABox01->_y1 <= pActor02->_y + pAABox02->_y2) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliSphere* const pSphere01 ,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere* const pSphere02 );

    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* pActor01, const ColliAABox*  pAABox01,
                      const GgafDxCore::GgafDxGeometricActor* pActor02, const ColliSphere* pSphere02);

    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPrism* const pAAPrism01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox*   const pAABox02   );


    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPrism* const pAAPrism01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere*  const pSphere02  );


    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPyramid* const pAAPyramid01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox*     const pAABox02     );

    static bool isHit3D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPyramid* const pAAPyramid01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere*    const pSphere02    );


    static inline bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAABox* const pAABox01,
                             const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox* const pAABox02 ) {
        //AAB  AAB
        //vȂmȏ(X>Z>Y)ɔ
        if (pActor01->_x + pAABox01->_x2 >= pActor02->_x + pAABox02->_x1) {
            if (pActor01->_x + pAABox01->_x1 <= pActor02->_x + pAABox02->_x2) {
                if (pActor01->_y + pAABox01->_y2 >= pActor02->_y + pAABox02->_y1) {
                    if (pActor01->_y + pAABox01->_y1 <= pActor02->_y + pAABox02->_y2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliSphere* const pSphere01 ,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere* const pSphere02 );

    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* pActor01, const ColliAABox*  pAABox01,
                      const GgafDxCore::GgafDxGeometricActor* pActor02, const ColliSphere* pSphere02);

    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPrism* const pAAPrism01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox*   const pAABox02   ) {
        return false;
    }


    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPrism* const pAAPrism01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere*  const pSphere02  ) {
        return false;
    }


    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPyramid* const pAAPyramid01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliAABox*     const pAABox02     ) {
        return false;
    }

    static bool isHit2D(const GgafDxCore::GgafDxGeometricActor* const pActor01, const ColliAAPyramid* const pAAPyramid01,
                      const GgafDxCore::GgafDxGeometricActor* const pActor02, const ColliSphere*    const pSphere02    ) {
        return false;
    }

    /**
     * Pe𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_x               ˌXW
     * @param prm_y               ˌYW
     * @param prm_z               ˌZW
     * @param prm_rz              ˕Rz
     * @param prm_ry              ˕Ry
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgx
     * @param prm_acce            ẽVbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched ef|Wg dispach() ꂽɌĂяoR[obNB
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay001(coord prm_x, coord prm_y, coord prm_z,
                                                     angle prm_rz, angle prm_ry,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int) = nullptr);

    /**
     * ˌĂi_rz > _ryjɌ Pe𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_from_x          ˌXW
     * @param prm_from_y          ˌYW
     * @param prm_from_z          ˌZW
     * @param prm_to_x            ڕWXW
     * @param prm_to_y            ڕWYW
     * @param prm_to_z            ڕWZW
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgxBeȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            Vbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay001(coord prm_from_x, coord prm_from_y, coord prm_from_z,
                                                     coord prm_to_x, coord prm_to_y, coord prm_to_z,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int) = nullptr);

    /**
     * ˌĂi_rz > _ryjɌ Pe𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgxBeȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            Vbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay001(const GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int) = nullptr);


    /**
     * N-WayeiRzωj𕡐Zbg .
     * prm_rx, prm_rz, prm_ry = (0,0,0) ŁAXYʏRzω N-Waye ܂B
     * @param prm_x                ˌXW
     * @param prm_y                ˌYW
     * @param prm_z                ˌZW
     * @param prm_rx               N Waỷ]p
     * @param prm_rz               ˕Rz
     * @param prm_ry               ˕Ry
     * @param prm_pDepo_shot       ˂Vbg̃f|Wg
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_ang_clearance_N  N-WaẙԊupx
     * @param prm_velo_first       N-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay002(coord prm_x, coord prm_y, coord prm_z,
                                                     angle prm_rx, angle prm_rz, angle prm_ry,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     int prm_way_N,
                                                     angle prm_ang_clearance_N,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_rx, _rz > _ryjN-WayeiRzωj𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_pFrom                  ˌ
     * @param prm_pDepo_shot             ˂Vbg̃f|Wg
     * @param prm_r                      ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N                  N-WayiRzωj
     * @param prm_ang_clearance_N        N-WaẙԊupx
     * @param prm_velo_first             N-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce                   N-WayeeZbg̃Vbgx
     * @param prm_set_num                ˂ N-WayeZbg̍vZbg
     * @param prm_interval_frames        eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated             eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay002(const GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     int prm_way_N,
                                                     angle prm_ang_clearance_N,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int) = nullptr);

    /**
     * N*M-Waye𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_x                ˌXW
     * @param prm_y                ˌYW
     * @param prm_z                ˌZW
     * @param prm_rx               N*M `̉]p
     * @param prm_rz               ˕Rz
     * @param prm_ry               ˕Ry
     * @param prm_pDepo_shot1      ˂Vbg̃f|WĝP
     * @param prm_paUint32_dotmat1 VbĝPgphbg}gbNX
     * @param prm_pDepo_shot2      ˂Vbg̃f|WĝQ
     * @param prm_paUint32_dotmat2 VbĝQgphbg}gbNX
     * @param prm_pDepo_shot3      ˂Vbg̃f|WĝR
     * @param prm_paUint32_dotmat3 VbĝRgphbg}gbNX
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_way_M            M-WayiRyωj
     * @param prm_ang_clearance_N   N-WaẙԊupx
     * @param prm_ang_clearance_M   M-WaẙԊupx
     * @param prm_velo_first       N*M-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N*M-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N*M-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay003(coord prm_x, coord prm_y, coord prm_z,
                                                     angle prm_rx, angle prm_rz, angle prm_ry,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot1, uint32_t* prm_paUint32_dotmat1,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot2, uint32_t* prm_paUint32_dotmat2,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot3, uint32_t* prm_paUint32_dotmat3,
                                                     coord prm_r,
                                                     int prm_way_N, int prm_way_M,
                                                     angle prm_ang_clearance_N, angle prm_ang_clearance_M,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int, int, int) = nullptr);


    /**
     * ˌĂi_rx > _rz > _ryjɌ N*M-Waye𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_pFrom            ˌ
     * @param prm_pDepo_shot1      ˂Vbg̃f|WĝP
     * @param prm_paUint32_dotmat1 VbĝPgphbg}gbNX
     * @param prm_pDepo_shot2      ˂Vbg̃f|WĝQ
     * @param prm_paUint32_dotmat2 VbĝQgphbg}gbNX
     * @param prm_pDepo_shot3      ˂Vbg̃f|WĝR
     * @param prm_paUint32_dotmat3 VbĝRgphbg}gbNX
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_way_M            M-WayiRyωj
     * @param prm_ang_clearance_N  N-WaẙԊupx
     * @param prm_ang_clearance_M  M-WaẙԊupx
     * @param prm_velo_first       N*M-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N*M-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N*M-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay003(const GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot1, uint32_t* prm_paUint32_dotmat1,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot2, uint32_t* prm_paUint32_dotmat2,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot3, uint32_t* prm_paUint32_dotmat3,
                                                     coord prm_r,
                                                     int prm_way_N, int prm_way_M,
                                                     angle prm_ang_clearance_N, angle prm_ang_clearance_M,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int, int, int) = nullptr);

    /**
     * gUˏe𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_x               ˌXW
     * @param prm_y               ˌYW
     * @param prm_z               ˌZW
     * @param prm_rz              ˕Rz
     * @param prm_ry              ˕Ry
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_radial_way_num  PZbgˏWay
     * @param prm_expanse_angle   ˕ւ̕ˏȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         ˏWAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched f|Wg(prm_pDepo_shot) dispatch() āA
     *                                 ړAxAxݒ肳ꂽɃR[obN֐ݒB
     *                                 ɂ͎̒lnB
     *                                 void f(GgafDxCore::GgafDxFigureActor* prm_pActor, int prm_dispatch_num, int prm_set_index, int prm_way_index)
     *                                 prm_pActor         dispatch()ꂽẽAN^[
     *                                 prm_dispatch_num   ڂ dispatch() ̒e  (1`)
     *                                 prm_set_index      ˏWAYeZbgڂł邩 (0`)
     *                                 prm_way_index      WAYڂ̒eł邩         (0`)
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay004(coord prm_x, coord prm_y, coord prm_z,
                                                     angle prm_rz, angle prm_ry,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     int prm_radial_way_num, angle prm_expanse_angle,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_rz > _ryjɌĊgUˏe𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDxKuroko ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_radial_way_num  PZbgˏWay
     * @param prm_expanse_angle   ˕ւ̕ˏȅƎ˒Sp(0 ` D180ANGBď̍L̐p̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_velo_first      eZbg̃Vbgx
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         ˏWAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched f|Wg(prm_pDepo_shot) dispatch() āA
     *                                 ړAxAxݒ肳ꂽɃR[obN֐ݒB
     *                                 ɂ͎̒lnB
     *                                 void f(GgafDxCore::GgafDxFigureActor* prm_pActor, int prm_dispatch_num, int prm_set_index, int prm_way_index)
     *                                 prm_pActor         dispatch()ꂽẽAN^[
     *                                 prm_dispatch_num   ڂ dispatch() ̒e  (1`)
     *                                 prm_set_index      ˏWAYeZbgڂł邩 (0`)
     *                                 prm_way_index      WAYڂ̒eł邩         (0`)
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxFigureActor* shotWay004(const GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                     GgafCore::GgafActorDepository* prm_pDepo_shot,
                                                     coord prm_r,
                                                     int prm_radial_way_num, angle prm_expanse_angle,
                                                     velo prm_velo_first, acce prm_acce,
                                                     int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                     void (*pFunc_call_back_dispatched)(GgafDxCore::GgafDxFigureActor*, int, int, int) = nullptr);


};

}
#endif /*GGAFLIB_STGUTIL_H_*/



//s~bhƋ
//   a*x + b*y + c*z + d = 0
//  _D(x0,y0,z0)
//  _畽ʂɉ낵̍_H(x,y,z) Ƃ
//
//  xNg HD=(x0-x ,y0-y, z0-z) = t(a,b,c)  (t͎)  EEE@
//
//  @
//  x0 - x = t*a
//  y0 - y = t*b
//  z0 - z = t*c
//  Ȃ̂
//  x = x0 - t*a
//  y = y0 - t*b
//  z = z0 - t*c
//
//  𕽖ʂ֑̎
//  a*(x0-t*a) + b*(y0-t*b) + c*(z0-t*c) + d = 0
//
//  tɂĉ
//  t = (a*x0+b*y0+c*z0+d)/(a^2+b^2+c^2)  EEEA
//
//  
//  x =  x0 - t*a
//    =  x0 - ((a*x0+b*y0+c*z0+d)/(a^2+b^2+c^2))*a
//
//  y = y0 - t*b
//    = y0 - ((a*x0+b*y0+c*z0+d)/(a^2+b^2+c^2))*b
//
//  z = z0 - t*c
//    = z0 - ((a*x0+b*y0+c*z0+d)/(a^2+b^2+c^2))*c
//
//  ܂AHD̋
//  |HD|= |t(a,b,c)| = |t|*|(a,b,c)| = abs(t)*sqrt(a^2+b^2+c^2)  EEEB
//
//  AtB֑
//
//  |HD| = abs((c*z0+b*y0+a*x0+d)/(c^2+b^2+a^2))*sqrt(a^2+b^2+c^2)
//
//  |HD| = abs(a*x0+b*y0+c*z0+d) / sqrt(a^2+b^2+c^2)






//// ̓_(a,b,c)ʂAxNg(p,q,r)̒́B
//(x,y,z) = (a,b,c) + t(p,q,r)  (t͔}ϐ)
//
//x = a + t*p EEE @
//y = b + t*q EEE A
//z = c + t*r EEE B
//
//t = (x-a) /p = (y-b)/q = (z-c)/r
//
//
//_D(x0,y0,z0)
//_璼ɉ낵̍_H(x,y,z) Ƃ
//xNg HD = (x0-x,y0-y, z0-z)
//    = (x0-(a+t*p), y0-(b+t*q), z0-(c+t*r))  EEEC
//
//ꂪA(p,q,r) ƒ̂ŁA=0
//(x0-(a+t*p), y0-(b+t*q), z0-(c+t*r))E(p,q,r) = 0
//p*(x0-(a+t*p)) + q*(y0-(b+t*q)) + r*(z0-(c+t*r)) = 0
//
//tɂĉ
//
//t=(r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2)
//
//Ct ɑA HD 
//HD = ( x0-(a+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*p),
//y0-(b+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*q),
//z0-(c+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*r)    )
//
//|HD| = sqrt( (x0-(a+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*p))^2 +
//     (y0-(b+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*q))^2 +
//     (z0-(c+( (r*z0+q*y0+p*x0-c*r-b*q-a*p)/(r^2+q^2+p^2) )*r))^2   )
//
//|HD| = sqrt((q^2+p^2)*z0^2+(-2*q*r*y0-2*p*r*x0+(2*b*q+2*a*p)*r-2*c*q^2-2*c*p^2)*z0+(r^2+p^2)*y0^2+
//(-2*p*q*x0-2*b*r^2+2*c*q*r+2*a*p*q-2*b*p^2)*y0+(r^2+q^2)*x0^2+(-2*a*r^2+2*c*p*r-2*a*q^2+2*b*p*q)*x0+(b^2+a^2)*r^2+
//(-2*b*c*q-2*a*c*p)*r+(c^2+a^2)*q^2-2*a*b*p*q+(c^2+b^2)*p^2)/(sqrt(r^2+q^2+p^2))





//// _ A(a,b,c) B(d,e,f) ʂ钼
//AB = (d-a, e-b, f-c)
//(x,y,z) = (a,b,c) + t(d-a, e-b, f-c)  (t͔}ϐ)
//
//x = a + t*(d-a) EEE @
//y = b + t*(e-b) EEE A
//z = c + t*(f-c) EEE B
//
//_D(x0,y0,z0)
//_璼ɉ낵̍_H(x,y,z) Ƃ
//xNg HD = (x0-x,y0-y, z0-z)
//            = (x0-(a+t*(d-a)), y0-(b+t*(e-b)), z0-(c+t*(f-c)))  EEEC
//
//
//ꂪAAB=(d-a, e-b, f-c) ƒ̂ŁA=0
//(x0-(a+t*(d-a)), y0-(b+t*(e-b)), z0-(c+t*(f-c)))E(d-a, e-b, f-c) = 0
//Ȃ̂
//(x0-(a+t*(d-a)))*(d-a) + (y0-(b+t*(e-b)))*(e-b) + (z0-(c+t*(f-c)))*(f-c) = 0
//
//tɂĉ
//
//t = ((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2)
//
//C t ɑA HD 
//HD = ( x0-(a+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(d-a)) ,
//       y0-(b+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(e-b)) ,
//       z0-(c+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(f-c))   )
//
//|HD| = sqrt( (x0-(a+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(d-a)))^2 +
//             (y0-(b+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(e-b)))^2 +
//             (z0-(c+(((f-c)*z0+(e-b)*y0+(d-a)*x0-c*f-b*e-a*d+c^2+b^2+a^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))*(f-c)))^2    )
//
//=sqrt(((e^2-2*b*e+d^2-2*a*d+b^2+a^2)*z0^2+(((2*b-2*e)*f+2*c*e-2*b*c)*y0+((2*a-2*d)*f+2*c*d-2*a*c)*x0+
//(2*b*e+2*a*d-2*b^2-2*a^2)*f-2*c*e^2+2*b*c*e-2*c*d^2+2*a*c*d)*z0+(f^2-2*c*f+d^2-2*a*d+c^2+a^2)*y0^2+
//(((2*a-2*d)*e+2*b*d-2*a*b)*x0-2*b*f^2+(2*c*e+2*b*c)*f+(2*a*d-2*c^2-2*a^2)*e-2*b*d^2+2*a*b*d)*y0+
//(f^2-2*c*f+e^2-2*b*e+c^2+b^2)*x0^2+(-2*a*f^2+(2*c*d+2*a*c)*f-2*a*e^2+(2*b*d+2*a*b)*e+(-2*c^2-2*b^2)*d)*x0+(b^2+a^2)*
//f^2+(-2*b*c*e-2*a*c*d)*f+(c^2+a^2)*e^2-2*a*b*d*e+(c^2+b^2)*d^2)/(f^2-2*c*f+e^2-2*b*e+d^2-2*a*d+c^2+b^2+a^2))












//_ A(x1,y2,z1) B(x2,y1,z1) ʂ钼Ɠ_D(o_scx,o_scy,o_scz)̋
//
//(x1,y2,z1) (x2,y1,z1)     (o_scx,o_scy,o_scz)
//
//sqrt(((y1^2-2*y2*y1+x2^2-2*x1*x2+y2^2+x1^2)*o_scz^2+(((2*y2-2*y1)*z1+2*z1*y1-2*y2*z1)*o_scy+((2*x1-2*x2)*z1+2*z1*x2-2*x1*z1)*o_scx+
//(2*y2*y1+2*x1*x2-2*y2^2-2*x1^2)*z1-2*z1*y1^2+2*y2*z1*y1-2*z1*x2^2+2*x1*z1*x2)*o_scz+(z1^2-2*z1*z1+x2^2-2*x1*x2+z1^2+x1^2)*o_scy^2+
//(((2*x1-2*x2)*y1+2*y2*x2-2*x1*y2)*o_scx-2*y2*z1^2+(2*z1*y1+2*y2*z1)*z1+(2*x1*x2-2*z1^2-2*x1^2)*y1-2*y2*x2^2+2*x1*y2*x2)*o_scy+
//(z1^2-2*z1*z1+y1^2-2*y2*y1+z1^2+y2^2)*o_scx^2+(-2*x1*z1^2+(2*z1*x2+2*x1*z1)*z1-2*x1*y1^2+(2*y2*x2+2*x1*y2)*y1+(-2*z1^2-2*y2^2)*x2)*o_scx+(y2^2+x1^2)*
//z1^2+(-2*y2*z1*y1-2*x1*z1*x2)*z1+(z1^2+x1^2)*y1^2-2*x1*y2*x2*y1+(z1^2+y2^2)*x2^2)/(z1^2-2*z1*z1+y1^2-2*y2*y1+x2^2-2*x1*x2+z1^2+y2^2+x1^2))
//
//
//sqrt(((y2^2-2*y1*y2+y1^2+x2^2-2*x1*x2+x1^2)*z1^2+(-2*o_scz*y2^2+4*o_scz*y1*y2-2*o_scz*y1^2-2*o_scz*x2^2+4*o_scz*x1*x2-2*o_scz*x1^2)*z1+
//(x2^2-2*o_scx*x2+o_scz^2+o_scx^2)*y2^2+
//(((2*o_scx-2*x1)*x2+2*o_scx*x1-2*o_scz^2-2*o_scx^2)*y1-2*o_scy*x2^2+(2*o_scy*x1+2*o_scx*o_scy)*x2-2*o_scx*o_scy*x1)*y2+
//(x1^2-2*o_scx*x1+o_scz^2+o_scx^2)*y1^2+((2*o_scy*x1-2*o_scx*o_scy)*x2-2*o_scy*x1^2+2*o_scx*o_scy*x1)*y1+(o_scz^2+o_scy^2)*x2^2+(-2*o_scz^2-2*o_scy^2)*x1*
//x2+(o_scz^2+o_scy^2)*x1^2)/(y2^2-2*y1*y2+y1^2+x2^2-2*x1*x2+x1^2))
//
//
//
//
//t=((z1-z1)*z0+(y1-y2)*y0+(x2-x1)*x0-z1*z1-y2*y1-x1*x2+z1^2+y2^2+x1^2)/(z1^2-2*z1*z1+y1^2-2*y2*y1+x2^2-2*x1*x2+z1^2+y2^2+x1^2)
//
//t=(y2^2+(-y1-y0)*y2+y0*y1+(x0-x1)*x2+x1^2-x0*x1)/(y2^2-2*y1*y2+y1^2+x2^2-2*x1*x2+x1^2)
