#ifndef GGAFLIB_MASSWALLACTOR_H_
#define GGAFLIB_MASSWALLACTOR_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxMassMeshActor.h"

#define FACE_A_IDX 5
#define FACE_B_IDX 4
#define FACE_C_IDX 3
#define FACE_D_IDX 2
#define FACE_E_IDX 1
#define FACE_F_IDX 0

#define FACE_A_BIT 32  // 0b100000
#define FACE_B_BIT 16  // 0b010000
#define FACE_C_BIT 8   // 0b001000
#define FACE_D_BIT 4   // 0b000100
#define FACE_E_BIT 2   // 0b000010
#define FACE_F_BIT 1   // 0b000001

namespace GgafLib {

/**
 * OǃV[(WallSectionScene)̕ǃubNNX .
 * OǃV[(WallSectionScene)̍\vf̕ǃubN͖{NXpKvB
 * @version 1.00
 * @since 2016/03/08
 * @author Masatoshi Tsuge
 */
class MassWallActor : public GgafDxCore::GgafDxMassMeshActor {
    friend class GgafDxEffectManager;

protected:
    struct VERTEX_instancedata {
        float _11, _12, _13, _14;   // : TEXCOORD1  WorldϊsAPs
        float _21, _22, _23, _24;   // : TEXCOORD2  WorldϊsAQs
        float _31, _32, _33, _34;   // : TEXCOORD3  WorldϊsARs
        float _41, _42, _43, _44;   // : TEXCOORD4  WorldϊsASs
        float _wall_draw_face, _pos_info;  // : TEXCOORD5 ǃubNvYʒu, ǃubN\
    };
    static VERTEX_instancedata _aInstancedata[];
    static void createVertexInstanceData(void* prm, GgafDxCore::GgafDxMassModel::VertexInstanceDataInfo* out_info);

public:
    static D3DXHANDLE _h_distance_AlphaTarget;
    static D3DXHANDLE _h_wall_dep;
    static D3DXHANDLE _h_wall_height;
    static D3DXHANDLE _h_wall_width;
    static D3DXHANDLE _h_ah_POS_PRISM_ZX;
    static D3DXHANDLE _h_fh_POS_PRISM_ZX;
    static D3DXHANDLE _h_ah_POS_PRISM_YZ;
    static D3DXHANDLE _h_fh_POS_PRISM_YZ;
    static D3DXHANDLE _h_ah_POS_PRISM_XY;
    static D3DXHANDLE _h_fh_POS_PRISM_XY;
    static D3DXHANDLE _h_reflectance;

    /** vYǉ`svʃe[u */
    static std::map<int, UINT> _delface;

    /** [r]ǃubNvYʒu(> 0̏ꍇ̓vY̓s~bhA0̏ꍇBOX) */
    int _pos_info;
    /** [r]ǃubN\ʏ */
    int _wall_draw_face;
    /** [r]ǃubN̒iXWj*/
    coord _wall_dep;
    /** [r]ǃubN̍iYWj*/
    coord _wall_height;
    /** [r]ǃubN̕iZWj*/
    coord _wall_width;
//    /** [r]ǃubNړXs[h(l͐AAړX̕) */
//    int _scroll_speed;
    GgafLib::CollisionChecker* _pColliChecker;
    /** [r]OǃV[ */
    WallSectionScene* _pWallSectionScene;

public:
    MassWallActor(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat=nullptr);
    MassWallActor(const char* prm_name,
                  const char* prm_model,
                  const char* prm_effect,
                  const char* prm_technique,
                  GgafCore::GgafStatus* prm_pStat=nullptr);
//    MassWallActor(const char* prm_name,
//                  const char* prm_model_id,
//                  const char* prm_effect_id,
//                  const char* prm_technique,
//                  GgafCore::GgafStatus* prm_pStat,
//                  GgafDxCore::GgafDxChecker* prm_pChecker);

    void init();

    static bool initStatic(MassWallActor* prm_pMassWallActor);

    virtual void executeHitChk_MeAnd(GgafActor* prm_pOtherActor) override;

    virtual void onCreateModel() override {
    }
    virtual void initialize() override;

    virtual void onActive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    virtual void processPreDraw() override;

    virtual void processDraw() override;

    virtual bool isOutOfSpacetime() const override;

    virtual int isOutOfView() override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual void onHit(const GgafCore::GgafActor* prm_pOtherActor) override {
    }

    virtual void drawHitArea() override;

    /**
     * ǃubNݒ肷 .
     * @param prm_pWallSectionScene WallSectionSceneIuWFNg
     * @param prm_pos_info vYʒuԍivY^ubN̏ꍇ̂݁j
     * @param prm_wall_draw_face ǃubN\ʏ
     * @param prm_aColliBoxStretch ǃubN蔻
     */
    virtual void config(WallSectionScene* prm_pWallSectionScene,
                        int prm_pos_info, int prm_wall_draw_face, int* prm_aColliBoxStretch);

    inline CollisionChecker* getCollisionChecker() {
        return _pColliChecker;
    }

    virtual ~MassWallActor();
};

}
#endif /*GGAFLIB_WALLPARTSACTOR_H_*/
