#ifndef GGAFLIB_CAMERAWORKER_H_
#define GGAFLIB_CAMERAWORKER_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/actor/GgafMainActor.h"

namespace GgafLib {

/**
 * J} .
 * J(VioletVreath::Camera)ƁA_(VioletVreath::CameraViewPoint) 𑀂A
 *  UP̕xNg pUp_ Ǘ܂B
 * @version 1.00
 * @since 2010/10/25
 * @author Masatoshi Tsuge
 */
class CameraWorker : public GgafCore::GgafMainActor {

    /** [JUPvfxNg̖ʔԍ][̔΃xNg̖ʔԍ] = ̑ÓUPvfxNg̖ʔԍ(ADIR26_NULL͈ړsvӖ)  ֘Ae[u */
    static int relation_up_vec_[3*3*3][3*3*3];
    /** relation_up_vec_ANZXp */
    static int (*relation_up_by_vec_)[3*3*3];

private:
    /** ݂̃J_̕ԍ */
    dir26 vcv_dir_;
    /** OJ_̕ԍ */
    dir26 vcv_dir_prev_;

public:
    /** [r]Jւ̎Q */
    DefaultCamera* pCam_;
    /** [r]_ւ̎Q */
    DefaultCameraViewPoint* pVp_;
    /** [r]J̏̈ʒuxNg */
    DefaultCameraUpVector*  pUp_;
    /** J}̈ړڕWW */
    coord t_x_CAM_, t_y_CAM_, t_z_CAM_;
    /** J}̃r[|Cg̈ړڕWW */
    coord t_x_VP_, t_y_VP_, t_z_VP_;
    /** J}̓̕ڕWԍ */
    dir26 t_cam_up_dir_;

    frame frame_of_behaving_since_onSwitch_;

public:
    CameraWorker(const char* prm_name, DefaultCamera* prm_pCamera);

    static bool initStatic();

    virtual void initialize() override;

    virtual void onActive() override;
    /**
     * XCb`ꂽꍇɌĂяoR[obN .
     * ܂ŎgANeBu CameraWorker A
     * Spacetime::changeCameraWork() ɂ育wA
     *  Spacetime::undoCameraWork() sɂ蕜AA
     * ƂɂAANeBuɐ؂ւŏ̃t[
     * Spacetime::processBehavior() ŃR[obNB
     */
    virtual void onSwitchCameraWork();

    /**
     *  CameraWorker ɐ؂ւۂ̃R[obN .
     * ܂ŎgANeBu CameraWorker A
     * Spacetime::changeCameraWork()  Spacetime::undoCameraWork() sɂA
     *  CameraWorker ɐ؂ւ̂ŁAt[玩gANeBu
     * ȂĂ܂Ƃ inactivate() s钼OɌĂяoR[obNB
     */
    virtual void onChangedToOtherCameraWork();

    void targetAutoCamup();

    virtual void processJudgement() override {}

    virtual void processDraw() override {}

    virtual void processFinal() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual bool processHitChkLogic(GgafCore::GgafActor* prm_pOtherActor) override {
        return false;
    }

    inline frame getSwitchedFrame() {
        return frame_of_behaving_since_onSwitch_;
    }

    void slideMvCamTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t);
    void slideMvCamTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t,
                      float prm_x_p1, float prm_y_p1, float prm_z_p1);
    void slideMvCamTo(coord tx, coord ty, coord tz, frame t);
    void slideMvCamTo(coord tx, coord ty, coord tz, frame t,
                      float prm_x_p1, float prm_y_p1, float prm_z_p1);
    void mvCamTo(coord tx, coord ty, coord tz);

    bool isCamSliding();
    void slideMvVpTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t);
    void slideMvVpTo(coord tx, coord ty, coord tz, frame t);

    void slideMvUpVecTo(coord tx, coord ty, coord tz, frame t);
    void slideMvUpVecTo(dir26 prm_up_dir_no, frame t);

    void setUpVec(coord tx, coord ty, coord tz);
//    void stopNaturallyCam(coord distance, frame t);
//    void stopNaturallyVp(coord distance, frame t);

    void stopMvCam();
    void stopMvVp();
//    void behaveAutoCamUp();
    virtual ~CameraWorker(); //fXgN^
};

}
#endif /*CAMERAWORKER_H_*/
