#ifndef GGAFLIB_FRAMEDGRAPHBARACTOR_H_
#define GGAFLIB_FRAMEDGRAPHBARACTOR_H_
#include "jp/ggaf/lib/actor/DefaultFramedBoardActor.h"
#include "jp/ggaf/lib/util/Quantity.hpp"

namespace GgafLib {


/**
 * ʃo[iP`j .
 * @version 1.00
 * @since 2013/09/17
 * @author Masatoshi Tsuge
 */
class FramedHorizontalBarActor : public DefaultFramedBoardActor {

protected:
    /** [r]RXgN^PxQuantity newꍇ true */
    bool _is_new_Quantity;

public:
    /** [r]ʃo[el */
    Quantity<int, pixcoord>* _pPxQty;
    /** [r]ʃo[ől */
    int _min_val;
    /** [r]ʃo[ŏl */
    int _max_val;

public:
    /**
     *
     * @param prm_name
     * @param prm_pPxQty configς݂ PxQuantityIuWFNg̎Q
     */
    FramedHorizontalBarActor(const char* prm_name, const char* prm_model, Quantity<int, pixcoord>* prm_pPxQty);

    FramedHorizontalBarActor(const char* prm_name, const char* prm_model);

    /**
     * ̃o[̒lێ Quantity u .
     * @param prm_pPxQty
     */
    void linkQty(Quantity<int, pixcoord>* prm_pPxQty);

    /**
     * ̃o[̒lێ Quantity ̎QƕϐύX .
     * @param prm_pVariable
     */
    void linkVariable(int* prm_pVariable);

    /**
     * o[̒lɑ΂sNZ̖ڐtB
     * @param prm_min_val o[ŏlݒiȉ̒l̓ZbgłȂȂj
     * @param prm_max_val o[őlݒiȏ̒l̓ZbgłȂȂj
     * @param prm_px_from_min_to_max ŏl`ől̉ʏ̃sNZݒ
     */
    inline void graduate(int prm_min_val, int prm_max_val, pixcoord prm_px_from_min_to_max ) {
        _min_val = prm_min_val;
        _max_val = prm_max_val;
        _pPxQty->graduate(prm_max_val - prm_min_val, prm_px_from_min_to_max);
    }

    /**
     * o[̒lݒ .
     * linkĂꍇAN̒lύX̂Œ .
     * @param prm_val [^[l
     */
    inline void setVal(int prm_val) {
        if (_max_val < prm_val) {
            _pPxQty->setVal(_max_val);
        } else if (_min_val > prm_val) {
            _pPxQty->setVal(_min_val);
        } else {
            _pPxQty->setVal(prm_val);
        }
    }

    /**
     * o[̒l擾 .
     * @return o[̒l
     */
    inline int getVal() {
        return _pPxQty->getVal();
    }

    /**
     * o[̌ݒlɑΉsNZl擾
     * @return sNZl
     */
    inline pixcoord getBarPx() {
        return _pPxQty->getQty();
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̉Zl
     */
    inline void incVal(int prm_val) {
        setVal(_pPxQty->getVal() + prm_val);
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̌Zl
     */
    inline void decVal(int prm_val) {
        setVal(_pPxQty->getVal() - prm_val);
    }

    virtual void processPreDraw() override;

    virtual ~FramedHorizontalBarActor();
};

}
#endif /*GGAFLIB_FRAMEDGRAPHBARACTOR_H_*/

