#include "jp/ggaf/dxcore/sound/GgafDxSeTransmitter.h"

#include "jp/ggaf/dxcore/manager/GgafDxSeManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxSeConnection.h"
#include "jp/ggaf/dxcore/sound/GgafDxSound.h"
#include "jp/ggaf/dxcore/sound/GgafDxSe.h"
#include <stdio.h>

using namespace GgafCore;
using namespace GgafDxCore;


GgafDxSeTransmitter::GgafDxSeTransmitter() : GgafObject() {
    _se_num = 0;
    _papSeConnection = nullptr;
}

void GgafDxSeTransmitter::declareSeNum(int prm_se_num) {
    _se_num = prm_se_num;
    _papSeConnection = NEW GgafDxSeConnection*[_se_num];
    for (int i = 0; i < _se_num; i++) {
        _papSeConnection[i] = nullptr;
    }
}

void GgafDxSeTransmitter::set(int prm_se_no, const char* prm_se_key, int prm_cannel) {
    if (_papSeConnection == nullptr) {
        declareSeNum(prm_se_no+1); //declareSeNumȂꍇprm_id+1܂
    }
    if (prm_se_no < 0) {
        throwGgafCriticalException("ID͈͊OłB̐ł肢܂B prm_se_no="<<prm_se_no);
    } else if (prm_se_no >= _se_num) {
        //_papSeConnection[] gB
        int wk_se_num = _se_num;
        GgafDxSeConnection** papSeConnection = NEW GgafDxSeConnection*[_se_num];
        for (int i = 0; i < wk_se_num; i++) { //ޔ
            papSeConnection[i] = _papSeConnection[i];
        }
        GGAF_DELETEARR_NULLABLE(_papSeConnection);
        declareSeNum(prm_se_no+1); //prm_se_no+1 ֌gB̎_ _se_num  prm_se_no+1 ōXV
        for (int i = 0; i < wk_se_num; i++) { //piޔ߂j
            _papSeConnection[i] = papSeConnection[i];
        }
        GGAF_DELETEARR_NULLABLE(papSeConnection);
    }
    if (strlen(prm_se_key) > 128) {
        throwGgafCriticalException("SEID߂܂B128ɗ}ĉBprm_se_key="<<prm_se_key);
    }
    std::string idstr =  XTOS(prm_cannel) + "/" + prm_se_key; //RlNV̎ID u`lԍ + "/" + waveʖv
                                                              //Ƃ邱ƂɂA`lԍȂ new ȂB
    if (_papSeConnection[prm_se_no]) {
        _TRACE_("x ID="<<prm_se_no<<" ɂSE("<<(_papSeConnection[prm_se_no]->getIdStr())<<")ݒς݂łBڑ close AVSE("<<idstr<<")㏑܂BӐ}Ă܂H");
        _papSeConnection[prm_se_no]->close();
    }
    _papSeConnection[prm_se_no] = connectToSeManager(idstr.c_str());
}


void GgafDxSeTransmitter::play(int prm_se_no) {
#ifdef MY_DEBUG
    if (prm_se_no < 0 || prm_se_no >= _se_num) {
        throwGgafCriticalException("ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_se_no="<<prm_se_no);
    }
#endif
    _papSeConnection[prm_se_no]->peek()->play();
}

void GgafDxSeTransmitter::stop(int prm_se_no) {
#ifdef MY_DEBUG
    if (prm_se_no < 0 || prm_se_no >= _se_num) {
        throwGgafCriticalException("ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_se_no="<<prm_se_no);
    }
#endif
    _papSeConnection[prm_se_no]->peek()->stop();
}

void GgafDxSeTransmitter::setLooping(int prm_se_no, bool prm_can_looping) {
#ifdef MY_DEBUG
    if (prm_se_no < 0 || prm_se_no >= _se_num) {
        throwGgafCriticalException("ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_se_no="<<prm_se_no);
    }
#endif
    _papSeConnection[prm_se_no]->peek()->setLooping(prm_can_looping);
}

GgafDxSe* GgafDxSeTransmitter::get(int prm_se_no) const {
#ifdef MY_DEBUG
    if (prm_se_no < 0 || prm_se_no >= _se_num) {
        throwGgafCriticalException("ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_se_no="<<prm_se_no);
    }
#endif
    return _papSeConnection[prm_se_no]->peek();
}


GgafDxSeTransmitter::~GgafDxSeTransmitter() {
    for (int i = 0; i < _se_num; i++) {
        if (_papSeConnection[i]) {
            _papSeConnection[i]->close();
        }
    }
    GGAF_DELETEARR_NULLABLE(_papSeConnection);
}

