#include "jp/ggaf/dxcore/sound/GgafDxBgm.h"

#include "jp/ggaf/dxcore/sound/GgafDxSound.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/sound/IkdLib/OggVorbisFile.h"
#include "jp/ggaf/dxcore/sound/IkdLib/OggDecoder.h"
#include "jp/ggaf/dxcore/sound/IkdLib/PCMPlayer.h"
#include "Shlwapi.h"
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

using namespace GgafCore;
using namespace GgafDxCore;
using namespace IkdLib;

//GgafDxBgm::GgafDxBgm(char* prm_ogg_name) : GgafObject() {
//    _TRACE_(FUNC_NAME<<" "<<prm_ogg_name);
//    if (GgafDxSound::_pIDirectSound8 == nullptr) {
//        throwGgafCriticalException("GgafDxBgm::GgafDxBgm("<<prm_ogg_name<<") DirectSound A܂Ă܂B");
//    }
//    _file_name = std::string(prm_ogg_name);
//    std::string ogg_filename = PROPERTY::DIR_OGG[0] + _file_name + ".ogg";
//    _pOggResource = NEW OggVorbisFile( ogg_filename.c_str() );
//    _pOggDecoder =  NEW OggDecoder( _pOggResource );
//    _pPcmPlayer = NEW PCMPlayer(GgafDxSound::_pIDirectSound8 , _pOggDecoder);
//}

GgafDxBgm::GgafDxBgm(const char* prm_bgm_key) : GgafObject() {
    if (GgafDxSound::_pIDirectSound8 == nullptr) {
        throwGgafCriticalException("prm_bgm_key="<<prm_bgm_key<<" DirectSound A܂Ă܂B");
    }

    int len = strlen(prm_bgm_key);
    _bgm_key = NEW char[len+1];
    strcpy(_bgm_key, prm_bgm_key);

    _ogg_file_name = GgafProperties::_mapProperties[std::string(_bgm_key)];
    if (_ogg_file_name == "") {
        throwGgafCriticalException("prm_bgm_key="<<prm_bgm_key<<" vpeBt@CɃL[܂");
    }
//    _bpm = atoi(GgafProperties::_mapProperties[bgm_key+"_BPM"].c_str());
//    _title = GgafProperties::_mapProperties[bgm_key+"_TITLE"];
//    _TRACE_(FUNC_NAME<<" KEY="<<prm_bgm_key<<" _file_name="<<_ogg_file_name<<" _bpm="<<_bpm<<" _title="<<_title);
    std::string full_ogg_file_name = getOggFileName(_ogg_file_name);
    _pOggResource = NEW OggVorbisFile( full_ogg_file_name.c_str() );
    _pOggDecoder =  NEW OggDecoder( _pOggResource );
    _pPcmPlayer = NEW PCMPlayer(GgafDxSound::_pIDirectSound8 , _pOggDecoder);
}

std::string GgafDxBgm::getOggFileName(std::string prm_file) {
    std::string ogg_file = PROPERTY::DIR_OGG[2] + "/" + prm_file;
    UTIL::strReplace(ogg_file, "//", "/");
    if (PathFileExists(ogg_file.c_str()) ) {
        return ogg_file;
    } else {
        ogg_file = PROPERTY::DIR_OGG[1] + "/" + prm_file;
        UTIL::strReplace(ogg_file, "//", "/");
        if (PathFileExists(ogg_file.c_str()) ) {
            return ogg_file; //[U[XLɑ݂΂D
        } else {
            ogg_file = PROPERTY::DIR_OGG[0] + "/" + prm_file;
            UTIL::strReplace(ogg_file, "//", "/");
            if (PathFileExists(ogg_file.c_str()) ) {
                return ogg_file;
            } else {
                throwGgafCriticalException("oggt@C܂Bogg_file="<<ogg_file);
            }
        }
    }
}

void GgafDxBgm::play(int prm_volume, float prm_pan, bool prm_is_looping) {
    setVolume(prm_volume);
    setPan(prm_pan);
    _pPcmPlayer->play(prm_is_looping);
}
void GgafDxBgm::play(bool prm_is_looping) {
    play(GGAF_MAX_VOLUME, 0.0f, prm_is_looping);
}
void GgafDxBgm::pause() {
    _pPcmPlayer->pause();
}
void GgafDxBgm::unpause() {
    _pPcmPlayer->unpause();
}

void GgafDxBgm::stop() {
    _pPcmPlayer->stop();
}

void GgafDxBgm::setVolume(int prm_volume) {
    //{[fVx
    int db = GgafDxSound::_a_db_volume[(int)(prm_volume * GgafDxSound::_app_master_volume_rate * GgafDxSound::_bgm_master_volume_rate)];
    _pPcmPlayer->setVolume(db);
}

void GgafDxBgm::setPan(float prm_pan) {
    _pPcmPlayer->setPan(prm_pan*DSBPAN_RIGHT);
}


void GgafDxBgm::clear() {
    _pPcmPlayer->clear();
}

bool GgafDxBgm::isPlaying() {
    if (_pPcmPlayer->getState() == PCMPlayer::STATE_PLAY) {
        return true;
    } else {
        return false;
    }
}

GgafDxBgm::~GgafDxBgm() {
    _TRACE_(FUNC_NAME<<" begin");
    _TRACE_("_pPcmPlayer->setVolume(DSBVOLUME_MIN);");
    _pPcmPlayer->setVolume(DSBVOLUME_MIN);
    _TRACE_("_pPcmPlayer->terminateThread();");
    _pPcmPlayer->terminateThread();
    _TRACE_("GGAF_DELETE(_pPcmPlayer);");
    GGAF_DELETE(_pPcmPlayer);
    _TRACE_("GGAF_DELETE(_pOggDecoder);");
    GGAF_DELETE(_pOggDecoder);
    _TRACE_("GGAF_DELETE(_pOggResource);");
    GGAF_DELETE(_pOggResource);
    GGAF_DELETEARR(_bgm_key);
    _TRACE_(FUNC_NAME<<" end");
}

