#include "jp/ggaf/dxcore/manager/GgafDxSeManager.h"

#include <cstring>
#include "jp/ggaf/dxcore/manager/GgafDxSeConnection.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxSeManager::GgafDxSeManager(const char* prm_manager_name) :
    GgafResourceManager<GgafDxSe> (prm_manager_name) {
}

GgafDxSe* GgafDxSeManager::processCreateResource(const char* prm_idstr, void* prm_pConnector) {
    // prm_idstr = "1/laser" ̏ꍇAf}l[W[̃L[ɂ"1/laser"œo^邱ƂɂȂB
    // Aǂݍwavet@C"laser.wav"ƂB
    // ́Awave𕡐`lŖ炵ꍇAŏ̐lω΁A
    // mۂƎӖB

    GgafDxSe* pResource = nullptr;
    std::string idstr = std::string(prm_idstr);
    std::vector<std::string> names = UTIL::split(idstr, "/", 1); //ŏ̃XbVŕ
    if (names.size() == 2) {
        pResource = NEW GgafDxSe(names[1].c_str());
    } else {
        pResource = NEW GgafDxSe(names[0].c_str());
    }
    return pResource;
}

void GgafDxSeManager::updateVolume() {
    while (_is_connecting_resource) {
        Sleep(1);
    }
    GgafDxSeConnection* pConne = (GgafDxSeConnection*)_pConn_first;
    while (pConne) {
        pConne->peek()->setVolume(GGAF_MAX_VOLUME);
        while (_is_connecting_resource) { //ȈՔr
            Sleep(1);
        }
        pConne = (GgafDxSeConnection*)(pConne->getNext());
    }
}

GgafResourceConnection<GgafDxSe>* GgafDxSeManager::processCreateConnection(const char* prm_idstr, GgafDxSe* prm_pResource) {
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐JnB");
    GgafDxSeConnection* pConne = NEW GgafDxSeConnection(prm_idstr, prm_pResource);
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐IB");
    return pConne;
}
