
// {vO Paul Coppens ̍쐬ꂽAXt@CǂݍރTv
// ɁAƎɉǏCifobOjNXgpĂ܂B
// 肪Ƃ PaulB
//
// yΏہz
// Frm OԂ̃NX
//
// yLoading and displaying .X files without DirectX z
// http://www.gamedev.net/reference/programming/features/xfilepc/
//
//                                         2009/03/06 Masatoshi Tsuge

#include "jp/ggaf/dxcore/manager/GgafDxModelManager.h"

#include <Shlwapi.h>
#include <d3dx9xof.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

#include "jp/ggaf/dxcore/GgafDxGod.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureManager.h"
#include "jp/ggaf/dxcore/model/GgafDxD3DXMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxD3DXAniMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxSpriteModel.h"
#include "jp/ggaf/dxcore/model/GgafDxSpriteSetModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMassSpriteModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMeshSetModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMassMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMorphMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMassMorphMeshModel.h"
#include "jp/ggaf/dxcore/model/GgafDxBoardModel.h"
#include "jp/ggaf/dxcore/model/GgafDxBoardSetModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMassBoardModel.h"
#include "jp/ggaf/dxcore/model/GgafDxPointSpriteModel.h"
#include "jp/ggaf/dxcore/model/GgafDxMassPointSpriteModel.h"
#include "jp/ggaf/dxcore/model/GgafDxPointSpriteSetModel.h"
#include "jp/ggaf/dxcore/model/GgafDxFramedBoardModel.h"
#include "jp/ggaf/dxcore/model/ex/GgafDxCubeMapMeshModel.h"
#include "jp/ggaf/dxcore/model/ex/GgafDxCubeMapMeshSetModel.h"
#include "jp/ggaf/dxcore/model/ex/GgafDxCubeMapMorphMeshModel.h"
#include "jp/ggaf/dxcore/model/ex/GgafDxWorldBoundModel.h"
#include "jp/ggaf/dxcore/util/GgafDxWorldMatStack.h"
#include "jp/ggaf/dxcore/util/GgafDxAllocHierarchyWorldFrame.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/texture/GgafDxTexture.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelConnection.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxModel* GgafDxModelManager::_pModelLastDraw = nullptr;
ID3DXFile* GgafDxModelManager::_pID3DXFile_sprx = nullptr;
ID3DXFile* GgafDxModelManager::_pID3DXFile_psprx = nullptr;
GgafDxTextureManager* GgafDxModelManager::_pModelTextureManager = nullptr;

GgafDxModelManager::GgafDxModelManager(const char* prm_manager_name) :
    GgafResourceManager<GgafDxModel> (prm_manager_name) {

    //eNX`}lW[
    GgafDxModelManager::_pModelTextureManager = NEW GgafDxTextureManager("GgafDxTextureManager");
    //|Sf`t@C(gqsprx)̃tH[}bg`
    HRESULT hr;
    D3DXFileCreate( &GgafDxModelManager::_pID3DXFile_sprx );
    static const char* sprite_model_xfile_template =
    "xof 0303txt 0032\n" \
    "template SpriteDef {" \
    "   <E4EECE4C-E106-11DC-9B62-346D55D89593>" \
    "   FLOAT  Width;" \
    "   FLOAT  Height;" \
    "   STRING TextureFile;" \
    "   DWORD  TextureSplitRows;" \
    "   DWORD  TextureSplitCols;" \
    "}";

    hr = GgafDxModelManager::_pID3DXFile_sprx->RegisterTemplates(sprite_model_xfile_template, (DWORD)(strlen(sprite_model_xfile_template)));
#ifdef MY_DEBUG
    if(hr != S_OK) {
        throwGgafCriticalException("RegisterTemplatesɎs܂Bsprite_model_xfile_template mFĉB");
    }
#endif

    //|CgXvCg`t@C(gqpsprx)̃tH[}bg`
    D3DXFileCreate( &GgafDxModelManager::_pID3DXFile_psprx );
    static const char* pointsprite_model_xfile_template =
            "xof 0303txt 0032\n" \
            "template Vector {\n" \
            "  <3d82ab5e-62da-11cf-ab39-0020af71e433>\n" \
            "  FLOAT x;\n" \
            "  FLOAT y;\n" \
            "  FLOAT z;\n" \
            "}\n" \
            "template ColorRGBA {\n" \
            "  <35ff44e0-6c7c-11cf-8f52-0040333594a3>\n" \
            "  FLOAT red;\n" \
            "  FLOAT green;\n" \
            "  FLOAT blue;\n" \
            "  FLOAT alpha;\n" \
            "}\n" \
            "template PointSpriteDef {\n" \
            "  <E4EECE4C-E106-11DC-9B62-346D55D89593>\n" \
            "  FLOAT  SquareSize;\n" \
            "  STRING TextureFile;\n" \
            "  DWORD  TextureSplitRowCol;\n" \
            "  DWORD  VerticesNum;\n" \
            "  array  Vector    Vertices[VerticesNum];\n" \
            "  array  ColorRGBA VertexColors[VerticesNum];\n" \
            "  array  DWORD     InitUvPtnNo[VerticesNum];\n" \
            "  array  FLOAT     InitScale[VerticesNum];\n" \
            "}\n" \
            "\n";
    hr = GgafDxModelManager::_pID3DXFile_psprx->RegisterTemplates(pointsprite_model_xfile_template, (DWORD)(strlen(pointsprite_model_xfile_template)));
#ifdef MY_DEBUG
    if(hr != S_OK) {
        throwGgafCriticalException("RegisterTemplatesɎs܂B\""<<PROPERTY::DIR_SPRITE_MODEL[0]<<"ggaf_pointspritemodel_define.x\"mFĉB");
    }
#endif
}

GgafDxModel* GgafDxModelManager::processCreateResource(const char* prm_idstr, void* prm_pConnector) {
    std::string idstr = std::string(prm_idstr);
    std::vector<std::string> names = UTIL::split(idstr, "/", 1); //ŏ̃XbVŕ
    if (names.size() != 2) {
        throwGgafCriticalException("́AɎ̌`ŗ^ĂBwf^Cv1  + \"/\" + f`(gq .x )x\n"<<
                "ۂ̈́Aprm_idstr="<<prm_idstr);
    }
    char model_type = (names[0])[0];
    const char* model_name = names[1].c_str();
    GgafDxModel* pResourceModel;
    switch (model_type) {
        case 'D':
            //D3DXMeshModel
            pResourceModel = createD3DXMeshModel(model_name, D3DXMESH_SYSTEMMEM);
            break;
        case 'd':
            //DynaD3DXMeshModel
            pResourceModel = createD3DXMeshModel(model_name, D3DXMESH_DYNAMIC);
            break;
        case 'A':
            //D3DXAniMeshModel
            pResourceModel = createD3DXAniMeshModel(model_name);
            break;
        case 'X':
            //MeshModel
            pResourceModel = createMeshModel(model_name);
            break;
        case 'x':
            //MeshSetModel
            pResourceModel = createMeshSetModel(model_name);
            break;
        case 't':
            //MassMeshModel
            pResourceModel = createMassMeshModel(model_name);
            break;
        case 'G':
            //CubeMapMeshModel
            pResourceModel = createCubeMapMeshModel(model_name);
            break;
        case 'g':
            //CubeMapMeshSetModel
            pResourceModel = createCubeMapMeshSetModel(model_name);
            break;
        case 'M':
            //MorphMeshModel "M/4/xxxxx" ̏ꍇAvC}̃bV1A[t^[Qbg̃bV4ƂӖ
            pResourceModel = createMorphMeshModel(model_name);
            break;
        case 'm':
            //MassMorphMeshModel "m/4/xxxxx_2" ̏ꍇAZbgSvC}̃bV1A[t^[Qbg̃bV2ƂӖ
            pResourceModel = createMassMorphMeshModel(model_name);
            break;
        case 'H':
            //CubeMapMorphMeshModel "H/4/xxxxx" ̏ꍇAvC}̃bV1A[t^[Qbg̃bV4ƂӖ
            pResourceModel = createCubeMapMorphMeshModel(model_name);
            break;
        case 'W':
            //WorldBoundModel "W/4/xxxxx" ̏ꍇAvC}̃bV1A[t^[Qbg̃bV4ƂӖ
            pResourceModel = createWorldBoundModel(model_name);
            break;
        case 'S':
            //SpriteModel
            pResourceModel = createSpriteModel(model_name);
            break;
        case 's':
            //SpriteSetModel
            pResourceModel = createSpriteSetModel(model_name);
            break;
        case 'z':
            //MeshSpriteModel
            pResourceModel = createMassSpriteModel(model_name);
            break;
        case 'B':
            //BoardModel
            pResourceModel = createBoardModel(model_name);
            break;
        case 'b':
            //BoardSetModel
            pResourceModel = createBoardSetModel(model_name);
            break;
        case 'w':
            //MassBoardModel
            pResourceModel = createMassBoardModel(model_name);
            break;
        case 'C':
            //cubeModel
            pResourceModel = createD3DXMeshModel(const_cast<char*>("cube"), D3DXMESH_SYSTEMMEM);
            break;
        case 'P':
            //PointSpriteModel
            pResourceModel = createPointSpriteModel(model_name);
            break;
        case 'p':
            //MassPointSpriteModel
            pResourceModel = createMassPointSpriteModel(model_name);
            break;
        case 'o':
            //PointSpriteSetModel
            pResourceModel = createPointSpriteSetModel(model_name);
            break;
        case 'E':
            //PointSpriteSetModel
            pResourceModel = createFramedBoardModel(model_name);
            break;
        default:
            throwGgafCriticalException("prm_idstr="<<prm_idstr<<"  '"<<model_type<<"' EEEȃfʂ͒m܂");
            pResourceModel = nullptr;
            break;
    }
    return pResourceModel;
}

GgafDxD3DXMeshModel* GgafDxModelManager::createD3DXMeshModel(const char* prm_model_name, DWORD prm_dwOptions) {
    GgafDxD3DXMeshModel* pD3DXMeshModel_new = NEW GgafDxD3DXMeshModel(prm_model_name, prm_dwOptions);
    pD3DXMeshModel_new->restore();
    return pD3DXMeshModel_new;
}

GgafDxD3DXAniMeshModel* GgafDxModelManager::createD3DXAniMeshModel(const char* prm_model_name) {
    GgafDxD3DXAniMeshModel* pD3DXAniMeshModel_new = NEW GgafDxD3DXAniMeshModel(prm_model_name);
    pD3DXAniMeshModel_new->restore();
    return pD3DXAniMeshModel_new;
}

GgafDxSpriteModel* GgafDxModelManager::createSpriteModel(const char* prm_model_name) {
    GgafDxSpriteModel* pSpriteModel_new = NEW GgafDxSpriteModel(prm_model_name);
    pSpriteModel_new->restore();
    return pSpriteModel_new;
}

GgafDxSpriteSetModel* GgafDxModelManager::createSpriteSetModel(const char* prm_model_name) {
    GgafDxSpriteSetModel* pSpriteSetModel_new = NEW GgafDxSpriteSetModel(prm_model_name);
    pSpriteSetModel_new->restore();
    return pSpriteSetModel_new;
}

GgafDxMassSpriteModel* GgafDxModelManager::createMassSpriteModel(const char* prm_model_name) {
    GgafDxMassSpriteModel* pMassSpriteModel_new = NEW GgafDxMassSpriteModel(prm_model_name);
    pMassSpriteModel_new->restore();
    return pMassSpriteModel_new;
}

GgafDxBoardModel* GgafDxModelManager::createBoardModel(const char* prm_model_name) {
    GgafDxBoardModel* pBoardModel_new = NEW GgafDxBoardModel(prm_model_name);
    pBoardModel_new->restore();
    return pBoardModel_new;
}

GgafDxBoardSetModel* GgafDxModelManager::createBoardSetModel(const char* prm_model_name) {
    GgafDxBoardSetModel* pBoardSetModel_new = NEW GgafDxBoardSetModel(prm_model_name);
    pBoardSetModel_new->restore();
    return pBoardSetModel_new;
}

GgafDxMassBoardModel* GgafDxModelManager::createMassBoardModel(const char* prm_model_name) {
    GgafDxMassBoardModel* pMassBoardModel_new = NEW GgafDxMassBoardModel(prm_model_name);
    pMassBoardModel_new->restore();
    return pMassBoardModel_new;
}

GgafDxMeshModel* GgafDxModelManager::createMeshModel(const char* prm_model_name) {
    GgafDxMeshModel* pMeshModel_new = NEW GgafDxMeshModel(prm_model_name);
    pMeshModel_new->restore();
    return pMeshModel_new;
}

GgafDxMeshSetModel* GgafDxModelManager::createMeshSetModel(const char* prm_model_name) {
    GgafDxMeshSetModel* pMeshSetModel_new = NEW GgafDxMeshSetModel(prm_model_name);
    pMeshSetModel_new->restore();
    return pMeshSetModel_new;
}

GgafDxMassMeshModel* GgafDxModelManager::createMassMeshModel(const char* prm_model_name) {
    GgafDxMassMeshModel* pMassMeshModel_new = NEW GgafDxMassMeshModel(prm_model_name);
    pMassMeshModel_new->restore();
    return pMassMeshModel_new;
}

GgafDxCubeMapMeshModel* GgafDxModelManager::createCubeMapMeshModel(const char* prm_model_name) {
    GgafDxCubeMapMeshModel* pMeshCubeMapModel_new = NEW GgafDxCubeMapMeshModel(prm_model_name);
    pMeshCubeMapModel_new->restore();
    return pMeshCubeMapModel_new;
}

GgafDxCubeMapMeshSetModel* GgafDxModelManager::createCubeMapMeshSetModel(const char* prm_model_name) {
    GgafDxCubeMapMeshSetModel* pMeshCubeMapSetModel_new = NEW GgafDxCubeMapMeshSetModel(prm_model_name);
    pMeshCubeMapSetModel_new->restore();
    return pMeshCubeMapSetModel_new;
}

GgafDxMorphMeshModel* GgafDxModelManager::createMorphMeshModel(const char* prm_model_name) {
    // "M/4/xxxxx" ̏ꍇAvC}̃bV1A[t^[Qbg̃bV4ƂӖ
    // prm_model_name  "4/xxxxx" ƂɂȂĂB
    // [t^[QbgႤf́AʃfƂɂ邽߁AfɐlcB
    GgafDxMorphMeshModel* pMorphMeshModel_new = NEW GgafDxMorphMeshModel(prm_model_name);
    pMorphMeshModel_new->restore();
    return pMorphMeshModel_new;
}

GgafDxMassMorphMeshModel* GgafDxModelManager::createMassMorphMeshModel(const char* prm_model_name) {
    GgafDxMassMorphMeshModel* pMassMorphMeshModel_new = NEW GgafDxMassMorphMeshModel(prm_model_name);
    pMassMorphMeshModel_new->restore();
    return pMassMorphMeshModel_new;
}

GgafDxCubeMapMorphMeshModel* GgafDxModelManager::createCubeMapMorphMeshModel(const char* prm_model_name) {
    GgafDxCubeMapMorphMeshModel* pCubeMapMorphMeshModel_new = NEW GgafDxCubeMapMorphMeshModel(prm_model_name);
    pCubeMapMorphMeshModel_new->restore();
    return pCubeMapMorphMeshModel_new;
}

GgafDxWorldBoundModel* GgafDxModelManager::createWorldBoundModel(const char* prm_model_name) {
    GgafDxWorldBoundModel* pWorldBoundModel_new = NEW GgafDxWorldBoundModel(prm_model_name);
    pWorldBoundModel_new->restore();
    return pWorldBoundModel_new;
}

GgafDxPointSpriteModel* GgafDxModelManager::createPointSpriteModel(const char* prm_model_name) {
    GgafDxPointSpriteModel* pPointSpriteModel_new = NEW GgafDxPointSpriteModel(prm_model_name);
    pPointSpriteModel_new->restore();
    return pPointSpriteModel_new;
}

GgafDxMassPointSpriteModel* GgafDxModelManager::createMassPointSpriteModel(const char* prm_model_name) {
    GgafDxMassPointSpriteModel* pMassPointSpriteModel_new = NEW GgafDxMassPointSpriteModel(prm_model_name);
    pMassPointSpriteModel_new->restore();
    return pMassPointSpriteModel_new;
}

GgafDxPointSpriteSetModel* GgafDxModelManager::createPointSpriteSetModel(const char* prm_model_name) {
    GgafDxPointSpriteSetModel* pPointSpriteSetModel_new = NEW GgafDxPointSpriteSetModel(prm_model_name);
    pPointSpriteSetModel_new->restore();
    return pPointSpriteSetModel_new;
}

GgafDxFramedBoardModel* GgafDxModelManager::createFramedBoardModel(const char* prm_model_name) {
    GgafDxFramedBoardModel* pFramedBoardModel_new = NEW GgafDxFramedBoardModel(prm_model_name);
    pFramedBoardModel_new->restore();
    return pFramedBoardModel_new;
}

std::string GgafDxModelManager::getMeshFileName(std::string prm_model_name) {
    std::string xfile_name = PROPERTY::DIR_MESH_MODEL[2] + "/" + prm_model_name + ".x"; //f{".x"Xt@CɂȂ
    UTIL::strReplace(xfile_name, "//", "/");
    _TRACE_("1 xfile_name.c_str()="<<xfile_name.c_str());
    if (PathFileExists(xfile_name.c_str()) ) {
        return xfile_name; //Jgɑ݂΂D
    } else {
        xfile_name = PROPERTY::DIR_MESH_MODEL[1] + "/" + prm_model_name+ ".x";
        UTIL::strReplace(xfile_name, "//", "/");
        _TRACE_("2 xfile_name.c_str()="<<xfile_name.c_str());
        if (PathFileExists(xfile_name.c_str()) ) {
            return xfile_name; //[U[XLɑ݂΂D
        } else {
            xfile_name = PROPERTY::DIR_MESH_MODEL[0] + "/" + prm_model_name+ ".x";
            UTIL::strReplace(xfile_name, "//", "/");
            _TRACE_("3 xfile_name.c_str()="<<xfile_name.c_str());
            if (PathFileExists(xfile_name.c_str()) ) {
                return xfile_name;
            } else {
                return "";
            }
        }
    }
}
std::string GgafDxModelManager::getSpriteFileName(std::string prm_model_name) {
    std::string xfile_name = PROPERTY::DIR_SPRITE_MODEL[2] + "/" + prm_model_name + ".sprx";
    UTIL::strReplace(xfile_name, "//", "/");
    if (PathFileExists(xfile_name.c_str()) ) {
        return xfile_name;
    } else {
        xfile_name = PROPERTY::DIR_SPRITE_MODEL[1] + "/" +  prm_model_name + ".sprx";
        UTIL::strReplace(xfile_name, "//", "/");
        if (PathFileExists(xfile_name.c_str()) ) {
            return xfile_name; //[U[XLɑ݂΂D
        } else {
            xfile_name = PROPERTY::DIR_SPRITE_MODEL[0] + "/" +  prm_model_name + ".sprx";
            UTIL::strReplace(xfile_name, "//", "/");
            if (PathFileExists(xfile_name.c_str()) ) {
                return xfile_name;
            } else {
                throwGgafCriticalException("XvCgt@C(*.sprx)܂Bxfile_name="<<xfile_name);
            }
        }
    }
}

std::string GgafDxModelManager::getPointSpriteFileName(std::string prm_model_name) {
    std::string xfile_name = PROPERTY::DIR_SPRITE_MODEL[2] + "/" + prm_model_name + ".psprx";
    UTIL::strReplace(xfile_name, "//", "/");
    if (PathFileExists(xfile_name.c_str()) ) {
        return xfile_name;
    } else {
        xfile_name = PROPERTY::DIR_SPRITE_MODEL[1] + "/" +  prm_model_name + ".psprx";
        UTIL::strReplace(xfile_name, "//", "/");
        if (PathFileExists(xfile_name.c_str()) ) {
            return xfile_name;  //[U[XLɑ݂΂D
        } else {
            xfile_name = PROPERTY::DIR_SPRITE_MODEL[0] + "/" +  prm_model_name + ".psprx";
            UTIL::strReplace(xfile_name, "//", "/");
            if (PathFileExists(xfile_name.c_str()) ) {
                return xfile_name;
            } else {
                throwGgafCriticalException("|CgXvCgt@C(*.psprx)܂Bxfile_name="<<xfile_name);
            }
        }
    }
}

void GgafDxModelManager::obtainSpriteInfo(SpriteXFileFmt* pSpriteFmt_out, std::string prm_sprite_x_filename) {
    //XvCgǍ
    // xof 0303txt 0032
    // template SpriteDef {
    //    <E4EECE4C-E106-11DC-9B62-346D55D89593>
    //    FLOAT  Width;
    //    FLOAT  Height;
    //    STRING TextureFile;
    //    DWORD  TextureSplitRows;
    //    DWORD  TextureSplitCols;
    // }
    ID3DXFileEnumObject* pID3DXFileEnumObject;
    HRESULT hr = GgafDxModelManager::_pID3DXFile_sprx->CreateEnumObject(
                                                         (void*)prm_sprite_x_filename.c_str(),
                                                         D3DXF_FILELOAD_FROMFILE,
                                                         &pID3DXFileEnumObject);
    checkDxException(hr, S_OK, "'"<<prm_sprite_x_filename<<"' CreateEnumObjectɎs܂Bsprxt@C̃tH[}bgmFĉB");
    //TODO:GUIDȂƂB͊SB
    //const GUID PersonID_GUID ={ 0xB2B63407,0x6AA9,0x4618, 0x95, 0x63, 0x63, 0x1E, 0xDC, 0x20, 0x4C, 0xDE};
    ID3DXFileData* pID3DXFileData = nullptr;
    SIZE_T nChildren;
    pID3DXFileEnumObject->GetChildren(&nChildren);
    for(SIZE_T childCount = 0; childCount < nChildren; childCount++) {
        pID3DXFileEnumObject->GetChild(childCount, &pID3DXFileData);
    } //[vĂ邪Achild ͈łB
    SIZE_T xsize = 0;
    char* pXData = nullptr;
    pID3DXFileData->Lock(&xsize, (const void**)&pXData);
    if (pXData == nullptr) {
        throwGgafCriticalException(prm_sprite_x_filename<<" ̃tH[}bgG[B");
    }
    //    GUID* pGuid;
    //    pID3DXFileData->GetType(pGuid);
    memcpy(&(pSpriteFmt_out->width), pXData, sizeof(float));           pXData += sizeof(float);
    memcpy(&(pSpriteFmt_out->height), pXData, sizeof(float));          pXData += sizeof(float);
    strcpy(pSpriteFmt_out->texture_file, pXData);                      pXData += (sizeof(char) * (strlen(pSpriteFmt_out->texture_file)+1));
    memcpy(&(pSpriteFmt_out->row_texture_split), pXData, sizeof(int)); pXData += sizeof(int);
    memcpy(&(pSpriteFmt_out->col_texture_split), pXData, sizeof(int)); pXData += sizeof(int);
    pID3DXFileData->Unlock();
    GGAF_RELEASE_BY_FROCE(pID3DXFileData);
    GGAF_RELEASE(pID3DXFileEnumObject);
}
void GgafDxModelManager::obtainPointSpriteInfo(PointSpriteXFileFmt* pPointSpriteFmt_out, std::string prm_point_sprite_x_filename) {
    //XvCgǍ݃ev[g̓o^(ŝ)
    ID3DXFileEnumObject* pID3DXFileEnumObject;
    ID3DXFileData* pID3DXFileData = nullptr;
    HRESULT hr = GgafDxModelManager::_pID3DXFile_psprx->CreateEnumObject((void*)prm_point_sprite_x_filename.c_str(), D3DXF_FILELOAD_FROMFILE, &pID3DXFileEnumObject);
    checkDxException(hr, S_OK, "'"<<prm_point_sprite_x_filename<<"' CreateEnumObjectɎs܂Bpsprx t@C̃tH[}bgmFĉB");

    //TODO:GUIDȂƂB͊SB
    //const GUID PersonID_GUID ={ 0xB2B63407,0x6AA9,0x4618, 0x95, 0x63, 0x63, 0x1E, 0xDC, 0x20, 0x4C, 0xDE};
    SIZE_T nChildren;
    pID3DXFileEnumObject->GetChildren(&nChildren);
    for(SIZE_T childCount = 0; childCount < nChildren; childCount++) {
        pID3DXFileEnumObject->GetChild(childCount, &pID3DXFileData);
    }

//    "template PointSpriteDef { "
//    "  <E4EECE4C-E106-11DC-9B62-346D55D89593> "
//    "  FLOAT  SquareSize; "
//    "  STRING TextureFile; "
//    "  DWORD  TextureSplitRowCol; "
//    "  DWORD  VerticesNum; "
//    "  array  Vector    Vertices[VerticesNum]; "
//    "  array  ColorRGBA VertexColors[VerticesNum]; "
//    "  array  DWORD     InitUvPtnNo[VerticesNum]; "
//    "  array  FLOAT     InitScale[VerticesNum]; "
//    "} "

//    class PointSpriteXFileFmt {
//    public:
//        float SquareSize;
//        char TextureFile[256];
//        int TextureSplitRowCol;
//        int VerticesNum;
//        D3DVECTOR* paD3DVECTOR_Vertices;
//        D3DCOLORVALUE* paD3DVECTOR_VertexColors;
//        int* paInt_InitUvPtnNo;
//        float* paFLOAT_InitScale;
//    };

    SIZE_T xsize = 0;
    char* pXData = nullptr;
    pID3DXFileData->Lock(&xsize, (const void**)&pXData);
    if (pXData == nullptr) {
        throwGgafCriticalException(prm_point_sprite_x_filename<<" ̃tH[}bgG[B");
    }
    //    GUID* pGuid;
    //    pID3DXFileData->GetType(pGuid);
    //    XFILE_FMT_HD xDataHd;
    //"  FLOAT  SquareSize;\n"
    memcpy(&(pPointSpriteFmt_out->SquareSize), pXData, sizeof(float));
    pXData += sizeof(float);
    //"  STRING TextureFile;\n"
    strcpy(pPointSpriteFmt_out->TextureFile, pXData);
    pXData += (sizeof(char) * (strlen(pPointSpriteFmt_out->TextureFile)+1));
    //"  DWORD  TextureSplitRowCol;\n"
    memcpy(&(pPointSpriteFmt_out->TextureSplitRowCol), pXData, sizeof(int));
    pXData += sizeof(int);
    //"  DWORD  VerticesNum;\n"
    memcpy(&(pPointSpriteFmt_out->VerticesNum), pXData, sizeof(int));
    pXData += sizeof(int);

    int vaetexs_num = pPointSpriteFmt_out->VerticesNum;

    //"  array  Vector    Vertices[VerticesNum];\n"
    pPointSpriteFmt_out->paD3DVECTOR_Vertices = NEW D3DVECTOR[vaetexs_num];
    memcpy(pPointSpriteFmt_out->paD3DVECTOR_Vertices, pXData, sizeof(D3DVECTOR)*vaetexs_num);
    pXData += sizeof(D3DVECTOR)*pPointSpriteFmt_out->VerticesNum;
    //"  array  ColorRGBA VertexColors[VerticesNum];\n"
    pPointSpriteFmt_out->paD3DVECTOR_VertexColors = NEW D3DCOLORVALUE[vaetexs_num];
    memcpy(pPointSpriteFmt_out->paD3DVECTOR_VertexColors, pXData, sizeof(D3DCOLORVALUE)*vaetexs_num);
    pXData += sizeof(D3DCOLORVALUE)*vaetexs_num;
    //"  array  DWORD     InitUvPtnNo[VerticesNum];\n"
    pPointSpriteFmt_out->paInt_InitUvPtnNo = NEW int[vaetexs_num];
    memcpy(pPointSpriteFmt_out->paInt_InitUvPtnNo, pXData, sizeof(int)*vaetexs_num);
    pXData += sizeof(int)*vaetexs_num;
    //"  array  FLOAT     InitScale[VerticesNum];\n"
    pPointSpriteFmt_out->paFLOAT_InitScale = NEW float[vaetexs_num];
    memcpy(pPointSpriteFmt_out->paFLOAT_InitScale, pXData, sizeof(float)*vaetexs_num);
    pXData += sizeof(float)*vaetexs_num;

    pID3DXFileData->Unlock();
    GGAF_RELEASE_BY_FROCE(pID3DXFileData);
    GGAF_RELEASE(pID3DXFileEnumObject);
}

GgafResourceConnection<GgafDxModel>* GgafDxModelManager::processCreateConnection(const char* prm_idstr, GgafDxModel* prm_pResource) {
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐JnB");
    GgafDxModelConnection* p = NEW GgafDxModelConnection(prm_idstr, prm_pResource);
    _TRACE3_("prm_idstr="<<prm_idstr<<" 𐶐IB");
    return p;
}

GgafDxModelManager::~GgafDxModelManager() {
    _TRACE3_("start-->");
    GGAF_RELEASE(GgafDxModelManager::_pID3DXFile_sprx);
    GGAF_RELEASE(GgafDxModelManager::_pID3DXFile_psprx);
    GGAF_DELETE(GgafDxModelManager::_pModelTextureManager);
    _TRACE3_("邯ǂAł͊ɉ̂Ȃ͂ł");
    releaseAll();
}

void GgafDxModelManager::restoreAll() {
    _TRACE3_("start-->");
    GgafResourceConnection<GgafDxModel>* pCurrent = _pConn_first;
    _TRACE3_("restoreAll pCurrent="<<pCurrent);
    while (pCurrent) {
        pCurrent->peek()->restore();
        pCurrent = pCurrent->getNext();
    }
    _TRACE3_("end<--");
}

void GgafDxModelManager::onDeviceLostAll() {
    _TRACE3_("start-->");
    GgafResourceConnection<GgafDxModel>* pCurrent = _pConn_first;
    _TRACE3_("onDeviceLostAll pCurrent="<<pCurrent);
    while (pCurrent) {
        _TRACE_(FUNC_NAME<<" ["<<pCurrent->peek()->_model_name<<"] onDeviceLost begin");
        pCurrent->peek()->onDeviceLost();
        _TRACE_(FUNC_NAME<<" ["<<pCurrent->peek()->_model_name<<"] onDeviceLost end");
        pCurrent = pCurrent->getNext();
    }
    _TRACE3_("end<--");
}

void GgafDxModelManager::releaseAll() {
    _TRACE3_("start-->");
    GgafResourceConnection<GgafDxModel>* pCurrent = _pConn_first;
    while (pCurrent) {
        pCurrent->peek()->release();
        pCurrent = pCurrent->getNext();
    }
    _TRACE3_("end<--");
}



//uo܃iO`j 2009/07/05v
//VF[_[ɋ킫A׋dn߂ĂAD3DXLoadMeshFromX œǂݍނƏɒ_obt@鎞鎖ɋCĔYłB
//D3DXLoadMeshFromX Xt@CǂݍނƎvʂ̒_i_CfbNXjɂȂۏ؂B
//ႦΎOp`|SłBOX̏ꍇA_8A_CfbNX12(*3)iʂ12jA@xNg6A@CfbNX12(*3)AƂȂ邪A
//̂悤Xt@CeLXgGfB^ō D3DXLoadMeshFromX œǂݍނƒ_24ɂȂĂ܂iƎvjB
//́AXt@Cł͖@ʂɕRĎӖ̃f[^쐬łɂ炸ADIRECTXł͖@e_Ɏ邽߁A
//_8ł͖{͖ʒPʂłnY̖@\łȂȂĂ܂߂Ɨ\złB
//́u\zvudlvɒuȂƂ낾B
//e(se)ɂ D3DXLoadMeshFromX  ID3DXMesh \zAʂƖʂ̉Ae𐳂邽߁A܂GbWNbL邽
//@_D悳āA_̗אڂʂ̐i@jA_𑝂₷AƂɍŝł낤B
//AVF[_[ł̃[tAIuWFNgDrawIndexedPrimitiveł킯ĕ\鎞A
//ɒ_̐ςĂ܂Ă͍ƂƂ悤ɂȂB
//uŌ߂_Œ_obt@肽BvƂA{IȂƂoȂߎs낵B
//_́A@_Xt@C쐬΂̂ł邪AȎCɂăfOĂȂB
//D3DXLoadMeshFromX ̃bVœKȂǂ̋L͂BAm肽͓̂ASYuSāvłB
//D3DXLoadMeshFromX ̃\[XR[hΉ̂ARJȂĂĖB
//Ȃ킯ŁAŉĂ邩ɂ͂킩ȂBȂ D3DXLoadMeshFromX ͎gȂ̂HBƂ_ɍsB
//܂VF[_[ʓIɎgɂ͓ƎXt@CǂݍނȂ̂ȁA߂ǂȂAłȂ̂B@́H
//v́Au_vu@vu}eAvuUVvuKvȑ̏vǂ߂΂낤AȂ΂ȂłȂB
//Xt@CȂāA߂ǂtH[}bgȂĂEEEƂXt@CĂނ뉽HIAƂ񂾂ĂB
// D3DXLoadMeshFromX ugȂvƌ_t܂ł̊ԂAŁAXt@C}X^[ɂȂĂB
//ŁAȂ̂Xt@C烂fǂޏƎɍ낤ƌ߂̂B
//Ƃ肠A^ZRCAA3DSMAX̃GNX|[gXt@ĆuÓIvfǂݍ߂ΗǂȁAV[eBÕLBƂlō쐬JnB
//Ă΂炭 Paul ̃TvR[h𔭌Bhttp://www.gamedev.net/reference/programming/features/xfilepc/
//uLoading and displaying .X files without DirectXvƁIBȂăhsVȃgsbNȂ񂾁BƂ킯ō̗pB
//̃Tv́A\lȓ_đςBłO̓}VŁA׋ɂȂ̂ŗǂƂ悤BiGCCVC̋Ƃj
//lΒ_Oœǂ݁AǗ鎖́AKʂ铹낤BAꎊ܂ł̎Ԃ߂B
//̑gݍ퐔ƂvgCAhG[ŁAQ[肽ƂMłӂꂻB܂ĂIJVNiCB
//̂̎āA̓jvO}̐lB͂ǂĂ̂낤HA݂ȔYłȂ̂ȂB
//iEEÉA܂ق̏͂ɉ߂ȂIi΁jj
