#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

#include "jp/ggaf/dxcore/GgafDxGod.h"
#include "jp/ggaf/core/util/GgafStatus.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/scene/GgafDxSpacetime.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxGeometricActor::GgafDxGeometricActor(const char* prm_name,
                                           GgafStatus* prm_pStat,
                                           GgafDxChecker* prm_pChecker) : GgafDxBaseActor(prm_name, prm_pStat),
_pKuroko(new GgafDxKuroko(this)),
_pSeTransmitter(new GgafDxSeTransmitterForActor(this)),
_is_2D(false),
_offscreen_kind(-1),
_x(0), _y(0), _z(0),
_rx(0), _ry(0), _rz(0),
_sx(R_SC(1.0)), _sy(R_SC(1.0)), _sz(R_SC(1.0)),
_pChecker(prm_pChecker),
_rate_of_bounding_sphere_radius(1.0f),
_fX(C_DX(_x)), _fY(C_DX(_y)), _fZ(C_DX(_z)),
_dest_from_vppln_top(0.0f),
_dest_from_vppln_bottom(0.0f),
_dest_from_vppln_left(0.0f),
_dest_from_vppln_right(0.0f),
_dest_from_vppln_infront(0.0f),
_dest_from_vppln_back(0.0f),
_pFunc_calc_rot_mv_world_matrix(nullptr),
_matWorld(),
_matWorldRotMv(),
_matInvWorldRotMv(),
_was_calculated_matInvWorldRotMv(false),
_pActor_base(nullptr),
_x_local(_x), _y_local(_y), _z_local(_z),
_rx_local(_rx), _ry_local(_ry), _rz_local(_rz),
_x_final(_x), _y_final(_y), _z_final(_z),
_rx_final(_rx), _ry_final(_ry), _rz_final(_rz),
_is_local(false)
{
    _obj_class |= Obj_GgafDxGeometricActor;
    _class_name = "GgafDxGeometricActor";
    _pFormation = nullptr;
}

void GgafDxGeometricActor::processSettlementBehavior() {
    if (_is_2D) {
        // 
    } else {

        _was_calculated_matInvWorldRotMv = false; //ts񖢌vZɃZbg

        if (_pActor_base) {
            //y䂠莞[JWɈU߂
            changeGeoLocal();
        }

        //DirectX̒PʂɍWϊĂiWorldϊs쐬ɂgp܂j
        _fX = C_DX(_x);
        _fY = C_DX(_y);
        _fZ = C_DX(_z);
        //Worldϊsi_matWorldjXV
        if (_pFunc_calc_rot_mv_world_matrix) {
            //]~ړ̂݌vZ _matWorldRotMv ɕێ
            (*_pFunc_calc_rot_mv_world_matrix)(this, _matWorldRotMv);
            _matWorld = _matWorldRotMv;
            //]~ړ ̑O XP[lāA
            //ŏII _matWorld  s(g~]~ړ)ێ
            if (_sx != LEN_UNIT) {
                const float sx = SC_R(_sx);
                _matWorld._11 *= sx;
                _matWorld._12 *= sx;
                _matWorld._13 *= sx;
            }
            if (_sy != LEN_UNIT) {
                const float sy = SC_R(_sy);
                _matWorld._21 *= sy;
                _matWorld._22 *= sy;
                _matWorld._23 *= sy;
            }
            if (_sz != LEN_UNIT) {
                const float sz = SC_R(_sz);
                _matWorld._31 *= sz;
                _matWorld._32 *= sz;
                _matWorld._33 *= sz;
            }
        }

        //ftHgł́A_matWorldRotMv = ]ϊs ~ sړϊs
        //                _matWorld      = gkϊs ~ _matWorldRotMv ƂȂ悤ɂĂB
        //܂ _matWorld = gk]sړ
        //_matWorldRotMv  addSubGroupAsFk() sɎgp邽߂ɍ쐬ĂB
        //] addSubGroupAsFk() ΎgpȂȂ΁A_matWorldRotMv̌vZ͕svB
        //processSettlementBehavior() I[o[ChA
        //ϊs쐬ƒP邱ƂŁAœK\B

        if (_pActor_base) {
            //΍Wɕϊ
            D3DXMatrixMultiply(&_matWorld     , &_matWorld     , &(_pActor_base->_matWorldRotMv)); //
            D3DXMatrixMultiply(&_matWorldRotMv, &_matWorldRotMv, &(_pActor_base->_matWorldRotMv)); //
            changeGeoFinal();
            //[hϊs~y䃏[hϊśu]~ړv݂̂̐ρj畽sړoŏIIȍWƂ
            _fX = _matWorld._41;
            _fY = _matWorld._42;
            _fZ = _matWorld._43;
            _x = DX_C(_fX);
            _y = DX_C(_fY);
            _z = DX_C(_fZ);

            //[Jłfaceς݂̃[hϊśu]~ړv݂̂̐(_matWorldRotMv)̂ŁA
            //xNg(1,0,0)ɍςݕϊs|΍ŏIIface𓾂
            UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _rz, _ry);
            _rx = _rx_local; //̂܂
            //Ă̂B
            //xNg̓[hϊs̐ρi_matWorldRotMv)ŕϊA݂̍ŏIIȌɌB
            //匳̕xNg(x_org_,y_org_,z_org_)A
            //[hϊs̉]̐ρi_matWorldRotMv)̐ mat_xxA
            //ŏIIȕxNg(vX, vY, vZ) Ƃ
            //
            //                         | mat_11 mat_12 mat_13 |
            //| x_org_ y_org_ z_org_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
            //                         | mat_31 mat_32 mat_33 |
            //ƂȂB
            //
            //vX = x_org_*mat_11 + y_org_*mat_21 + z_org_*mat_31
            //vY = x_org_*mat_12 + y_org_*mat_22 + z_org_*mat_32
            //vZ = x_org_*mat_13 + y_org_*mat_23 + z_org_*mat_33
            //
            //ĂŁA匳O̒PʕxNg(1,0,0)̏ꍇ͂ǂȂ邩Hl
            //
            //vX = x_org_*mat_11
            //vY = x_org_*mat_12
            //vZ = x_org_*mat_13
            //
            //ƂȂB{Avł́Af͑S(1,0,0)OƂĂ邽
            //ŏIIȕxNǵix_org_*mat_11, x_org_*mat_12, x_org_*mat_13) ƂȂB
            //̕xNg _rz _ry \ΗǂB
            //vZ₷悤x_org_1ƒu
            //
            //UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _rz, _ry);
            //ƂȂ
            processChangeGeoFinal(); //΍WvZ̏pR[obN
        }

        //ʂ̋XV
        const dxcoord fX = _fX;
        const dxcoord fY = _fY;
        const dxcoord fZ = _fZ;
        GgafDxCamera* pCam = P_GOD->getSpacetime()->getCamera();
        D3DXPLANE& plnTop = pCam->_plnTop;
        _dest_from_vppln_top     = plnTop.a * fX +
                                   plnTop.b * fY +
                                   plnTop.c * fZ +
                                   plnTop.d;
        D3DXPLANE& plnBottom = pCam->_plnBottom;
        _dest_from_vppln_bottom  = plnBottom.a * fX +
                                   plnBottom.b * fY +
                                   plnBottom.c * fZ +
                                   plnBottom.d;
        D3DXPLANE& plnLeft = pCam->_plnLeft;
        _dest_from_vppln_left    = plnLeft.a * fX +
                                   plnLeft.b * fY +
                                   plnLeft.c * fZ +
                                   plnLeft.d;
        D3DXPLANE& plnRight = pCam->_plnRight;
        _dest_from_vppln_right   = plnRight.a * fX +
                                   plnRight.b * fY +
                                   plnRight.c * fZ +
                                   plnRight.d;
        D3DXPLANE& plnInfront = pCam->_plnInfront;
        _dest_from_vppln_infront = plnInfront.a * fX +
                                   plnInfront.b * fY +
                                   plnInfront.c * fZ +
                                   plnInfront.d;
       D3DXPLANE& plnBack = pCam->_plnBack;
        _dest_from_vppln_back    = plnBack.a * fX +
                                   plnBack.b * fY +
                                   plnBack.c * fZ +
                                   plnBack.d;
        _offscreen_kind = -1;
    }


    if (_pChecker) {
        if (_can_hit_flg) {
            if (_can_hit_out_of_view == false && isOutOfView()) {
                //O蔻薳̏ꍇ͓o^Ȃ
            } else  {
                //ؓo^
                _pChecker->updateHitArea();
            }
        }
    }
}

void GgafDxGeometricActor::changeGeoLocal() {
#ifdef MY_DEBUG
        if (!_pActor_base) {
            throwGgafCriticalException("changeGeoLocal() : yAN^[܂BmFĉBthis="<<NODE_INFO<<"");
        }
        if (_is_local) {
            throwGgafCriticalException("changeGeoLocal() : Ƀ[JWnłBΉmFĉBthis="<<NODE_INFO<<"");
        }
#endif
        _x_final  = _x;
        _y_final  = _y;
        _z_final  = _z;
        _rx_final = _rx;
        _ry_final = _ry;
        _rz_final = _rz;
        _x  = _x_local;
        _y  = _y_local;
        _z  = _z_local;
        _rx = _rx_local;
        _ry = _ry_local;
        _rz = _rz_local;
        _is_local = true;
    }

void GgafDxGeometricActor::changeGeoFinal() {
#ifdef MY_DEBUG
    if (!_pActor_base) {
        throwGgafCriticalException("changeGeoFinal() : yAN^[܂BmFĉBthis="<<NODE_INFO<<"");
    }
    if (!_is_local) {
        throwGgafCriticalException("changeGeoFinal() : Ƀ[JWnłBΉmFĉBthis="<<NODE_INFO<<"");
    }
#endif
    _x_local = _x;
    _y_local = _y;
    _z_local = _z;
    _rx_local = _rx;
    _ry_local = _ry;
    _rz_local = _rz;
    _x  = _x_final;
    _y  = _y_final;
    _z  = _z_final;
    _rx = _rx_final;
    _ry = _ry_final;
    _rz = _rz_final;
    _is_local = false;
}

//void GgafDxGeometricActor::updateGeoFinalFromLocal() {
//
//}
GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(actorkind prm_kind,
                                                     GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_x_init_local,
                                                     coord prm_y_init_local,
                                                     coord prm_z_init_local,
                                                     coord prm_rx_init_local,
                                                     coord prm_ry_init_local,
                                                     coord prm_rz_init_local) {
#ifdef MY_DEBUG
    if (_pFunc_calc_rot_mv_world_matrix) {
        //OK
    } else {
        throwGgafCriticalException(": "<<
                                   "this="<<NODE_INFO<<" ́A_pFunc_calc_rot_mv_world_matrix  nullptrׁ̈AFKx[XƂȂ鎑i܂");
    }
#endif
    GgafGroupHead* pGroupHead = addSubGroup(prm_kind, prm_pGeoActor);
    prm_pGeoActor->_pActor_base = this;
    prm_pGeoActor->changeGeoLocal();
    prm_pGeoActor->_x = prm_x_init_local;
    prm_pGeoActor->_y = prm_y_init_local;
    prm_pGeoActor->_z = prm_z_init_local;
    prm_pGeoActor->_rx = prm_rx_init_local;
    prm_pGeoActor->_ry = prm_ry_init_local;
    prm_pGeoActor->_rz = prm_rz_init_local;
//    prm_pGeoActor->getKuroko()->_rz_mv = prm_rz_init_local;
//    prm_pGeoActor->getKuroko()->_ry_mv = prm_ry_init_local;

    prm_pGeoActor->changeGeoFinal();
    return pGroupHead;
}

GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_x_init_local,
                                                     coord prm_y_init_local,
                                                     coord prm_z_init_local,
                                                     coord prm_rx_init_local,
                                                     coord prm_ry_init_local,
                                                     coord prm_rz_init_local) {
    return addSubGroupAsFk(prm_pGeoActor->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND),
                           prm_pGeoActor,
                           prm_x_init_local,
                           prm_y_init_local,
                           prm_z_init_local,
                           prm_rx_init_local,
                           prm_ry_init_local,
                           prm_rz_init_local);
}

bool GgafDxGeometricActor::processHitChkLogic(GgafActor* prm_pOtherActor) {
    if (_can_hit_flg && prm_pOtherActor->_can_hit_flg) {
        //&& prm_pOtherActor->instanceOf(Obj_GgafDxGeometricActor)) { 蔻肪̂GgafDxGeometricActorȏƔf
        //_can_hit_flg && prm_pOtherActor->_can_hit_flg ̃`FbN͔ؓo^Oɂ`FbNĂ邪
        //łx`FbNقǂB
        //ȂȂ΁Aʂȃqbg`FbNsȂ߁AonHit(GgafActor*)  setHitAble(false) sA
        //Qdqbg`FbNh~sĂ邩ȂB
        if (_pChecker) {
            return _pChecker->isHit(((GgafDxGeometricActor*)prm_pOtherActor)->_pChecker);
        }
    }
    return false;
}

int GgafDxGeometricActor::isOutOfView() {
    //Eaif̂ĵŁAPX_DX(1) ʓɂ邩ǂ𔻒肷B
    //fʓɂ邩ǂ́AGgafDxFigureActor ŃI[o[ChĂōsB
    if (_offscreen_kind == -1) {
        const dxcoord bound = PX_DX(1); //Ea
        if (_dest_from_vppln_top < bound) {
            if (_dest_from_vppln_bottom < bound) {
                if (_dest_from_vppln_left < bound) {
                    if (_dest_from_vppln_right < bound) {
                        if (_dest_from_vppln_infront < bound) {
                            if (_dest_from_vppln_back < bound) {
                                //Viewport͈͓
                                _offscreen_kind = 0;
                            } else {
                                //ʂ艜Ŕ͈͊O
                                _offscreen_kind = 6;
                            }
                        } else {
                            //OʂOŔ͈͊O
                            _offscreen_kind = 5;
                        }
                    } else {
                        //EʂEŔ͈͊O
                        _offscreen_kind = 4;
                    }
                } else {
                    //ʂ荶Ŕ͈͊O
                    _offscreen_kind = 3;
                }
            } else {
                //ʂ艺Ŕ͈͊O
                _offscreen_kind = 2;
            }
        } else {
            //㕽ʂŔ͈͊O
            _offscreen_kind = 1;
        }
    }
    return _offscreen_kind;
}

bool GgafDxGeometricActor::isOutOfSpacetime() const {
    GgafDxSpacetime* pSpacetime =  P_GOD->getSpacetime();
    if (pSpacetime->_x_bound_left <= _x) {
        if (_x <= pSpacetime->_x_bound_right) {
            if (pSpacetime->_y_bound_bottom <= _y) {
                if (_y <= pSpacetime->_y_bound_top) {
                    if (pSpacetime->_z_bound_near <= _z) {
                        if (_z <= pSpacetime->_z_bound_far) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}

void GgafDxGeometricActor::defineRotMvWorldMatrix(void (*prm_pFunc)(const GgafDxGeometricActor*, D3DXMATRIX&)) {
    _pFunc_calc_rot_mv_world_matrix = prm_pFunc;
    (*_pFunc_calc_rot_mv_world_matrix)(this, _matWorldRotMv);
}

void GgafDxGeometricActor::defineRotMvWorldMatrix_Billboard() {
    defineRotMvWorldMatrix(GgafDxUtil::setWorldMatrix_RzBxyzMv);
}

void GgafDxGeometricActor::setPositionAt(const GgafDxGeoElem* prm_pGeoElem) {
    _x = prm_pGeoElem->x;
    _y = prm_pGeoElem->y;
    _z = prm_pGeoElem->z;
}
void GgafDxGeometricActor::setPositionAroundAt(const GgafDxGeoElem* prm_pGeoElem, coord margin) {
    _x = RND_ABOUT(prm_pGeoElem->x, margin);
    _y = RND_ABOUT(prm_pGeoElem->y, margin);
    _z = RND_ABOUT(prm_pGeoElem->z, margin);
}
void GgafDxGeometricActor::setFaceAngAs(const GgafDxGeometricActor* prm_pActor) {
    setRxFaceAng(prm_pActor->_rx);
    setRyFaceAng(prm_pActor->_ry);
    setRzFaceAng(prm_pActor->_rz);
}
void GgafDxGeometricActor::setFaceAngAs(const GgafDxGeoElem* prm_pGeoElem) {
    setRxFaceAng(prm_pGeoElem->rx);
    setRyFaceAng(prm_pGeoElem->ry);
    setRzFaceAng(prm_pGeoElem->rz);
}

//void GgafDxGeometricActor::setFaceAng(axis prm_axis, angle prm_face) {
//    _face[prm_axis] = UTIL::simplifyAng(prm_face);
//}

void GgafDxGeometricActor::setRzFaceAng(angle prm_face) {
    _rz = UTIL::simplifyAng(prm_face);
}
void GgafDxGeometricActor::setRyFaceAng(angle prm_face) {
    _ry = UTIL::simplifyAng(prm_face);
}
void GgafDxGeometricActor::setRxFaceAng(angle prm_face) {
    _rx = UTIL::simplifyAng(prm_face);
}

void GgafDxGeometricActor::setRzRyFaceAng(angle prm_rz_face, angle prm_ry_face) {
    setRzFaceAng(prm_rz_face);
    setRyFaceAng(prm_ry_face);
}

void GgafDxGeometricActor::setFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    coord vx = prm_tx - _x;
    coord vy = prm_ty - _y;
    coord vz = prm_tz - _z;
    if (vx == 0 && vy == 0 && vz == 0) {
        //g̍Wɓ̂ŁAȂ
    } else {
        UTIL::convVectorToRzRy(vx, vy, vz,
                               _rz, _ry );
    }
}

void GgafDxGeometricActor::scaleAs(const GgafDxGeometricActor* prm_pActor) {
    _sx = prm_pActor->_sx;
    _sy = prm_pActor->_sy;
    _sz = prm_pActor->_sz;
}

void GgafDxGeometricActor::onEnd() {
    GgafDxBaseActor::onEnd();
    _pFormation = nullptr;
}

GgafDxGeometricActor::~GgafDxGeometricActor() {
    delete _pKuroko;
    delete _pSeTransmitter;
}

void GgafDxGeometricActor::dump() {
    _TRACE_("\t\t\t\t\t\t\t\t"<<NODE_INFO<<"("<<_x<<","<<_y<<","<<_z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    while (pActor_tmp) {
        pActor_tmp->dump("\t\t\t\t\t\t\t\tb");
        if (pActor_tmp->getNext()) {
            pActor_tmp = pActor_tmp->getNext();
        } else {
            _TRACE_("yxz"<<NODE_INFO<<" nextnullptrĂ܂");
            break;
        }
        if (pActor_tmp->isFirst()) {
            _TRACE_("\t\t\t\t\t\t\t\t");
            break;
        }
    }
}

void GgafDxGeometricActor::dump(std::string prm_parent) {
    _TRACE_(prm_parent <<NODE_INFO<<"("<<_x<<","<<_y<<","<<_z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    while (pActor_tmp) {
        pActor_tmp->dump(prm_parent + "b");
        if (pActor_tmp->getNext()) {
            pActor_tmp = pActor_tmp->getNext();
        } else {
            _TRACE_("yxz"<<NODE_INFO<<" nextnullptrĂ܂");
            break;
        }
        if (pActor_tmp->isFirst()) {
            _TRACE_(prm_parent+"");
            break;
        }
    }
}

