#include "jp/ggaf/dxcore/GgafDxGod.h"

#include <algorithm>
#include "jp/ggaf/core/GgafFactory.h"
#include "jp/ggaf/dxcore/actor/camera/GgafDxCamera.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/manager/GgafDxEffectManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureManager.h"
#include "jp/ggaf/dxcore/scene/GgafDxSpacetime.h"
#include "jp/ggaf/dxcore/sound/GgafDxSound.h"
#include "jp/ggaf/dxcore/util/GgafDxInput.h"
#include "jp/ggaf/dxcore/util/GgafDx26DirectionUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;

#define returnWhenFailed(HR, OKVAL, X) { \
    if (HR != OKVAL) { \
        std::stringstream ss; \
        ss << X; \
        MessageBox(GgafDxGod::_pHWndPrimary, TEXT(ss.str().c_str()), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND | MB_TOPMOST); \
        return E_FAIL; \
    } \
}

//TODO:RgƂBB


#define PRIMARY_VIEW 0
#define SECONDARY_VIEW 1


HWND GgafDxGod::_pHWndPrimary = nullptr;
HWND GgafDxGod::_pHWndSecondary = nullptr;
HINSTANCE GgafDxGod::_hInstance = nullptr;
IDirect3D9* GgafDxGod::_pID3D9 = nullptr;
IDirect3DDevice9* GgafDxGod::_pID3DDevice9 = nullptr;
D3DLIGHT9 GgafDxGod::_d3dlight9_default;
DWORD GgafDxGod::_ambient_brightness_default = 0xff404040;


D3DFILLMODE GgafDxGod::_d3dfillmode = D3DFILL_SOLID;//D3DFILL_WIREFRAME;//D3DFILL_SOLID;

GgafDxModelManager* GgafDxGod::_pModelManager = nullptr;
GgafDxEffectManager* GgafDxGod::_pEffectManager = nullptr;
GgafDxTextureManager* GgafDxGod::_pCubeMapTextureManager = nullptr;
GgafDxTextureManager* GgafDxGod::_pBumpMapTextureManager = nullptr;
bool GgafDxGod::_is_device_lost_flg = false;
bool GgafDxGod::_adjustGameWindow = false;
HWND GgafDxGod::_pHWnd_adjustScreen = nullptr;

uint32_t GgafDxGod::_vs_v = 0;
uint32_t GgafDxGod::_ps_v = 0;

GgafDxGod::GgafDxGod() : GgafGod() {
    _is_device_lost_flg = false;
    _adjustGameWindow = false;
    _pHWnd_adjustScreen = nullptr;

    GgafDxGod::_hInstance = GetModuleHandle(0);


    CmRandomNumberGenerator::getInstance()->changeSeed(19740722UL); //19740722 Seed
    GgafRgb rgb_border = GgafRgb(PROPERTY::BORDER_COLOR);
    _color_border = D3DCOLOR_RGBA(rgb_border._red, rgb_border._green, rgb_border._blue, 0);
    GgafRgb rgb_bg = GgafRgb(PROPERTY::BG_COLOR);
    _color_clear = D3DCOLOR_RGBA(rgb_bg._red, rgb_bg._green, rgb_bg._blue, 0);
    _pRenderTexture = nullptr;
    _pRenderTextureSurface = nullptr;
    _pRenderTextureZ = nullptr;
    _num_adapter = 1;
    _paAvailableAdapter = nullptr;
    _paAdapterRezos = nullptr;
    _apSwapChain[PRIMARY_VIEW] = nullptr;
    _apBackBuffer[PRIMARY_VIEW] = nullptr;
    _apSwapChain[SECONDARY_VIEW] = nullptr;
    _apBackBuffer[SECONDARY_VIEW] = nullptr;

    _can_wddm = true;//Ƃ肠

    if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        _primary_adapter_no = PROPERTY::PRIMARY_ADAPTER_NO;
        _secondary_adapter_no = PROPERTY::SECONDARY_ADAPTER_NO;
    } else {
        _primary_adapter_no = 0;
        _secondary_adapter_no = 1;
    }

    if (PROPERTY::SWAP_GAME_VIEW && PROPERTY::DUAL_VIEW) {
        int wk = _primary_adapter_no;
        _primary_adapter_no = _secondary_adapter_no;
        _secondary_adapter_no = wk;
    }

    _paPresetPrm = nullptr;
    _paDisplayMode = nullptr;
    _paHWnd = nullptr;
}


void GgafDxGod::resetWindowsize(HWND hWnd, pixcoord client_width, pixcoord client_height) {
    RECT wRect1, cRect1; // EBhEŜ̋`ANCAg̈̋`
    pixcoord ww1, wh1; // EBhEŜ̕A
    pixcoord cw1, ch1; // NCAg̈̕A
    pixcoord fw1, fh1; // t[̕A
    // EBhEŜ̕EvZ
    GetWindowRect(hWnd, &wRect1);
    ww1 = wRect1.right - wRect1.left;
    wh1 = wRect1.bottom - wRect1.top;
    // NCAg̈̕EvZ
    GetClientRect(hWnd, &cRect1);
    cw1 = cRect1.right - cRect1.left;
    ch1 = cRect1.bottom - cRect1.top;
    // NCAg̈ȊOɕKvȃTCYvZ
    fw1 = ww1 - cw1;
    fh1 = wh1 - ch1;
    // vZƍEBhEɐݒ
    SetWindowPos(
            hWnd,
            HWND_TOP,
            0,
            0,
            client_width + fw1,
            client_height + fh1,
            SWP_NOMOVE
    );
}

void GgafDxGod::chengeViewPos(HWND prm_pHWnd, int pos) {
    if (!PROPERTY::FULL_SCREEN) {
        if (PROPERTY::DUAL_VIEW) {
            if (prm_pHWnd ==  GgafDxGod::_pHWndPrimary) {
                PROPERTY::DUAL_VIEW_DRAW_POSITION1 = pos;
            } else if (prm_pHWnd ==  GgafDxGod::_pHWndSecondary) {
                PROPERTY::DUAL_VIEW_DRAW_POSITION2 = pos;
            }
        } else {
            if (prm_pHWnd ==  GgafDxGod::_pHWndPrimary) {
                PROPERTY::SINGLE_VIEW_DRAW_POSITION = pos;
            }
        }
        if (!PROPERTY::FULL_SCREEN && prm_pHWnd) {
            GgafDxCore::GgafDxGod::_adjustGameWindow = true;
            GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = prm_pHWnd;
        }
    }
}
void GgafDxGod::chengeViewPos1(int pos) {
    GgafDxGod::chengeViewPos(GgafDxGod::_pHWndPrimary, pos);
}
void GgafDxGod::chengeViewPos2(int pos) {
    GgafDxGod::chengeViewPos(GgafDxGod::_pHWndSecondary, pos);
}
void GgafDxGod::chengeViewAspect(bool prm_b) {
    if (!PROPERTY::FULL_SCREEN) {
        PROPERTY::FIXED_GAME_VIEW_ASPECT = prm_b;
        GgafDxCore::GgafDxGod::_adjustGameWindow = true;
        GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = GgafDxGod::_pHWndPrimary;
    }
}
int GgafDxGod::checkAppropriateDisplaySize(GgafDxGod::RezoInfo* prm_paRezos, int prm_rezo_num,
                                           UINT prm_width, UINT prm_height) {
    _TRACE_("checkAppropriateDisplaySize() ]𑜓xA"<<prm_width<<"x"<<prm_height);

    for (int n = 0; n < prm_rezo_num; n++) {
        if (prm_width == prm_paRezos[n].width && prm_height == prm_paRezos[n].height) {
            _TRACE_("["<<n<<"] BINGO!");
            return n; //҂
        }
    }
    _TRACE_("BINGOȂA߂𑜓xT܂B");
    int cfg_width  = (int)(prm_width * 1.1);  //𑜓x̍I₷邽
    int cfg_height = (int)(prm_height * 1.1); //10%
    double cfg_aspect = 1.0 * cfg_width / cfg_height;

    int eval_top = INT_MAX; //](قǗǂ)
    int resut_index = 0;
    for (int n = 0; n < prm_rezo_num; n++) {
        int disp_width  = (int)(prm_paRezos[n].width);
        int disp_height = (int)(prm_paRezos[n].height);
        int eval_level = ABS(disp_width-cfg_width) + (int)(ABS(disp_height-cfg_height) * cfg_aspect * 1.5); //AXyNgd̂1.5{
        _TRACE_("["<<n<<"] "<<disp_width<<"x"<<disp_height<<" EEE ]F"<<eval_level);
        if (eval_level < eval_top) {
            eval_top = eval_level;
            resut_index = n;
        }
    }
    _TRACE_("checkAppropriateDisplaySize() _A["<<resut_index<<"]  "<<
            prm_paRezos[resut_index].width<<"x"<<prm_paRezos[resut_index].height<<" ǂȂI");
    return resut_index;
}


void GgafDxGod::createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                             const char* prm_title1   , const char* prm_title2,
                             DWORD       prm_dwStyle1 , DWORD       prm_dwStyle2,
                             HWND&       out_hWnd1    , HWND&       out_hWnd2) {

    //2011/09/18 WDDM gpłȂgp悤ɕύXB
    // }`j^tXN[̃foCXXg̕A
    // XPł͂܂̂Vistał͂܂Ȃ邱ƂoB
    // IDirect3D9Ex ݂̑CɂȂAɎB
    // WDDM܂ IDirect3D9Ex or IDirect3D9 ̑IsB
    // IDirect3D9Ex 擾 Direct3DCreate9Ex() gpA
    // ߂ľʂŔ肷ΗǂƈՂɍlĂA
    // IDirect3D9Ex ̎ԂAVista ȍ~  d3d9.dll ɂ̂ݑ݂炵A
    // Direct3DCreate9Ex() ֐̃R[h_ŁAXP̏ꍇ d3d9.dll [h
    // uGg|Cg܂vƂG[ɂȂĂ܂słȂB
    // R[h𗼑Ήɂ́ADirect3DCreate9Ex() ͎gȂƎvB
    // ňȉ̂悤 d3d9.dll ADirect3DCreate9Ex 𒼐ڒTāA|C^
    // 擾@MSDNɂ̂ŁAQlɂĎB
    // __uuid Zq GCC ɂ͖̂ŁAIDD_IDirect3D9 ɕύXB
    // TODO::ŐȂ̂낤cB

    HRESULT hr;
    typedef HRESULT (WINAPI *DIRECT3DCREATE9EXFUNCTION)(UINT SDKVersion, IDirect3D9Ex**);
    IDirect3D9* pID3D9 = nullptr;
    IDirect3D9Ex* pID3D9Ex = nullptr;
    HMODULE hD3D = LoadLibrary(TEXT("d3d9.dll"));

    DIRECT3DCREATE9EXFUNCTION pFunc_Direct3DCreate9Ex = (DIRECT3DCREATE9EXFUNCTION)GetProcAddress(hD3D, "Direct3DCreate9Ex");
    if (pFunc_Direct3DCreate9Ex) {
        _TRACE_("d3d9.dllɁADirect3DCreate9Ex݂͑܂B");
        //d3d9.dll  Direct3DCreate9Ex ݂͑B
        hr = ((*pFunc_Direct3DCreate9Ex)(D3D_SDK_VERSION, &pID3D9Ex)); //Direct3DCreate9Ex s
        if (FAILED(hr)) {
            FreeLibrary(hD3D);
            throwGgafCriticalException("IDirect3D9Ex R|[lg擾Ɏs܂B(1)"); //s
        }
//        hr = pID3D9Ex->QueryInterface(IID_IDirect3D9, reinterpret_cast<void **>(&pID3D9)); //COMƂĎgp
//        if (FAILED(hr)) {
//            MessageBox(GgafDxGod::_pHWndPrimary, TEXT("IDirect3D9Ex R|[lg擾Ɏs܂B(2)"), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND | MB_TOPMOST);
//            FreeLibrary(hD3D);
//            return E_FAIL; //s
//        }
        GgafDxGod::_pID3D9 = (IDirect3D9*)pID3D9Ex;
        _can_wddm = true;
        _TRACE_("WDDM [h");
    } else {
        _TRACE_("d3d9.dllɁADirect3DCreate9Ex݂͑܂łB");
        //d3d9.dll  Direct3DCreate9Ex ݂͑ȂB
        pID3D9 = Direct3DCreate9(D3D_SDK_VERSION);
        if (!pID3D9) {
            FreeLibrary(hD3D);
            throwGgafCriticalException("IDirect3D9 R|[lg擾Ɏs܂B");
        }
        GgafDxGod::_pID3D9 = pID3D9;
        _can_wddm = false;
        _TRACE_("XPDM [h");
    }
    FreeLibrary(hD3D);

    //foCXp[^쐬
    D3DCAPS9 caps;
    GgafDxGod::_pID3D9->GetDeviceCaps(D3DADAPTER_DEFAULT, // [in] fBXvC A_v^B
                                      D3DDEVTYPE_HAL,     // [in] foCX̎ށB D3DDEVTYPE񋓌^̃o
                                      &caps);             // [out] foCX̔\͂i[

    _num_adapter = caps.NumberOfAdaptersInGroup;   //gA_v^̐擾
    _TRACE_("_num_adapter = "<< _num_adapter);
    if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        if (_num_adapter < 2) {
            _TRACE_("xQʃtXN[ݒłA}`j^oł܂BIɂPʃtXN[ŋN܂");
            MessageBox(GgafDxGod::_pHWndPrimary,
                       "xQʃtXN[ݒłA}`j^oł܂B\nIɂPʃtXN[ŋN܂",
                       "WARNING", MB_OK | MB_ICONSTOP | MB_SETFOREGROUND | MB_TOPMOST);
            _primary_adapter_no = 0;
            _secondary_adapter_no = 1;
            PROPERTY::DUAL_VIEW = false;
            PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH_BK  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT_BK = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
            PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH     = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT    = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
        } else {
            if (_num_adapter < PROPERTY::PRIMARY_ADAPTER_NO+1 || _num_adapter < PROPERTY::SECONDARY_ADAPTER_NO+1) {
                throwGgafCriticalException("͈͊ÕfBXvCA_v^ԍw肵Ă܂BA_v^ԍ 0`"<<_num_adapter-1<<" LłB\n"<<
                                           "PRIMARY_ADAPTER_NO="<<PROPERTY::PRIMARY_ADAPTER_NO<<", "
                                           "SECONDARY_ADAPTER_NO="<<PROPERTY::SECONDARY_ADAPTER_NO );
            }
        }
    }

    _paPresetPrm = NEW D3DPRESENT_PARAMETERS[_num_adapter > 2 ? _num_adapter : 2];
    ZeroMemory(&_paPresetPrm[_primary_adapter_no], sizeof(D3DPRESENT_PARAMETERS));

    //EBhEEtXN[
    _paPresetPrm[_primary_adapter_no].BackBufferCount        = 1;            //obNobt@̐
    _paPresetPrm[_primary_adapter_no].EnableAutoDepthStencil = TRUE;         //obNobt@ Zobt@̎쐬
    _paPresetPrm[_primary_adapter_no].AutoDepthStencilFormat = D3DFMT_D24S8; //[xXeVobt@ //D3DFMT_D16;
    _paPresetPrm[_primary_adapter_no].Flags                  = 0;            //0ɂĂ

    if (PROPERTY::FULL_SCREEN) {

        //tXN[
        _paPresetPrm[_primary_adapter_no].BackBufferFormat           = D3DFMT_X8R8G8B8; //D3DFMT_A8R8G8B8; //D3DFMT_X8R8G8B8; //D3DFMT_R5G6B5;
        _paPresetPrm[_primary_adapter_no].Windowed                   = false; //tXN[[h
        _paPresetPrm[_primary_adapter_no].FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT; //tbV[g
        _paPresetPrm[_primary_adapter_no].PresentationInterval       = D3DPRESENT_INTERVAL_DEFAULT; //Xbṽ^C~O
        _paPresetPrm[_primary_adapter_no].SwapEffect                 = D3DSWAPEFFECT_DISCARD;

        if(PROPERTY::DUAL_VIEW) {
            _paPresetPrm[_secondary_adapter_no] = _paPresetPrm[_primary_adapter_no]; //RR܂ł𕡐

            _paPresetPrm[_primary_adapter_no].EnableAutoDepthStencil = FALSE;   //Zobt@̎쐬
            _paPresetPrm[_secondary_adapter_no].EnableAutoDepthStencil = FALSE;
            //yz
            //EnableAutoDepthStencil = FALSE;
            //ƂƁA_OXe[g D3DRS_ZENABLE  FALSE ɂȂ邾̂悤ɌB
            //]āuvɂłAugpsvł͂Ȃ̂낤EEEB
        } else {
            _paPresetPrm[_primary_adapter_no].EnableAutoDepthStencil = FALSE; //Z obt@̎쐬L
        }
    } else {
        //EBhE
        _paPresetPrm[_primary_adapter_no].BackBufferFormat           = D3DFMT_UNKNOWN; //݂̕\[htH[}bg
        _paPresetPrm[_primary_adapter_no].Windowed                   = true; //EBhE[h
        _paPresetPrm[_primary_adapter_no].FullScreen_RefreshRateInHz = 0; //tbV[g
        _paPresetPrm[_primary_adapter_no].PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE; //
        _paPresetPrm[_primary_adapter_no].SwapEffect                 = D3DSWAPEFFECT_COPY; //TODO:Window[h͂Ȃ̂HAD3DPRESENT_INTERVAL_ONE Ƃ߂H

        if(PROPERTY::DUAL_VIEW) {
            _paPresetPrm[_secondary_adapter_no] = _paPresetPrm[_primary_adapter_no]; //RR܂ł𕡐
            _paPresetPrm[_primary_adapter_no].EnableAutoDepthStencil = TRUE; //Z obt@̎쐬
            _paPresetPrm[_secondary_adapter_no].EnableAutoDepthStencil = TRUE;
        } else {

            _paPresetPrm[_primary_adapter_no].EnableAutoDepthStencil = TRUE; //Z obt@̎쐬
        }

//        //fXvC[h̎擾
//        D3DDISPLAYMODE structD3DDisplayMode0; //ʂi[\
//        hr = GgafDxGod::_pID3D9->GetAdapterDisplayMode(0, &structD3DDisplayMode0);
//        returnWhenFailed(hr, D3D_OK, "GetAdapterDisplayMode Ɏs܂B");
//        if(PROPERTY::DUAL_VIEW) {
//            D3DDISPLAYMODE structD3DDisplayMode1;
//            hr = GgafDxGod::_pID3D9->GetAdapterDisplayMode(1, &structD3DDisplayMode1);
//            returnWhenFailed(hr, D3D_OK, "2ʖ GetAdapterDisplayMode Ɏs܂");
//            _paPresetPrm[_primary_adapter_no].BackBufferFormat = structD3DDisplayMode0.Format; //݂̉ʃ[h𗘗p
//            _paPresetPrm[_secondary_adapter_no].BackBufferFormat = structD3DDisplayMode1.Format; //݂̉ʃ[h𗘗p
//        } else {
//            _paPresetPrm[_primary_adapter_no].BackBufferFormat = structD3DDisplayMode0.Format; //݂̉ʃ[h𗘗p
//            _paPresetPrm[_secondary_adapter_no].BackBufferFormat = D3DFMT_UNKNOWN; //݂̉ʃ[h𗘗p
//        }
    }

    //A`ACAXɂł邩`FbN
    DWORD qualityLevels = D3DMULTISAMPLE_NONE;
    D3DMULTISAMPLE_TYPE multiSampleType = D3DMULTISAMPLE_NONE;
//    if( SUCCEEDED(GgafDxGod::_pID3D9->CheckDeviceMultiSampleType(
//        D3DADAPTER_DEFAULT,
//        D3DDEVTYPE_HAL,
//        _paPresetPrm[_primary_adapter_no].BackBufferFormat,  //TODO:EBhE[h
//        PROPERTY::FULL_SCREEN ? FALSE : TRUE,
//        D3DMULTISAMPLE_2_SAMPLES,
//        &qualityLevels) ) )
//    {
//        if( SUCCEEDED(GgafDxGod::_pID3D9->CheckDeviceMultiSampleType(
//            D3DADAPTER_DEFAULT,
//            D3DDEVTYPE_HAL,
//            _paPresetPrm[_primary_adapter_no].AutoDepthStencilFormat,
//            PROPERTY::FULL_SCREEN ? FALSE : TRUE,
//            D3DMULTISAMPLE_2_SAMPLES,
//            nullptr) ) )
//        {
//            multiSampleType = D3DMULTISAMPLE_2_SAMPLES;
//            _TRACE_("n[hEFA MultiSampleType = D3DMULTISAMPLE_2_SAMPLES LII");
//        } else {
//            multiSampleType = D3DMULTISAMPLE_NONE;
//            qualityLevels = D3DMULTISAMPLE_NONE;
//        }
//    } else {
//        multiSampleType = D3DMULTISAMPLE_NONE;
//        qualityLevels = D3DMULTISAMPLE_NONE;
//    }


    if(PROPERTY::DUAL_VIEW) {
        //}`Tv̐
        _paPresetPrm[_primary_adapter_no].MultiSampleType = multiSampleType;//D3DMULTISAMPLE_NONE;
        //}`Tv̕ix
        _paPresetPrm[_primary_adapter_no].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
        //}`Tv̐
        _paPresetPrm[_secondary_adapter_no].MultiSampleType = multiSampleType;//D3DMULTISAMPLE_NONE;
        //}`Tv̕ix
        _paPresetPrm[_secondary_adapter_no].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
    } else {
        //}`Tv̐
        _paPresetPrm[_primary_adapter_no].MultiSampleType = multiSampleType;//D3DMULTISAMPLE_NONE;
        //}`Tv̕ix
        _paPresetPrm[_primary_adapter_no].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
    }

    //}`Tv̐
    //_paPresetPrm[_primary_adapter_no].MultiSampleType = D3DMULTISAMPLE_NONMASKABLE;//D3DMULTISAMPLE_NONE;
    //}`Tv̕ix
    //_paPresetPrm[_primary_adapter_no].MultiSampleQuality = 0;//qualityLevels - (qualityLevels > 0 ? 1 : 0);


    //obNobt@TCY
    if (PROPERTY::FULL_SCREEN) {
        if(PROPERTY::DUAL_VIEW) {
            //tXN[[hEQʎgp (tXN[`FbNŏ㏑邩Ȃ)
            _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
            _paPresetPrm[_secondary_adapter_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
            _paPresetPrm[_secondary_adapter_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
        } else {
            //tXN[[hEPʎgp (tXN[`FbNŏ㏑邩Ȃ)
            _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
            _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
            _paPresetPrm[_secondary_adapter_no].BackBufferWidth  = 0;
            _paPresetPrm[_secondary_adapter_no].BackBufferHeight = 0;
        }
    } else {
        if(PROPERTY::DUAL_VIEW) {
            //EBhE[hEQʎgp
            _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH;
            _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;
            _paPresetPrm[_secondary_adapter_no].BackBufferWidth  = 0;
            _paPresetPrm[_secondary_adapter_no].BackBufferHeight = 0;
        } else {
            //EBhE[hEPʎgp
            _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH;
            _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;
            _paPresetPrm[_secondary_adapter_no].BackBufferWidth  = 0;
            _paPresetPrm[_secondary_adapter_no].BackBufferHeight = 0;
        }
    }

    _paDisplayMode = NEW D3DDISPLAYMODEEX[_num_adapter > 2 ? _num_adapter : 2];
    _paDisplayMode[_primary_adapter_no].Size = sizeof(_paDisplayMode[_primary_adapter_no]);
    _paDisplayMode[_primary_adapter_no].Width = _paPresetPrm[_primary_adapter_no].BackBufferWidth;
    _paDisplayMode[_primary_adapter_no].Height = _paPresetPrm[_primary_adapter_no].BackBufferHeight;
    _paDisplayMode[_primary_adapter_no].Format = _paPresetPrm[_primary_adapter_no].BackBufferFormat;
    _paDisplayMode[_primary_adapter_no].RefreshRate = _paPresetPrm[_primary_adapter_no].FullScreen_RefreshRateInHz;
    _paDisplayMode[_primary_adapter_no].ScanLineOrdering = D3DSCANLINEORDERING_PROGRESSIVE;

    _paDisplayMode[_secondary_adapter_no].Size = sizeof(_paDisplayMode[_secondary_adapter_no]);
    _paDisplayMode[_secondary_adapter_no].Width = _paPresetPrm[_secondary_adapter_no].BackBufferWidth;
    _paDisplayMode[_secondary_adapter_no].Height = _paPresetPrm[_secondary_adapter_no].BackBufferHeight;
    _paDisplayMode[_secondary_adapter_no].Format = _paPresetPrm[_secondary_adapter_no].BackBufferFormat;
    _paDisplayMode[_secondary_adapter_no].RefreshRate = _paPresetPrm[_secondary_adapter_no].FullScreen_RefreshRateInHz;
    _paDisplayMode[_secondary_adapter_no].ScanLineOrdering = D3DSCANLINEORDERING_PROGRESSIVE;

    //tXN[Rʖڈȍ~̃p[^Pʂ̃p[^̃Rs[ō쐬
    for (int i = 0; i < _num_adapter; i++) {
        if (i != _primary_adapter_no && i != _secondary_adapter_no) {
            _paPresetPrm[i] = _paPresetPrm[_primary_adapter_no];
            _paDisplayMode[i] = _paDisplayMode[_primary_adapter_no];
        }
    }

    //A_v^i[
    _paAvailableAdapter = NEW Adapter[_num_adapter];
    for (int adapter_no = 0; adapter_no < _num_adapter; adapter_no++) {
        _paAvailableAdapter[adapter_no].hMonitor = GgafDxGod::_pID3D9->GetAdapterMonitor(adapter_no);
        int mode_num = GgafDxGod::_pID3D9->GetAdapterModeCount(adapter_no, D3DFMT_X8R8G8B8);
        _paAvailableAdapter[adapter_no].setModeNum(mode_num);
        D3DDISPLAYMODE* paMode = _paAvailableAdapter[adapter_no].paModes;
        for (int n = 0; n < mode_num; n++) {
            GgafDxGod::_pID3D9->EnumAdapterModes(adapter_no, D3DFMT_X8R8G8B8, n, &(paMode[n]));
        }
    }

    //𑜓xi[
    _paAdapterRezos = NEW AdapterRezos[_num_adapter];
    for (int adapter_no = 0; adapter_no < _num_adapter; adapter_no++) {
        std::vector<UINT> vecWidth;
        std::vector<UINT> vecHeight;
        std::vector<std::string> vecRezo;
        int mode_num = _paAvailableAdapter[adapter_no].mode_num;
        D3DDISPLAYMODE* paMode = P_GOD->_paAvailableAdapter[adapter_no].paModes;
        _TRACE_("["<<adapter_no<<"] mode_num="<<mode_num);
        for (int n = 0; n < mode_num; n++) {
            UINT width = paMode[n].Width;
            UINT height = paMode[n].Height;
            D3DFORMAT format = paMode[n].Format;
            std::ostringstream oss;
            oss << width << "X" << height;
            std::string rezo = oss.str();
            if (std::find(vecRezo.begin(), vecRezo.end(), rezo) == vecRezo.end()) {
                vecRezo.push_back(rezo);
                vecWidth.push_back(width);
                vecHeight.push_back(height);
            }
        }
        _paAdapterRezos[adapter_no].init(vecRezo.size());
        for (int n = 0; n < vecRezo.size(); n++) {
            //݂ĂȂ
            _paAdapterRezos[adapter_no].paRezoInfo[n].width = vecWidth[n];
            _paAdapterRezos[adapter_no].paRezoInfo[n].height = vecHeight[n];
            _paAdapterRezos[adapter_no].paRezoInfo[n].item_str = vecRezo[n];
        }
    }

    _TRACE_("p\ʉ𑜓xꗗ");

    for (int adapter_no = 0; adapter_no < _num_adapter; adapter_no++) {
        for (int n = 0; n < _paAdapterRezos[adapter_no].rezo_num; n++) {
            RezoInfo* pMode = _paAdapterRezos[adapter_no].paRezoInfo;
            _TRACE_("["<<adapter_no<<"]["<<n<<"]="<<(pMode[n].width)<<","<<(pMode[n].height)<<" = "<<(pMode[n].item_str));
        }
    }
    _TRACE_("------------------------------------------------");

    //tXN[vAw𑜓xɏo邩ׁA
    //oȂꍇ́A߂𑜓xTA
    //_paPresetPrm[] ƁA_paDisplayMode[] ㏑B
    EnumDisplayMonitors(nullptr, nullptr, GgafDxGod::updateMoniterPixcoordCallback, (LPARAM)this);

    if (PROPERTY::FULL_SCREEN) {
        for (int adapter_no = 0; adapter_no < _num_adapter; adapter_no++) {
            _TRACE_("--- " << adapter_no+1 << "ʖ ̉𑜓xݒ --->");
            int rezo_num = _paAdapterRezos[adapter_no].rezo_num;
            RezoInfo* paRezos = _paAdapterRezos[adapter_no].paRezoInfo;

            if (PROPERTY::DUAL_VIEW) {
                //QʃtXN[
                if (adapter_no == _primary_adapter_no) {
                    //Q[ʂPʖ
                    int n = checkAppropriateDisplaySize(
                                paRezos, rezo_num,
                                (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH,
                                (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT
                            );
                    PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH  = (pixcoord)(paRezos[n].width);
                    PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT = (pixcoord)(paRezos[n].height);
                    _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
                    _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
                    _TRACE_("Q[ʂPʖ(adapter_no="<<adapter_no<<")́A"<<paRezos[n].width<<"x"<<paRezos[n].height<<" ɐݒ");
                } else if (adapter_no == _secondary_adapter_no) {
                    //Q[ʂQʖ
                    int n = checkAppropriateDisplaySize(
                                paRezos, rezo_num,
                                (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH,
                                (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT
                            );
                    PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH  = (pixcoord)(paRezos[n].width);
                    PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT = (pixcoord)(paRezos[n].height);
                    _paPresetPrm[_secondary_adapter_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
                    _paPresetPrm[_secondary_adapter_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
                    _TRACE_("Q[ʂQʖ(adapter_no="<<adapter_no<<")́A"<<paRezos[n].width<<"x"<<paRezos[n].height<<" ɐݒ");
                } else {
                    //FQ[ʂRʖڈȍ~PʖځEQʖڂ̉𑜓x́Ả𑜓x̂܂ܐݒB
                    pixcoord width = _paAvailableAdapter[adapter_no].rcMonitor.right -  _paAvailableAdapter[adapter_no].rcMonitor.left;
                    pixcoord height = _paAvailableAdapter[adapter_no].rcMonitor.bottom -  _paAvailableAdapter[adapter_no].rcMonitor.top;
                    _paPresetPrm[adapter_no].BackBufferWidth  = width;
                    _paPresetPrm[adapter_no].BackBufferHeight = height;
                    _TRACE_("adapter_no="<<adapter_no << "̉ʂ́A "<<width<<"x"<<height<<" ɐݒ");
                }

            } else {
                //PʃtXN[
                if (adapter_no == _primary_adapter_no) {
                    int n = checkAppropriateDisplaySize(
                                paRezos, rezo_num,
                                (UINT)PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH,
                                (UINT)PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT
                            );
                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH = (pixcoord)(paRezos[n].width);
                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT = (pixcoord)(paRezos[n].height);
                    _paPresetPrm[_primary_adapter_no].BackBufferWidth  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
                    _paPresetPrm[_primary_adapter_no].BackBufferHeight = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
                } else {
                    _paPresetPrm[adapter_no].BackBufferWidth  = 0;
                    _paPresetPrm[adapter_no].BackBufferHeight = 0;
                }

            }
            //㏑XV
            _paDisplayMode[adapter_no].Width  = _paPresetPrm[adapter_no].BackBufferWidth;
            _paDisplayMode[adapter_no].Height = _paPresetPrm[adapter_no].BackBufferHeight;
            _TRACE_("<---" << adapter_no+1 << "ʖڂ̉𑜓x́A"<<_paDisplayMode[adapter_no].Width<<"x"<<_paDisplayMode[adapter_no].Height<<"Ɋm肵܂B");
        }
    }

    //[FRECT\]
    //ɎgpRECT\̂̃o right, bottom ́uEWvƂȂĂ邪\mł͂ȂB
    //ۂ̒`
    //rect.right = rect.left + `;
    //rect.bottom = rect.top + `;
    //܂ (10,10)-(17,17) ̈́ARECT(10,10,18,18) Ǝw肷̂Ӑ}gp@炵B
    //₱AAӂ̒߂ꍇ͕֗łB
    //i{̉EẂAright, bottom  -1 ̒lɂȂj
    _rectGameBuffer.left   = 0;
    _rectGameBuffer.top    = 0;
    _rectGameBuffer.right  = _rectGameBuffer.left + PROPERTY::GAME_BUFFER_WIDTH;
    _rectGameBuffer.bottom = _rectGameBuffer.top  + PROPERTY::GAME_BUFFER_HEIGHT;

    _rectRenderTargetBuffer.left   = (PROPERTY::RENDER_TARGET_BUFFER_WIDTH / 2.0) - (PROPERTY::VIEW_SOURCE_BUFFER_WIDTH / 2.0);
    _rectRenderTargetBuffer.top    = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT / 2.0) - (PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT / 2.0);
    _rectRenderTargetBuffer.right  = _rectRenderTargetBuffer.left + PROPERTY::VIEW_SOURCE_BUFFER_WIDTH;
    _rectRenderTargetBuffer.bottom = _rectRenderTargetBuffer.top  + PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT;

    _aRect_HarfGameBuffer[PRIMARY_VIEW].left   = 0;
    _aRect_HarfGameBuffer[PRIMARY_VIEW].top    = 0;
    _aRect_HarfGameBuffer[PRIMARY_VIEW].right  = _aRect_HarfGameBuffer[PRIMARY_VIEW].left  + PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[PRIMARY_VIEW].bottom = _aRect_HarfGameBuffer[PRIMARY_VIEW].top + PROPERTY::GAME_BUFFER_HEIGHT;

    _aRect_HarfGameBuffer[SECONDARY_VIEW].left   = PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[SECONDARY_VIEW].top    = 0;
    _aRect_HarfGameBuffer[SECONDARY_VIEW].right  = _aRect_HarfGameBuffer[SECONDARY_VIEW].left + PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[SECONDARY_VIEW].bottom = _aRect_HarfGameBuffer[SECONDARY_VIEW].top  + PROPERTY::GAME_BUFFER_HEIGHT;

    _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left   = (PROPERTY::RENDER_TARGET_BUFFER_WIDTH - PROPERTY::VIEW_SOURCE_BUFFER_WIDTH) / 2;
    _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top    = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT / 2.0) - (PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT / 2.0);
    _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].right  = _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left + PROPERTY::VIEW_SOURCE_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].bottom = _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top  + PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT;

    _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left   = PROPERTY::RENDER_TARGET_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top    = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT / 2.0) - (PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT / 2.0);
    _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].right  = _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left + PROPERTY::VIEW_SOURCE_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].bottom = _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top  + PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT;

    //\̈ݒ
    if (PROPERTY::FULL_SCREEN) {
        //tXN[[h
        if (PROPERTY::DUAL_VIEW) {
            _aRect_ViewScreen[PRIMARY_VIEW].top    = 0;
            _aRect_ViewScreen[PRIMARY_VIEW].left   = 0;
            _aRect_ViewScreen[PRIMARY_VIEW].right  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            _aRect_ViewScreen[PRIMARY_VIEW].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
            _aRect_ViewScreen[SECONDARY_VIEW].top    = 0;
            _aRect_ViewScreen[SECONDARY_VIEW].left   = 0;
            _aRect_ViewScreen[SECONDARY_VIEW].right  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
            _aRect_ViewScreen[SECONDARY_VIEW].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;

            //utXN[[hEQʎgpERENDER_TARGET_BUFFERTCY
            if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                //utXN[[hEQʎgpEcFIXv̂Pʖڃtgobt@`̈
                LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO/2;
                LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                if (1.0f * PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].top    = 0;
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = 0;
                    _aRect_Present[PRIMARY_VIEW].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                }
                //utXN[[hEQʎgpEcFIXv̂Qʖڃtgobt@`̈
                fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO/2;
                fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                if (1.0f * PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[SECONDARY_VIEW].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[SECONDARY_VIEW].top    = 0;
                    _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[SECONDARY_VIEW].left   = 0;
                    _aRect_Present[SECONDARY_VIEW].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                }
                setPositionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[PRIMARY_VIEW],
                                       PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT);
                setPositionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[SECONDARY_VIEW],
                                       PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT);
            } else {
                //utXN[[hEQʎgpEcXgb`v̂Pʖڃtgobt@`̈
                _aRect_Present[PRIMARY_VIEW].left   = 0;
                _aRect_Present[PRIMARY_VIEW].top    = 0;
                _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
                _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
                //utXN[[hEQʎgpEcXgb`v̂Qʖڃtgobt@`̈
                _aRect_Present[SECONDARY_VIEW].left   = 0;
                _aRect_Present[SECONDARY_VIEW].top    = 0;
                _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
                _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
            }
        } else {
            //tXN[[hEPʎgp
            _aRect_ViewScreen[PRIMARY_VIEW].top    = 0;
            _aRect_ViewScreen[PRIMARY_VIEW].left   = 0;
            _aRect_ViewScreen[PRIMARY_VIEW].right  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
            _aRect_ViewScreen[PRIMARY_VIEW].bottom = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
            _aRect_ViewScreen[SECONDARY_VIEW] = _aRect_ViewScreen[PRIMARY_VIEW];

            //utXN[[hEPʎgpERENDER_TARGET_BUFFERTCYv
            if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                //utXN[[hEPʎgpEcFIXṽtgobt@`̈
                LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO;
                LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                if (1.0f * PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].top    = 0;
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = 0;
                    _aRect_Present[PRIMARY_VIEW].top    = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                }
                _aRect_Present[SECONDARY_VIEW] = _aRect_Present[PRIMARY_VIEW];
                setPositionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[PRIMARY_VIEW],
                                       PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
                setPositionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[SECONDARY_VIEW],
                                       PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
            } else {
                //utXN[[hEPʎgpEcXgb`ṽtgobt@`̈
                _aRect_Present[PRIMARY_VIEW].left   = 0;
                _aRect_Present[PRIMARY_VIEW].top    = 0;
                _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
                _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
                _aRect_Present[SECONDARY_VIEW] = _aRect_Present[PRIMARY_VIEW];
            }

        }
    } else {
        //EBhE[h
        if (PROPERTY::DUAL_VIEW) {
            //EBhE[hEQgp
            if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                LONG fix_width = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO/2;
                LONG fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                //uEBhE[hEQgpEcFIXEsNZXgb`v̂Pڃtgobt@`̈
                if (1.0f * PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = (PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].top    = 0;
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = 0;
                    _aRect_Present[PRIMARY_VIEW].top    = (PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                }

                fix_width = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO/2;
                fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                //uEBhE[hEQgpEcFIXv̂Qڃtgobt@`̈
                if (1.0f * PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[SECONDARY_VIEW].left   = (PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[SECONDARY_VIEW].top    = 0;
                    _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[SECONDARY_VIEW].left   = 0;
                    _aRect_Present[SECONDARY_VIEW].top    = (PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                }

                setPositionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[PRIMARY_VIEW],
                                       PROPERTY::DUAL_VIEW_WINDOW1_WIDTH, PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT);
                setPositionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[SECONDARY_VIEW],
                                       PROPERTY::DUAL_VIEW_WINDOW2_WIDTH, PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT);
            } else {
                //uEBhE[hEQgpEcXgb`v̂Pڃtgobt@`̈
                _aRect_Present[PRIMARY_VIEW].left   = 0;
                _aRect_Present[PRIMARY_VIEW].top    = 0;
                _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + PROPERTY::DUAL_VIEW_WINDOW1_WIDTH;
                _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT;
                //uEBhE[hEQgpEcXgb`v̂Qڃtgobt@`̈
                _aRect_Present[SECONDARY_VIEW].left   = 0;
                _aRect_Present[SECONDARY_VIEW].top    = 0;
                _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + PROPERTY::DUAL_VIEW_WINDOW2_WIDTH;
                _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT;
            }
        } else {
            //EBhE[hEPgp
            if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                LONG fix_width = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO;
                LONG fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                //uEBhE[hEPgpEcFIXṽtgobt@`̈
                if (1.0f * PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / fix_height; //k=c̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = (PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / 2.0) - (fix_width * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].top    = 0;
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / fix_width; //k=̔䗦
                    _aRect_Present[PRIMARY_VIEW].left   = 0;
                    _aRect_Present[PRIMARY_VIEW].top    = (PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                    _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                    _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                }
                _aRect_Present[SECONDARY_VIEW] = _aRect_Present[PRIMARY_VIEW];
                setPositionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[PRIMARY_VIEW],
                                       PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
                setPositionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[SECONDARY_VIEW],
                                       PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
            } else {
                //uEBhE[hEPgpEcXgb`ṽtgobt@`̈
                _aRect_Present[PRIMARY_VIEW].left   = 0;
                _aRect_Present[PRIMARY_VIEW].top    = 0;
                _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + PROPERTY::SINGLE_VIEW_WINDOW_WIDTH;
                _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT;
                _aRect_Present[SECONDARY_VIEW] = _aRect_Present[PRIMARY_VIEW];
            }
        }
    }

#ifdef MY_DEBUG
    _TRACE_("ݒ");
    if (PROPERTY::DUAL_VIEW) {
        _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left   = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top    = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].right  = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].bottom = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].bottom);
        _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left   = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top    = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].right  = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].bottom = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].bottom);
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].left   = "<<_aRect_Present[PRIMARY_VIEW].left  );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].top    = "<<_aRect_Present[PRIMARY_VIEW].top   );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].right  = "<<_aRect_Present[PRIMARY_VIEW].right );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].bottom = "<<_aRect_Present[PRIMARY_VIEW].bottom);
        _TRACE_(" _aRect_Present[SECONDARY_VIEW].left   = "<<_aRect_Present[SECONDARY_VIEW].left  );
        _TRACE_(" _aRect_Present[SECONDARY_VIEW].top    = "<<_aRect_Present[SECONDARY_VIEW].top   );
        _TRACE_(" _aRect_Present[SECONDARY_VIEW].right  = "<<_aRect_Present[SECONDARY_VIEW].right );
        _TRACE_(" _aRect_Present[SECONDARY_VIEW].bottom = "<<_aRect_Present[SECONDARY_VIEW].bottom);
    } else {
        _TRACE_(" _rectRenderTargetBuffer.left   = "<<_rectRenderTargetBuffer.left  );
        _TRACE_(" _rectRenderTargetBuffer.top    = "<<_rectRenderTargetBuffer.top   );
        _TRACE_(" _rectRenderTargetBuffer.right  = "<<_rectRenderTargetBuffer.right );
        _TRACE_(" _rectRenderTargetBuffer.bottom = "<<_rectRenderTargetBuffer.bottom);
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].left   = "<<_aRect_Present[PRIMARY_VIEW].left  );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].top    = "<<_aRect_Present[PRIMARY_VIEW].top   );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].right  = "<<_aRect_Present[PRIMARY_VIEW].right );
        _TRACE_(" _aRect_Present[PRIMARY_VIEW].bottom = "<<_aRect_Present[PRIMARY_VIEW].bottom);
    }
#endif

    _paHWnd = NEW HWND[_num_adapter > 2 ? _num_adapter : 2];
    for (int i = 0; i < (_num_adapter > 2 ? _num_adapter : 2); i++) {
        _paHWnd[i] = nullptr;
    }
    GgafCore::GgafRgb rgb = GgafCore::GgafRgb(PROPERTY::BORDER_COLOR);
    prm_wndclass1.hbrBackground = CreateSolidBrush(RGB(rgb._red, rgb._green, rgb._blue));
    prm_wndclass2.hbrBackground = CreateSolidBrush(RGB(rgb._red, rgb._green, rgb._blue));
    // EChE̐
    if (PROPERTY::FULL_SCREEN) {
        if (PROPERTY::DUAL_VIEW) {
            //tXN[[hEQʎgp
            WNDCLASSEX wc = prm_wndclass2;
            wc.lpszClassName = "dummy"; //TODO:SʎɑvvmF

            for (int n = 0; n < _num_adapter; n++) {
                if (n == _primary_adapter_no) {

                    RegisterClassEx(&prm_wndclass1);
                    _paHWnd[_primary_adapter_no] =
                            CreateWindowEx(
                                WS_EX_APPWINDOW,
                                prm_wndclass1.lpszClassName,
                                prm_title1,
                                WS_POPUP | WS_VISIBLE,
                                CW_USEDEFAULT,
                                CW_USEDEFAULT,
                                _paPresetPrm[_primary_adapter_no].BackBufferWidth,
                                _paPresetPrm[_primary_adapter_no].BackBufferHeight,
                                HWND_DESKTOP,
                                nullptr,
                                prm_wndclass1.hInstance,
                                nullptr
                            );
                } else if (n == _secondary_adapter_no) {
                    RegisterClassEx(&prm_wndclass2);
                    _paHWnd[_secondary_adapter_no] =
                            CreateWindowEx(
                                WS_EX_APPWINDOW,
                                prm_wndclass2.lpszClassName,
                                prm_title2,
                                WS_POPUP | WS_VISIBLE,
                                CW_USEDEFAULT,
                                CW_USEDEFAULT,
                                _paPresetPrm[_secondary_adapter_no].BackBufferWidth,
                                _paPresetPrm[_secondary_adapter_no].BackBufferHeight,
                                HWND_DESKTOP,
                                nullptr,
                                prm_wndclass2.hInstance,
                                nullptr
                           );
                } else {
                    RegisterClassEx(&wc);
                    _paHWnd[n] =
                            CreateWindowEx(
                                WS_EX_APPWINDOW,
                                wc.lpszClassName,
                                "dummy",
                                WS_POPUP | WS_VISIBLE,
                                CW_USEDEFAULT,
                                CW_USEDEFAULT,
                                _paPresetPrm[n].BackBufferWidth,
                                _paPresetPrm[n].BackBufferHeight,
                                HWND_DESKTOP,
                                nullptr,
                                wc.hInstance,
                                nullptr
                           );
                }
            }
        } else {
            //tXN[[hEPʎgp
            RegisterClassEx(&prm_wndclass1);
            _paHWnd[_primary_adapter_no] =
                    CreateWindowEx(
                        WS_EX_APPWINDOW,
                        prm_wndclass1.lpszClassName,
                        prm_title1,
                        WS_POPUP | WS_VISIBLE,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        _paPresetPrm[_primary_adapter_no].BackBufferWidth,
                        _paPresetPrm[_primary_adapter_no].BackBufferHeight,
                        HWND_DESKTOP,
                        nullptr,
                        prm_wndclass1.hInstance,
                        nullptr
                    );
        }
    } else {
        if (PROPERTY::DUAL_VIEW) {
            //ECh[hEQgp
            RegisterClassEx(&prm_wndclass1);
            _paHWnd[_primary_adapter_no] =
                    CreateWindow(
                        prm_wndclass1.lpszClassName,
                        prm_title1,
                        prm_dwStyle1,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        PROPERTY::DUAL_VIEW_WINDOW1_WIDTH,
                        PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT,
                        HWND_DESKTOP,
                        nullptr,
                        prm_wndclass1.hInstance,
                        nullptr
                    );

            RegisterClassEx(&prm_wndclass2);
            _paHWnd[_secondary_adapter_no] =
                    CreateWindow(
                        prm_wndclass2.lpszClassName,
                        prm_title2,
                        prm_dwStyle2,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        PROPERTY::DUAL_VIEW_WINDOW2_WIDTH,
                        PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT,
                        HWND_DESKTOP,
                        nullptr,
                        prm_wndclass2.hInstance,
                        nullptr
                    );


        } else {
            //ECh[hEPgp
            RegisterClassEx(&prm_wndclass1);
            _paHWnd[_primary_adapter_no] =
                    CreateWindow(
                        prm_wndclass1.lpszClassName,
                        prm_title1,
                        prm_dwStyle1,  //gȂ WS_POPUP | WS_VISIBLE,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        PROPERTY::SINGLE_VIEW_WINDOW_WIDTH,
                        PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT,
                        HWND_DESKTOP,
                        nullptr,
                        prm_wndclass1.hInstance,
                        nullptr
                    );
        }
    }
    //Windownhʎw
    for (int adapter_no = 0; adapter_no < _num_adapter; adapter_no++) {
        _paPresetPrm[adapter_no].hDeviceWindow = _paHWnd[adapter_no];
    }
    GgafDxGod::_pHWndSecondary = _paHWnd[_secondary_adapter_no];
    GgafDxGod::_pHWndPrimary   = _paHWnd[_primary_adapter_no];
    //GgafDxGod::_pHWndPrimary ̗L
    //EBhEvV[W WM_SETFOCUS ̔rɂȂĂ̂ŁA
    //Qʖ  Pʖڂ̏ő邱ƁB
    out_hWnd1 = GgafDxGod::_pHWndPrimary;
    out_hWnd2 = GgafDxGod::_pHWndSecondary;

    if (!GgafDxGod::_pHWndPrimary) {
        throwGgafCriticalException("EBhE쐬o܂łB");
    }


    //EBhE[hANCAg̈]̑傫ɂ邽߁A
    //^Cgo[ATCY{[_[̌lĐݒB
    if (!PROPERTY::FULL_SCREEN) {
        //EBhE[h
        if (PROPERTY::DUAL_VIEW) {
            resetWindowsize(GgafDxGod::_pHWndPrimary  , PROPERTY::DUAL_VIEW_WINDOW1_WIDTH, PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT);
            resetWindowsize(GgafDxGod::_pHWndSecondary, PROPERTY::DUAL_VIEW_WINDOW2_WIDTH, PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT);
        } else {
            resetWindowsize(GgafDxGod::_pHWndPrimary  , PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
        }
    }

    //ANeBu
    ShowWindow(GgafDxGod::_pHWndPrimary, SW_SHOWNORMAL);
    UpdateWindow(GgafDxGod::_pHWndPrimary);
    if (PROPERTY::DUAL_VIEW) {
        ShowWindow(GgafDxGod::_pHWndSecondary, SW_SHOWNORMAL);
        UpdateWindow(GgafDxGod::_pHWndSecondary);
    }

    //foCX쐬
    if (FAILED(initDevice())) {
        throwGgafCriticalException("Ɏs܂BAvP[VNo܂B");
    }
}

void GgafDxGod::createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                             const char* prm_title1   , const char* prm_title2,
                             HWND&       out_hWnd1    , HWND&       out_hWnd2) {
    createWindow( prm_wndclass1, prm_wndclass2,
                  prm_title1, prm_title2,
                  WS_OVERLAPPEDWINDOW | WS_VISIBLE, WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                  out_hWnd1, out_hWnd2   );
}

void GgafDxGod::createWindow(WNDPROC prm_WndProc,
                             const char* prm_title1, const char* prm_title2,
                             HWND&       out_hWnd1 , HWND&       out_hWnd2  ) {
    //EBhE`쐬
    WNDCLASSEX wcex1;
    ZeroMemory(&wcex1, sizeof(WNDCLASSEX));
    wcex1.cbSize = sizeof(WNDCLASSEX);
    wcex1.style = CS_HREDRAW | CS_VREDRAW | CS_CLASSDC;
    wcex1.lpfnWndProc = (WNDPROC)prm_WndProc;
    wcex1.hInstance = GgafDxGod::_hInstance;
    wcex1.hCursor = LoadCursor(nullptr, IDC_ARROW);
    wcex1.lpszClassName = "Gecchi Game App Framework (window[0])";
    WNDCLASSEX wcex2 = wcex1;
    wcex2.lpszClassName = "Gecchi Game App Framework (window[1])";

    createWindow( wcex1, wcex2,
                  prm_title1, prm_title2,
                  WS_OVERLAPPEDWINDOW, WS_OVERLAPPEDWINDOW,
                  out_hWnd1, out_hWnd2   );
}

void GgafDxGod::createWindow(WNDPROC prm_WndProc,
                             const char* prm_title1, const char* prm_title2) {
    HWND hWnd1, hWnd2;
    createWindow(prm_WndProc,
                 prm_title1, prm_title2,
                 hWnd1, hWnd2);
}

HRESULT GgafDxGod::initDevice() {
//    //default
//    UINT AdapterToUse = D3DADAPTER_DEFAULT;
//    D3DDEVTYPE DeviceType = D3DDEVTYPE_HAL;
//    // NVIDIA PerfHUD p begin --------------------------------------------->

//#ifdef MY_DEBUG
//
//#if SHIPPING_VERSION
//    // When building a shipping version, disable PerfHUD (opt-out)
//#else
//    _TRACE_("Look for 'NVIDIA PerfHUD' adapter...");
//    // If it is present, override default settings
//    for (UINT Adapter = 0; Adapter < GgafDxGod::_pID3D9->GetAdapterCount(); Adapter++) {
//        D3DADAPTER_IDENTIFIER9 Identifier;
//        HRESULT Res;
//        Res = GgafDxGod::_pID3D9->GetAdapterIdentifier(Adapter, 0, &Identifier);
//        if (strstr(Identifier.Description, "PerfHUD") != 0) {
//            _TRACE_("found NVIDIA PerfHUD!");
//            AdapterToUse = Adapter;
//            DeviceType = D3DDEVTYPE_REF;
//            break;
//        }
//    }
//#endif
//
//#endif
    // <------------------------------------------------ NVIDIA PerfHUD p end

    for (int n = 0; n < _num_adapter; n++) {
        _TRACE_("_paPresetPrm["<<n<<"].BackBufferWidth            = "<<_paPresetPrm[n].BackBufferWidth            );
        _TRACE_("_paPresetPrm["<<n<<"].BackBufferHeight           = "<<_paPresetPrm[n].BackBufferHeight           );
        _TRACE_("_paPresetPrm["<<n<<"].BackBufferFormat           = "<<_paPresetPrm[n].BackBufferFormat           );
        _TRACE_("_paPresetPrm["<<n<<"].BackBufferCount            = "<<_paPresetPrm[n].BackBufferCount            );
        _TRACE_("_paPresetPrm["<<n<<"].MultiSampleType            = "<<_paPresetPrm[n].MultiSampleType            );
        _TRACE_("_paPresetPrm["<<n<<"].MultiSampleQuality         = "<<_paPresetPrm[n].MultiSampleQuality         );
        _TRACE_("_paPresetPrm["<<n<<"].SwapEffect                 = "<<_paPresetPrm[n].SwapEffect                 );
        _TRACE_("_paPresetPrm["<<n<<"].hDeviceWindow              = "<<_paPresetPrm[n].hDeviceWindow              );
        _TRACE_("_paPresetPrm["<<n<<"].Windowed                   = "<<_paPresetPrm[n].Windowed                   );
        _TRACE_("_paPresetPrm["<<n<<"].EnableAutoDepthStencil     = "<<_paPresetPrm[n].EnableAutoDepthStencil     );
        _TRACE_("_paPresetPrm["<<n<<"].AutoDepthStencilFormat     = "<<_paPresetPrm[n].AutoDepthStencilFormat     );
        _TRACE_("_paPresetPrm["<<n<<"].Flags                      = "<<_paPresetPrm[n].Flags                      );
        _TRACE_("_paPresetPrm["<<n<<"].FullScreen_RefreshRateInHz = "<<_paPresetPrm[n].FullScreen_RefreshRateInHz );
        _TRACE_("_paPresetPrm["<<n<<"].PresentationInterval       = "<<_paPresetPrm[n].PresentationInterval       );

        _TRACE_("_paDisplayMode["<<n<<"].Size             = "<<_paDisplayMode[n].Size            );
        _TRACE_("_paDisplayMode["<<n<<"].Width            = "<<_paDisplayMode[n].Width           );
        _TRACE_("_paDisplayMode["<<n<<"].Height           = "<<_paDisplayMode[n].Height          );
        _TRACE_("_paDisplayMode["<<n<<"].RefreshRate      = "<<_paDisplayMode[n].RefreshRate     );
        _TRACE_("_paDisplayMode["<<n<<"].Format           = "<<_paDisplayMode[n].Format          );
        _TRACE_("_paDisplayMode["<<n<<"].ScanLineOrdering = "<<_paDisplayMode[n].ScanLineOrdering);
    }
    _TRACE_("GgafDxGod::_pHWndPrimary="<<GgafDxGod::_pHWndPrimary);
    _TRACE_("GgafDxGod::_pHWndSecondary="<<GgafDxGod::_pHWndSecondary);
    _TRACE_("_primary_adapter_no="<<_primary_adapter_no);
    _TRACE_("_secondary_adapter_no="<<_secondary_adapter_no);
    HRESULT hr;
    //sNZVF[_[A_VF[_[o[W`FbN
    D3DCAPS9 caps;
    GgafDxGod::_pID3D9->GetDeviceCaps(D3DADAPTER_DEFAULT, // [in] fBXvC A_v^B
                                      D3DDEVTYPE_HAL,     // [in] foCX̎ށB D3DDEVTYPE񋓌^̃o
                                      &caps);             // [out] foCX̔\͂i[
    _vs_v = caps.VertexShaderVersion;
    _ps_v = caps.PixelShaderVersion;

    _TRACE_("Hardware Vertex Shader Version = "<<D3DSHADER_VERSION_MAJOR(_vs_v)<<"_"<<D3DSHADER_VERSION_MINOR(_vs_v));
    _TRACE_("Hardware Pixel Shader Version  = "<<D3DSHADER_VERSION_MAJOR(_ps_v)<<"_"<<D3DSHADER_VERSION_MINOR(_ps_v));
    if (_vs_v < D3DVS_VERSION(3, 0) || _ps_v < D3DPS_VERSION(3, 0)) {
        _TRACE_("rfIJ[hn[h̒_VF[_[ 3_0 AsNZVF[_[ 3_0 ȏオłB");
        _TRACE_("gp̃rfIJ[hł́A삵Ȃꂪ܂B");
    }

    if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        //tXN[  fAr[ ̏ꍇ
        //foCX쐬 GgafDxGod::_pID3DDevice9 ֐ݒ肷B
        //n[hEFAɂ钸_AX^CYsfoCX쐬݂BHAL(pure vp)
        if (_vs_v < D3DVS_VERSION(3, 0) || _ps_v < D3DPS_VERSION(3, 0)) {
            hr = D3DERR_NOTAVAILABLE;
        } else {
            hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _paPresetPrm[0].hDeviceWindow,
                                 D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_PUREDEVICE | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                 _paPresetPrm, _paDisplayMode);
        }
        if (hr != D3D_OK) {
            if (_vs_v < D3DVS_VERSION(3, 0) || _ps_v < D3DPS_VERSION(3, 0)) {
                hr = D3DERR_NOTAVAILABLE;
            } else {
                hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _paPresetPrm[0].hDeviceWindow,
                                     D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                     _paPresetPrm, _paDisplayMode);
            }
            if (hr != D3D_OK) {
                if (_ps_v < D3DPS_VERSION(3, 0)) {
                    hr = D3DERR_NOTAVAILABLE;
                } else {
                    //\tgEFAɂ钸_An[hEFAɂ郉X^CYsfoCX쐬݂BHAL(soft vp)
                    hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _paPresetPrm[0].hDeviceWindow,
                                         D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                         _paPresetPrm, _paDisplayMode);
                }
                if (hr != D3D_OK) {
                    //\tgEFAɂ钸_AX^CYsfoCX쐬݂BREF
                    hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, _paPresetPrm[0].hDeviceWindow,
                                         D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                         _paPresetPrm, _paDisplayMode);
                    if (hr != D3D_OK) {
                        //ǂ̃foCX̍쐬sꍇ
                        _TRACE_(FUNC_NAME<<" DirectX̏Ɏs܂B}`wbhD3DCREATE_SOFTWARE_VERTEXPROCESSING : "<<GgafDxCriticalException::getHresultMsg(hr));
                        MessageBox(GgafDxGod::_pHWndPrimary, "DirectX̏Ɏs܂B\n}`wbhfBXvC݂Ă܂B", "ERROR", MB_OK | MB_ICONSTOP | MB_SETFOREGROUND | MB_TOPMOST);
                        return E_FAIL;
                    } else {
                        _TRACE_(FUNC_NAME<<" foCX MULTI FULLSCRREEN REF ŏł܂B");
                    }
                } else {
                    _TRACE_(FUNC_NAME<<" foCX MULTI FULLSCRREEN HAL(soft vp) ŏł܂B");
                }
            } else {
                _TRACE_(FUNC_NAME<<" foCX MULTI FULLSCRREEN HAL(hard vp) ŏł܂B");
            }
        } else {
            _TRACE_(FUNC_NAME<<" foCX MULTI FULLSCRREEN HAL(pure vp) ŏł܂B");
        }

    } else {
        //(tXN[  fAr[) ȊȌꍇ
        //foCX쐬 GgafDxGod::_pID3DDevice9 ֐ݒ肷B
        //n[hEFAɂ钸_AX^CYsfoCX쐬݂BHAL(pure vp)
        if (_vs_v < D3DVS_VERSION(3, 0) || _ps_v < D3DPS_VERSION(3, 0)) {
            hr = D3DERR_NOTAVAILABLE;
        } else {
            hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                                 D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_PUREDEVICE | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                 &_paPresetPrm[_primary_adapter_no], &_paDisplayMode[_primary_adapter_no]);
    //                                           D3DCREATE_MIXED_VERTEXPROCESSING|D3DCREATE_MULTITHREADED,
    //                                           D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED,
        }
        if (hr != D3D_OK) {
            if (_vs_v < D3DVS_VERSION(3, 0) || _ps_v < D3DPS_VERSION(3, 0)) {
                hr = D3DERR_NOTAVAILABLE;
            } else {
                hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                                     D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                     &_paPresetPrm[_primary_adapter_no], &_paDisplayMode[_primary_adapter_no]);
            }

            if (hr != D3D_OK) {
                if (_ps_v < D3DPS_VERSION(3, 0)) {
                    hr = D3DERR_NOTAVAILABLE;
                } else {
                    //\tgEFAɂ钸_An[hEFAɂ郉X^CYsfoCX쐬݂BHAL(soft vp)
                    hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                                         D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                         &_paPresetPrm[_primary_adapter_no], &_paDisplayMode[_primary_adapter_no]);
                }
                if (hr != D3D_OK) {
                    //\tgEFAɂ钸_AX^CYsfoCX쐬݂BREF
                    hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, GgafDxGod::_pHWndPrimary,
                                         D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                         &_paPresetPrm[_primary_adapter_no], &_paDisplayMode[_primary_adapter_no]);
                    if (hr != D3D_OK) {
                        //ǂ̃foCX̍쐬sꍇ
                        _TRACE_(FUNC_NAME<<" DirectX̏Ɏs܂B "<<GgafDxCriticalException::getHresultMsg(hr));
                        MessageBox(GgafDxGod::_pHWndPrimary, "DirectX̏Ɏs܂B", "ERROR", MB_OK | MB_ICONSTOP | MB_SETFOREGROUND | MB_TOPMOST);
                        return E_FAIL;
                    } else {
                        _TRACE_(FUNC_NAME<<" foCX REF ŏł܂B");
                    }
                } else {
                    _TRACE_(FUNC_NAME<<" foCX HAL(soft vp) ŏł܂B");
                }
            } else {
                _TRACE_(FUNC_NAME<<" foCX HAL(hard vp) ŏł܂B");
            }
        } else {
            _TRACE_(FUNC_NAME<<" foCX HAL(pure vp) ŏł܂B");
        }
    }

    //eXg
    if (_can_wddm) {
        hr = ((IDirect3DDevice9Ex*)GgafDxGod::_pID3DDevice9)->SetMaximumFrameLatency(0);
        checkDxException(hr, D3D_OK, "SetMaximumFrameLatency(0) Ɏs܂B");
    }

    //̑Kvȏ
    GgafDxGod::_pCubeMapTextureManager = NEW GgafDxTextureManager("CubeMapTexManager");
    GgafDxGod::_pBumpMapTextureManager = NEW GgafDxTextureManager("BumpMapTexManager");
    GgafDxGod::_pModelManager = NEW GgafDxModelManager("ModelManager");
    GgafDxGod::_pEffectManager = NEW GgafDxEffectManager("EffectManager");
    GgafDxUtil::init();  //[eBeB
    GgafDxInput::init(); //DirectInput
    GgafDxSound::init(); //DirectSound
    GgafDx26DirectionUtil::init();
    //foCX
    hr = initDx9Device();
    if (hr == E_FAIL) {
        return E_FAIL;
    }
    Sleep(100);
    //tXN[A_O^[QbgeNX`[쐬
    if (PROPERTY::FULL_SCREEN) {
        hr = restoreFullScreenRenderTarget();
        if (hr == E_FAIL) {
            return E_FAIL;
        }
    }

    //2011/09/28
    //TODO:VISTAłQʃtXN[ANbNŃtXN[̑΍
    //WDDMŃfoCX쐬AQʃtXN[ŋNAQʖڂ̗̈̂A
    //ƂƂ̂Pʖڂ̈(𑜓xύXɂQʖڂւ͂ݏoojNbNƁA
    //tXN[Ă܂ƂCɂȂBȂ̎Ԃ₵A@͌ȂB
    //AŃEBhEč\z邱ƂŁAȂ͉łB
    //ԂAK̕@ȂB̍EEEB
    //2015/09/02 ǋLEv
    //AЂƂAj^W񂪁AtXN[O̕擾Ă邩炾낤EEE
    if (_can_wddm && PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        hr = releaseFullScreenRenderTarget();
        hr = restoreFullScreenRenderTarget();
    }
    return D3D_OK;
}

BOOL CALLBACK GgafDxGod::updateMoniterPixcoordCallback(HMONITOR hMonitor,
                                                       HDC hdcMonitor,
                                                       LPRECT lprcMonitor,
                                                       LPARAM dwData) {
    GgafDxGod* pGod = (GgafDxGod*)dwData;
    MONITORINFOEX moniter_info;
    moniter_info.cbSize = sizeof(MONITORINFOEX);
    GetMonitorInfo(hMonitor, &moniter_info);

    for (int adapter_no = 0; adapter_no < pGod->_num_adapter; adapter_no++) {
        Adapter& adpt = pGod->_paAvailableAdapter[adapter_no];
        if (adpt.hMonitor == hMonitor) {
            adpt.rcMonitor = moniter_info.rcMonitor;
        }
    }
    return TRUE; //񋓂𑱍s
}

HRESULT GgafDxGod::createDx9Device(UINT adapter,
                                   D3DDEVTYPE device_type,
                                   HWND hFocusWindow,
                                   DWORD behavior_flags,
                                   D3DPRESENT_PARAMETERS* pPresentationParameters,
                                   D3DDISPLAYMODEEX* pFullscreenDisplayMode
                                  ) {
    HRESULT hr;
    if (_can_wddm) {
        if (!PROPERTY::FULL_SCREEN) {
            pFullscreenDisplayMode = nullptr;
        }
        IDirect3D9Ex* pID3D9Ex = (IDirect3D9Ex*)GgafDxGod::_pID3D9;
        IDirect3DDevice9Ex* pID3DDevice9Ex;
        hr = pID3D9Ex->CreateDeviceEx(adapter,
                                      device_type,
                                      hFocusWindow,
                                      behavior_flags,
                                      pPresentationParameters,
                                      pFullscreenDisplayMode,
                                      &pID3DDevice9Ex
                                      );
        GgafDxGod::_pID3DDevice9 = (IDirect3DDevice9Ex*)pID3DDevice9Ex;
    } else {
        hr = GgafDxGod::_pID3D9->CreateDevice(adapter,
                                              device_type,
                                              hFocusWindow,
                                              behavior_flags,
                                              pPresentationParameters,
                                              &GgafDxGod::_pID3DDevice9
                                              );
    }
    return hr;
 }

HRESULT GgafDxGod::initDx9Device() {
    //Cg\̂́AVF[_[̃p[^ɂȂ鎞邽ߕKvB
    D3DXVECTOR3 vecDirection(-1.0f, -1.0f, 1.0f);
    D3DXVec3Normalize(&vecDirection, &vecDirection); //K
    ZeroMemory(&_d3dlight9_default, sizeof(D3DLIGHT9));
    GgafDxGod::_d3dlight9_default.Direction = vecDirection;
    GgafDxGod::_d3dlight9_default.Type = D3DLIGHT_DIRECTIONAL;
    GgafDxGod::_d3dlight9_default.Diffuse.a = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.r = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.g = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.b = 1.0f;

    GgafDxGod::_d3dlight9_default.Ambient.a = 1.0f;
    GgafDxGod::_d3dlight9_default.Ambient.r = 0.3f; //ArGgCgSetRenderState(D3DRS_AMBIENT, 0x00303030)Őݒ
    GgafDxGod::_d3dlight9_default.Ambient.g = 0.3f;
    GgafDxGod::_d3dlight9_default.Ambient.b = 0.3f;

    //GgafDxGod::_d3dlight9_default.Range = 1000.0f;

    //CgZbg
    //    GgafDxGod::_pID3DDevice9->SetLight(0, &GgafDxGod::_d3dlight9_default);
    //CgXCb`ON
    //    GgafDxGod::_pID3DDevice9->LightEnable(0, TRUE);
    //GgafDxGod::_pID3DDevice9->LightEnable(0, FALSE);
    //_ɃCg̉eiAejL
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_LIGHTING, TRUE);
    //_ɃCg̉eiAej𖳌 (sNZVF[_[ōsȂ߁j
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_LIGHTING, FALSE);
    //_AEɋʂ̃ArGgCgLɂ悤ɕ`
    //   GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_AMBIENT, _ambient_brightness_default);

    // Zobt@L
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
    // Zobt@𖳌
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
    //Zobt@݉
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
    //Zobt@ݕs
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZWRITEENABLE, FALSE );

    //D3DRENDERSTATE_ZFUNC

    //XeVeXg̕@
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILFUNC, D3DCMP_ALWAYS); //ɃeXgpX
    //ɎsɃXeV̒lǂω邩
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILFAIL, D3DSTENCILOP_KEEP); //ωȂ
    //ZeXgŎsꍇ̃XeVl̕ω
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILZFAIL, D3DSTENCILOP_KEEP); //ωȂ


    //ivjɃJO 捶Wn
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);
    //JOȂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

    // fBUO
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DITHERENABLE, TRUE );
    // }`TvOA`GCAX(ƂĂtXN[H)TODO:܂
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, TRUE);
//    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEMASK, 0x00ffffff);

    //sNZPʂ̃At@eXgL
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ALPHATESTENABLE, TRUE);

    //ݒ̓VF[_[ɏɂ̂ŃRg
    // At@uhnm
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    //2iKځAeNX`\t|SƃobNobt@i_[^[QbgjƂ̍
    //F̎Zo@̐ݒ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_BLENDOPALPHA, D3DBLENDOP_ADD); //D3DBLENDOP_ADD=]ɓ]悪Z
    //W
    //    //ɏ摜̍@(VF[_[ɉe)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA); //SRC,D3DBLEND_SRCALPHA=ʂɕ`B|S̃At@l̔Zŕ`BAt@l̒l΍قǁAZ`B
    //    //n̉摜̍@(VF[_[ɉe)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA); //DIST,D3DBLEND_INVSRCALPHA=ɕ`|S̃At@l̔ZɂāAn̕`𔖂B



    //_J[𖳌ɂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_COLORVERTEX, FALSE );
    // GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_COLORVERTEX, TRUE );
    //    //ʂ̃ArGg˂́A}eAQƂ悤ɐݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_AMBIENTMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃ft[Y˂́A}eAQƂ悤ɐݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃G~bVu˂́A}eAQƂݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_EMISSIVEMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃XyL˂́A}eAQƂݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_SPECULARMATERIALSOURCE, D3DMCS_MATERIAL);

    //_gpƂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE , D3DMCS_COLOR1);

    //
    //
    // A`GCAX̎w
    //GgafDxGod::_pID3DDevice9->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
    //GgafDxGod::_pID3DDevice9->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
    //  TypeD3DSAMP_MINFILTER/D3DSAMP_MAGFILTERig/kj ??D3DTSS_MAGFILTER
    //  ValueD3DTEXTUREFILTERTYPE񋓌^w肷
    //  D3DTEXF_POINT@@@@FtB^ȂB`ł
    //  D3DTEXF_LINEAR@@@FjAtB^i`⊮j
    //  D3DTEXF_ANISOTROPIC@FٕtB^Bn\ʂȂǂ́AgkOƉňقȂꍇɎg
    //  D3DTEXF_PYRAMIDALQUADFegtB^BjAtB^Ƃ܂ςȂ炵
    //  D3DTEXF_GAUSSIANQUAD FKEVAtB^B܂̖ڂtB^
    //  w肷B

    //2009/3/4 SetSamplerStatëӖ뗝B
    //SetSamplerState̓eNX`ǂTvOiǂݎ邩j邩̐ݒB
    //A`GCAXĂĂAeNX`A`GCAX܂B
    //sNZVF[_[őŜŁÂ̐ݒ́ASȂȂ͂B


    //A`GCAXɂ郌_OXe[g
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS,TRUE);
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEMASK,0x7fffffff);

    //FSăVF[_[ŏɂȂ̂ŃRg
    //SetTextureStageState͔p~H
    //  1iKڃ|SƃeNX`̍@ݒ
    //    //eNX`[̐FƁA_J[DIFFUSEFZ悤ɐݒ
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    //    //eNX`[̃ƁA_J[̃Z悤ɐݒ
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_MODULATE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);


    //GgafDxCameraֈړ
    // VIEWϊiJʒujݒ
    //D3DXMATRIX _matView; // r[ϊs
    //    GGAF_DELETE_NULLABLE(_pVecCamFromPoint);
    //    GGAF_DELETE_NULLABLE(_pVecCamLookatPoint);
    //    GGAF_DELETE_NULLABLE(_pVecCamUp);

    //GgafDxCameraֈړ
    // ˉeϊiRcʁj
    //D3DXMATRIX _matProj; // ˉeϊs
    //GgafDxGod::_pID3DDevice9->SetTransform(D3DTS_PROJECTION, &_matProj);
    //HRESULT hr;
    //obNobt@EBhEBGFŃNA
    //łRenderTarget͂܂Aʏ̃obNobt@ł
//    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
//    returnWhenFailed(hr, D3D_OK, "wiF(_color_border)̓hԂAʃNAɎs܂B");
    return D3D_OK;
}


HRESULT GgafDxGod::restoreFullScreenRenderTarget() {
    if (!PROPERTY::FULL_SCREEN) {
        _TRACE_("xtXN[ӊOAĂяosvłB");
        return D3D_OK;
    }
    HRESULT hr;
    //`ƂȂeNX`ʓr쐬iobNobt@IȎgpsj
    hr = GgafDxGod::_pID3DDevice9->CreateTexture(
                                        PROPERTY::RENDER_TARGET_BUFFER_WIDTH,
                                        PROPERTY::RENDER_TARGET_BUFFER_HEIGHT,
                                        1, //MipLevel Mip
                                        D3DUSAGE_RENDERTARGET,
                                        _paPresetPrm[_primary_adapter_no].BackBufferFormat,
                                        D3DPOOL_DEFAULT,
                                        &_pRenderTexture,
                                        nullptr);

//    LPDIRECT3DTEXTURE9 pIDirect3DTexture9;
//    HRESULT hr = D3DXCreateTextureFromFileEx(
//                     GgafDxGod::_pID3DDevice9,  // [in] LPDIRECT3DDEVICE9 pDevice,
//                     texture_file_name.c_str(), // [in] LPCTSTR pSrcFile,
//                     D3DX_DEFAULT,              // [in] UINT Widths,
//                     D3DX_DEFAULT,              // [in] UINT Height,
//                     D3DX_DEFAULT,              // [in] UINT MipLevels,  //D3DX_DEFAULT,
//                     0,                         // [in] DWORD Usage,
//                     D3DFMT_UNKNOWN,            // [in] D3DFORMAT Format,
//                     D3DPOOL_DEFAULT,           // [in] D3DPOOL Pool, //D3DPOOL_DEFAULT
//                     D3DX_FILTER_POINT,         // [in] DWORD Filter, D3DX_FILTER_POINTŃ{PiC. D3DX_FILTER_LINEAR
//                     D3DX_DEFAULT,              // [in] DWORD MipFilter,
//                     0,                         // [in] D3DCOLOR ColorKey,
//                     _pD3DXIMAGE_INFO,          // [out] D3DXIMAGE_INFO *pSrcInfo,
//                     nullptr,                   // [in] PALETTEENTRY *pPalette,
//                     &pIDirect3DTexture9        // [out] LPDIRECT3DTEXTURE9* ppTexture
//                );

    //TODO:A`GCAX̎̂
    //     eNX`[̑ɃT[tFCXB
    //    HRESULT CreateRenderTarget(
    //        UINT Width,
    //        UINT Height,
    //        D3DFORMAT Format,
    //        D3DMULTISAMPLE_TYPE MultiSample,
    //        DWORD MultisampleQuality,
    //        BOOL Lockable,
    //        IDirect3DSurface9** ppSurface,
    //        HANDLE* pHandle
    //    );


    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`("<<PROPERTY::RENDER_TARGET_BUFFER_WIDTH<<"x"<<PROPERTY::RENDER_TARGET_BUFFER_HEIGHT<<")̍쐬ɎsB\nTCYmFĉB");
    //RenderTarget(`)eNX`֐؂ւ
    hr = _pRenderTexture->GetSurfaceLevel(0, &_pRenderTextureSurface);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`̃T[tFCX擾Ɏs܂B");
    hr = GgafDxGod::_pID3DDevice9->SetRenderTarget(0, _pRenderTextureSurface);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX` SetRenderTarget o܂łB");


    //eNX`ɕ`悷ۂ̐[xobt@pT[tFCXʓr쐬
    hr = GgafDxGod::_pID3DDevice9->CreateDepthStencilSurface(
            PROPERTY::RENDER_TARGET_BUFFER_WIDTH,
            PROPERTY::RENDER_TARGET_BUFFER_HEIGHT,
            _paPresetPrm[_primary_adapter_no].AutoDepthStencilFormat, //D3DFORMAT           Format,
            _paPresetPrm[_primary_adapter_no].MultiSampleType,        //D3DMULTISAMPLE_TYPE MultiSample,
            _paPresetPrm[_primary_adapter_no].MultiSampleQuality,     //DWORD               MultisampleQuality,
            TRUE,                                   //BOOL                Discard, SetDepthStencileSurface֐Ő[xobt@ύXɃobt@j邩ǂ
            &_pRenderTextureZ,                      //IDirect3DSurface9** ppSurface,
            nullptr                                 //HANDLE*             pHandle ݖgp
    );
    //[xobt@쐬́A[xobt@pT[tFCXLɕύX
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`Zobt@쐬Ɏs܂B");
    hr =  GgafDxGod::_pID3DDevice9->SetDepthStencilSurface(_pRenderTextureZ);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX` SetDepthStencilSurface o܂łB");
    //wiFŃNA
    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    returnWhenFailed(hr, D3D_OK,  "NAF(_color_border)̓hԂAʃNAɎs܂B");

    //A_v^Ɋ֘AtꂽXbv`F[擾ăobNobt@擾
    hr = GgafDxGod::_pID3DDevice9->GetSwapChain( _primary_adapter_no, &_apSwapChain[PRIMARY_VIEW] );
    returnWhenFailed(hr, D3D_OK, "Xbv`FC擾Ɏs܂B");
    hr = _apSwapChain[PRIMARY_VIEW]->GetBackBuffer( 0, D3DBACKBUFFER_TYPE_MONO, &_apBackBuffer[PRIMARY_VIEW] );
    returnWhenFailed(hr, D3D_OK, "Xbv`FCA^[Qbg̃obNobt@擾Ɏs܂B");
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->GetSwapChain( _secondary_adapter_no, &_apSwapChain[SECONDARY_VIEW] );
        returnWhenFailed(hr, D3D_OK, "Qʖڂ̃Xbv`FC擾Ɏs܂B\n}`fBXvCɖ蔭܂B");
        hr = _apSwapChain[SECONDARY_VIEW]->GetBackBuffer( 0, D3DBACKBUFFER_TYPE_MONO, &_apBackBuffer[SECONDARY_VIEW] );
        returnWhenFailed(hr, D3D_OK, "Qʖڂ̃Xbv`FCA^[Qbg̃obNobt@擾Ɏs܂B");
    }

    //tXN[AobNobt@ƃtgobt@wiFœh
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW],
                _apBackBuffer[PRIMARY_VIEW], &_aRect_ViewScreen[PRIMARY_VIEW],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖځAwiFhɎs܂B(1)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[PRIMARY_VIEW]="<<_apBackBuffer[PRIMARY_VIEW]);

        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW],
                _apBackBuffer[SECONDARY_VIEW], &_aRect_ViewScreen[SECONDARY_VIEW],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 2ʖځAwiFhɎs܂B(1)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[PRIMARY_VIEW]="<<_apBackBuffer[PRIMARY_VIEW]);
    } else {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_rectRenderTargetBuffer,
                _apBackBuffer[PRIMARY_VIEW], &_aRect_ViewScreen[PRIMARY_VIEW],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN wiFhɎs܂B(1)");
    }

    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    returnWhenFailed(hr, D3D_OK, "Present(nullptr, nullptr, nullptr, nullptr)Ɏs܂B");
    //tbvĂxwiFœh
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW],
                _apBackBuffer[PRIMARY_VIEW], &_aRect_ViewScreen[PRIMARY_VIEW],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖځAwiFhɎs܂B(2)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[PRIMARY_VIEW]="<<_apBackBuffer[PRIMARY_VIEW]);

        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW],
                _apBackBuffer[SECONDARY_VIEW], &_aRect_ViewScreen[SECONDARY_VIEW],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 2ʖځAwiFhɎs܂B(2)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[PRIMARY_VIEW]="<<_apBackBuffer[PRIMARY_VIEW]);
    } else {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_rectRenderTargetBuffer,
                _apBackBuffer[PRIMARY_VIEW], &_aRect_ViewScreen[PRIMARY_VIEW],
                D3DTEXF_NONE
                );
        checkDxException(hr, D3D_OK, "FULL_SCREEN wiFhɎs܂B(2)");
    }
    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    returnWhenFailed(hr, D3D_OK, "Present(nullptr, nullptr, nullptr, nullptr)Ɏs܂B(2)");
    //ʂȊAVISTAXP̂QʖڃtXN[[h
    //  Ή̂͂̂悤ȃR[hȂƂ_B

    //tXN[̃EBhEʒu␳
    EnumDisplayMonitors(nullptr, nullptr, GgafDxGod::updateMoniterPixcoordCallback, (LPARAM)this);

    for (int n = 0; n < _num_adapter; n++) {
        pixcoord full_screen_x = _paAvailableAdapter[n].rcMonitor.left;
        pixcoord full_screen_y = _paAvailableAdapter[n].rcMonitor.top;
        _TRACE_(" adapter_no="<<n<<" ̍W("<<full_screen_x<<","<<full_screen_y<<")");
        ShowWindow(_paHWnd[n], SW_SHOWNORMAL);
        UpdateWindow(_paHWnd[n]);
        SetWindowPos(_paHWnd[n],
                     HWND_TOPMOST,
                     full_screen_x, full_screen_y, 0, 0,
                     SWP_NOSIZE);
    }
    return D3D_OK;
}


HRESULT GgafDxGod::releaseFullScreenRenderTarget() {
    GGAF_RELEASE_BY_FROCE(_pRenderTextureSurface);
    GGAF_RELEASE_BY_FROCE(_pRenderTexture);
    GGAF_RELEASE_BY_FROCE(_pRenderTextureZ);
    GGAF_RELEASE_BY_FROCE(_apBackBuffer[PRIMARY_VIEW]);
    GGAF_RELEASE_BY_FROCE(_apSwapChain[PRIMARY_VIEW]);
    if (PROPERTY::DUAL_VIEW) {
        GGAF_RELEASE_BY_FROCE(_apBackBuffer[SECONDARY_VIEW]);
        GGAF_RELEASE_BY_FROCE(_apSwapChain[SECONDARY_VIEW]);
    }
    return D3D_OK;
}

void GgafDxGod::chengeToBorderlessFullWindow(HWND prm_pHWnd) {
    LONG lStyle  = GetWindowLong( prm_pHWnd, GWL_STYLE );
    lStyle &= ~WS_OVERLAPPEDWINDOW;
    lStyle |= WS_POPUP;
    lStyle  = SetWindowLong( prm_pHWnd, GWL_STYLE, lStyle );
    SetWindowPos( prm_pHWnd, NULL, 0, 0, 0, 0, (SWP_NOMOVE|SWP_NOSIZE|SWP_NOZORDER|SWP_FRAMECHANGED) );
    Sleep(1);
    ShowWindow(prm_pHWnd, SW_SHOWMAXIMIZED );
    UpdateWindow(prm_pHWnd);
    Sleep(1);
    ShowWindow(prm_pHWnd, SW_NORMAL );
    UpdateWindow(prm_pHWnd);
    Sleep(1);
    ShowWindow(prm_pHWnd, SW_SHOWMAXIMIZED );
    UpdateWindow(prm_pHWnd);
    GgafDxCore::GgafDxGod::_adjustGameWindow = true;
    GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = prm_pHWnd;
}

void GgafDxGod::backToNomalWindow(HWND prm_pHWnd) {

    LONG lStyle  = GetWindowLong( prm_pHWnd, GWL_STYLE );
    lStyle &= ~WS_POPUP;
    lStyle |= WS_OVERLAPPEDWINDOW;
    lStyle  = SetWindowLong( prm_pHWnd, GWL_STYLE, lStyle );
    SetWindowPos( prm_pHWnd, NULL, 0, 0, 0, 0, (SWP_NOMOVE|SWP_NOSIZE|SWP_NOZORDER|SWP_FRAMECHANGED) );
    ShowWindow(prm_pHWnd, SW_NORMAL);
    UpdateWindow(prm_pHWnd);
    GgafDxCore::GgafDxGod::_adjustGameWindow = true;
    GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = prm_pHWnd;
}

void GgafDxGod::presentSpacetimeMoment() {
    if (GgafDxGod::_is_device_lost_flg) {
        return;
    } else {
        GgafGod::presentSpacetimeMoment();
    }
}

void GgafDxGod::executeSpacetimeJudge() {
    if (GgafDxGod::_is_device_lost_flg) {
        return;
    } else {
        GgafGod::executeSpacetimeJudge();
    }
}
void GgafDxGod::makeSpacetimeMaterialize() {
    if (GgafDxGod::_is_device_lost_flg) {
        return;
    }
    IDirect3DDevice9* pDevice = GgafDxGod::_pID3DDevice9;
    HRESULT hr;
    //ʏ펞
    //obt@NA
    hr = pDevice->Clear(0, // NA`̈̐
                        nullptr, // `̈
                        D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, // _O^[QbgƐ[xobt@NA
                        _color_clear, //NAFinot wiFj
                        1.0f,         // Zobt@̃NAl
                        0             // XeVobt@̃NAl
                       );
    checkDxException(hr, D3D_OK, "pDevice->Clear() Ɏs܂B");

    //`掖O
    hr = pDevice->BeginScene();
    checkDxException(hr, D3D_OK, "pDevice->BeginScene() Ɏs܂B");
    //SċIi`j
#ifdef MY_DEBUG
    pDevice->SetRenderState(D3DRS_FILLMODE, GgafDxGod::_d3dfillmode);
#endif
    GgafGod::makeSpacetimeMaterialize(); //X[p[materializes
    //`掖㏈
    hr = pDevice->EndScene();
    checkDxException(hr, D3D_OK, "pDevice->EndScene() Ɏs܂B");

}

void GgafDxGod::presentSpacetimeVisualize() {
    IDirect3DDevice9* pDevice = GgafDxGod::_pID3DDevice9;
    //A
    //if (GgafDxGod::_pID3DDevice9->Present(nullptr,&_aRect_Present[PRIMARY_VIEW],nullptr,nullptr) == D3DERR_DEVICELOST) {
    //        static D3DRASTER_STATUS rs;
    //        while (SUCCEEDED(GgafDxGod::_pID3DDevice9->GetRasterStatus(0, &rs)) ) {
    //            if(rs.InVBlank) {
    //                break; //AԂł͂Ȃ
    //            } else {
    //                Sleep(1);
    //            }
    //        }
    HRESULT hr;
    if (GgafDxGod::_is_device_lost_flg == false) {
        if (_adjustGameWindow && _pHWnd_adjustScreen) {
            adjustGameWindow(_pHWndPrimary);
            adjustGameWindow(_pHWndSecondary);
        }

        //Present
        if (PROPERTY::FULL_SCREEN) {
            if (PROPERTY::DUAL_VIEW) {
                //QʎgpEtXN[
                //ʂOobNobt@ʂPobNobt@փRs[
                hr = pDevice->StretchRect(
                        _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW],
                        _apBackBuffer[PRIMARY_VIEW], &_aRect_Present[PRIMARY_VIEW],
                        D3DTEXF_LINEAR); //TODO:D3DTEXF_LINEARIvVwɂ邩H
                checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖ StretchRect() Ɏs܂B\n_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[PRIMARY_VIEW]="<<_apBackBuffer[PRIMARY_VIEW]);

                hr = pDevice->StretchRect(
                        _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW],
                        _apBackBuffer[SECONDARY_VIEW], &_aRect_Present[SECONDARY_VIEW],
                        D3DTEXF_LINEAR);
                checkDxException(hr, D3D_OK, "StretchRect() Ɏs܂B");

                hr = pDevice->Present(nullptr, nullptr, nullptr, nullptr);
            } else {
                //PʎgpEtXN[
                hr = pDevice->StretchRect(
                        _pRenderTextureSurface,
                        &_rectRenderTargetBuffer,
                        _apBackBuffer[PRIMARY_VIEW],
                        &_aRect_Present[PRIMARY_VIEW],
                        D3DTEXF_LINEAR);
                checkDxException(hr, D3D_OK, "FULL 1gamen StretchRect() Ɏs܂B");

                hr = pDevice->Present(nullptr, nullptr, nullptr, nullptr);
            }
        } else {
            if (PROPERTY::DUAL_VIEW) {
                //QʎgpEEBhE[h
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    //cŒ胂[h
                    if (PROPERTY::SWAP_GAME_VIEW) {
                        //ʓւ
                        hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW], &_aRect_Present[PRIMARY_VIEW], nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW], &_aRect_Present[SECONDARY_VIEW], _pHWndSecondary, nullptr);
                        }
                    } else {
                        //ʓւȂ
                        hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW], &_aRect_Present[PRIMARY_VIEW], nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW], &_aRect_Present[SECONDARY_VIEW], _pHWndSecondary, nullptr);
                        }
                    }
                } else {
                    //cXgb`[h
                    if (PROPERTY::SWAP_GAME_VIEW) {
                        //ʓւ
                        hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW], nullptr, nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW], nullptr, _pHWndSecondary, nullptr);
                        }
                    } else {
                        //ʓւȂ
                        hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW], nullptr, nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = pDevice->Present(&_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW], nullptr, _pHWndSecondary, nullptr);
                        }
                    }
                }
            } else {
                //PʎgpEEBhE[h
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    //cŒ胂[h
                    hr = pDevice->Present(&_rectRenderTargetBuffer, &_aRect_Present[PRIMARY_VIEW], nullptr, nullptr);
                } else {
                    //cXgb`[h
                    hr = pDevice->Present(&_rectRenderTargetBuffer, nullptr, nullptr, nullptr);
                }
            }
        }

        if (hr != D3D_OK) { //hr  Present ̖߂l
             //onّfIlH
//            _TRACE_("xfoCXُ픭!!" <<DXGetErrorString(hr) << " "<< DXGetErrorDescription(hr));
            _TRACE_("xfoCXُ픭!! HRESULT="<<hr);
            if (hr == D3DERR_DEVICELOST) {
                _TRACE_("ʏ̐foCXXgI");
            }

            Sleep(100);
            _TRACE_("yfoCXXgzBEGIN ------>");

            //Hx~
            _TRACE_("yfoCXXgzH~ BEGIN ------>");
            GgafFactory::beginRest();
            END_SYNCHRONIZED1; // <----- rI
            for (int i = 0; GgafFactory::isResting() == false; i++) {
                Sleep(10); //Hꂪ܂ő҂
                if (i > 10*60*100) {
                    _TRACE_("yfoCXXg/H~z 10ҋ@܂AHꂩ甽܂Bbreak܂Bv");
                    break;
                }
            }
            BEGIN_SYNCHRONIZED1; // ----->rJn
            _TRACE_("yfoCXXgzH~ <-------- END");

            _TRACE_("yfoCXXgz\[X BEGIN ------>");

            //_O^[QbgAfoCXXg
            if (PROPERTY::FULL_SCREEN) {
                releaseFullScreenRenderTarget();
            }
            //}bveNX`AfoCXXg
            GgafDxGod::_pCubeMapTextureManager->releaseAll();
            GgafDxGod::_pBumpMapTextureManager->releaseAll();
            //GtFNgAfoCXXg
            GgafDxGod::_pEffectManager->onDeviceLostAll();
            //f
            GgafDxGod::_pModelManager->onDeviceLostAll();
            //Sm[hɉȂCxg
            getSpacetime()->throwEventLowerTree(GGAF_EVENT_ON_DEVICE_LOST);
            _TRACE_("yfoCXXgz\[X <-------- END");
            GgafDxGod::_is_device_lost_flg = true;
        }
    }

    if (GgafDxGod::_is_device_lost_flg) {
        _TRACE_("yfoCXXg/\[Xzx`FbN BEGIN ------>");
        //for(int i = 0; i < 300; i++) {
        while (true) {
            if (_can_wddm) {
                hr = ((IDirect3DDevice9Ex*)pDevice)->CheckDeviceState(_paPresetPrm[_primary_adapter_no].hDeviceWindow);
                if (hr == D3DERR_DEVICELOST || hr == S_PRESENT_OCCLUDED) {
                    return;
                } else {
                    break;
                }
            } else {
                hr = pDevice->TestCooperativeLevel();
                if (hr == D3DERR_DEVICELOST) {
                    return;
                } else {
                    break;
                }
            }
        }
        _TRACE_("yfoCXXg/\[Xzx`FbN <-------- END");

        //foCXZbg݂
        _TRACE_("yfoCXXgzfoCXZbg BEGIN ------>");
        for(int i = 0; i < 100*60*10; i++) {
            if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
                hr = pDevice->Reset(_paPresetPrm);
            } else {
                hr = pDevice->Reset(&(_paPresetPrm[_primary_adapter_no]));
            }
            if (hr != D3D_OK) {
                if (hr == D3DERR_DRIVERINTERNALERROR) {
                    Sleep(10);
                    return;
                } else if (hr == D3DERR_DRIVERINTERNALERROR) {
                    throwGgafDxCriticalException(hr, "yfoCXXg/foCXZbgzD3DERR_DRIVERINTERNALERRORBI܂B");
                } else if (hr == D3DERR_OUTOFVIDEOMEMORY) {
                    throwGgafDxCriticalException(hr, "yfoCXXg/foCXZbgzD3DERR_OUTOFVIDEOMEMORYB܂BI܂B");
                } else {
                    Sleep(10);
                    return;
                }
            } else {
                break;
            }
        }
        _TRACE_("yfoCXXgzfoCXZbg <-------- END");


        //foCXĐݒ
        _TRACE_("yfoCXXgzfoCXč\z BEGIN ------>");
        initDx9Device();
        _TRACE_("yfoCXXgzfoCXč\z <-------- END");

        if (PROPERTY::FULL_SCREEN) {
            _TRACE_("yfoCXXgztXN[_O^[QbgeNX`č\z BEGIN ------>");
            restoreFullScreenRenderTarget();
            _TRACE_("yfoCXXgztXN[_O^[QbgeNX`č\z <-------- END");
        }

        //\[Xč\z
        _TRACE_("yfoCXXgz\[Xč\z BEGIN ------>");
        //}bveNX`AA
        GgafDxGod::_pCubeMapTextureManager->restoreAll();
        GgafDxGod::_pBumpMapTextureManager->restoreAll();
        //GtFNgZbg
        GgafDxGod::_pEffectManager->restoreAll();
        //fĐݒ
        GgafDxGod::_pModelManager->restoreAll();
        //Sm[hɍĐݒ肵ȂCxg
        getSpacetime()->throwEventLowerTree(GGAF_EVENT_ON_DEVICE_LOST_RESTORE);
        //O`惂f𖳌ɂ
        GgafDxModelManager::_pModelLastDraw = nullptr;
        GgafDxGod::_is_device_lost_flg = false;
        _TRACE_("yfoCXXgz\[Xč\z <-------- END");

        //HĊJ
        _TRACE_("yfoCXXgzHċN BEGIN ------>");
        GgafFactory::finishRest();
        _TRACE_("yfoCXXgzHċN <-------- END");

        _TRACE_("yfoCXXgz<-------- END");

        Sleep(100);
        hr = pDevice->Clear(0,    // NA`̈̐
                            nullptr, // `̈
                            D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, // _O^[QbgƐ[xobt@NA
                            _color_border, //wiF      //D3DCOLOR_XRGB( 0, 0, 0 )
                            1.0f, // Zobt@̃NAl
                            0     // XeVobt@̃NAl
                           );
    }
}

void GgafDxGod::finalizeSpacetime() {
    if (GgafDxGod::_is_device_lost_flg) {
        return;
    } else {
        GgafGod::finalizeSpacetime();
    }
}

void GgafDxGod::clean() {
    if (!_was_cleaned) {
        _TRACE_(FUNC_NAME<<" begin");
        IDirect3DDevice9* pDevice = GgafDxGod::_pID3DDevice9;
        for(int i = 0; i < 8; ++i) { pDevice->SetTexture( i, nullptr ); }
        for(int i = 0; i < 8; ++i) { pDevice->SetStreamSource( i, nullptr, 0, 0 ); }
        pDevice->SetIndices( nullptr );
        pDevice->SetPixelShader( nullptr );
        pDevice->SetVertexShader( nullptr );
        pDevice->SetVertexDeclaration( nullptr );

        GgafGod::clean();

        CmRandomNumberGenerator::getInstance()->release();
        //ێf
        GGAF_DELETE(GgafDxGod::_pCubeMapTextureManager);
        GGAF_DELETE(GgafDxGod::_pBumpMapTextureManager);
        GGAF_DELETE(GgafDxGod::_pModelManager);
        GGAF_DELETE(GgafDxGod::_pEffectManager);
        _TRACE_(FUNC_NAME<<" end");
    }
}

void GgafDxGod::adjustGameWindow(HWND prm_pHWnd) {
    RECT rect;
    if (prm_pHWnd && !PROPERTY::FULL_SCREEN ) {
        //EBhE[h
        HRESULT hr;
        hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
        hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
        if (PROPERTY::DUAL_VIEW) {
            hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, _pHWndSecondary, nullptr);
        }
        if (::GetClientRect(prm_pHWnd, &rect)) {
            LONG c_width= rect.right;
            LONG c_height = rect.bottom;

            LONG fix_width, fix_height;
            int pos1, pos2;
            if (PROPERTY::DUAL_VIEW) {
                pos1 = PROPERTY::DUAL_VIEW_DRAW_POSITION1;
                pos2 = PROPERTY::DUAL_VIEW_DRAW_POSITION2;
            } else {
                pos1 = PROPERTY::SINGLE_VIEW_DRAW_POSITION;
                pos2 = PROPERTY::DUAL_VIEW_DRAW_POSITION2; //Ƃ肠
            }

            //EBhE[hERENDER_TARGET_BUFFERTCY
            if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                //EBhE[hEAXyNgŒ
                if (PROPERTY::DUAL_VIEW) {
                    if (prm_pHWnd == _pHWndPrimary) {
                        fix_width  = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH  * PROPERTY::VIEW1_WIDTH_RATIO / 2.0;
                        fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT * PROPERTY::VIEW1_HEIGHT_RATIO;
                    } else {
                        fix_width  = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH  * PROPERTY::VIEW2_WIDTH_RATIO / 2.0;
                        fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT * PROPERTY::VIEW2_HEIGHT_RATIO;
                    }
                } else {
                    fix_width  = PROPERTY::VIEW_SOURCE_BUFFER_WIDTH  * PROPERTY::VIEW1_WIDTH_RATIO;
                    fix_height = PROPERTY::VIEW_SOURCE_BUFFER_HEIGHT * PROPERTY::VIEW1_HEIGHT_RATIO;
                }

                if (1.0f * c_width / c_height > 1.0f * fix_width / fix_height) {
                    //艡ɂȂĂ܂Ă
                    double rate = 1.0 * c_height / fix_height; //k=c̔䗦
                    if (prm_pHWnd == _pHWndPrimary) {
                        _aRect_Present[PRIMARY_VIEW].left   = (c_width / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[PRIMARY_VIEW].top    = 0;
                        _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                        _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                        setPositionPresentRect(pos1, _aRect_Present[PRIMARY_VIEW], c_width, c_height);
                    } else {
                        _aRect_Present[SECONDARY_VIEW].left   = (c_width / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[SECONDARY_VIEW].top    = 0;
                        _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                        _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                        setPositionPresentRect(pos2, _aRect_Present[SECONDARY_VIEW], c_width, c_height);
                    }

                } else {
                    //cɂȂĂ܂Ă
                    double rate = 1.0 * c_width / fix_width; //k=̔䗦
                    if (prm_pHWnd == _pHWndPrimary) {
                        _aRect_Present[PRIMARY_VIEW].left   = 0;
                        _aRect_Present[PRIMARY_VIEW].top    = (c_height / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[PRIMARY_VIEW].right  = _aRect_Present[PRIMARY_VIEW].left + (fix_width * rate);
                        _aRect_Present[PRIMARY_VIEW].bottom = _aRect_Present[PRIMARY_VIEW].top  + (fix_height * rate);
                        setPositionPresentRect(pos1, _aRect_Present[PRIMARY_VIEW], c_width, c_height);
                    } else {
                        _aRect_Present[SECONDARY_VIEW].left   = 0;
                        _aRect_Present[SECONDARY_VIEW].top    = (c_height / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[SECONDARY_VIEW].right  = _aRect_Present[SECONDARY_VIEW].left + (fix_width * rate);
                        _aRect_Present[SECONDARY_VIEW].bottom = _aRect_Present[SECONDARY_VIEW].top  + (fix_height * rate);
                        setPositionPresentRect(pos2, _aRect_Present[SECONDARY_VIEW], c_width, c_height);
                    }
                }
            } else {
                //EBhE[hEcXgb`
                if (::GetClientRect(prm_pHWnd, &rect)) {
                    if (prm_pHWnd == _pHWndPrimary) {
                        _aRect_Present[PRIMARY_VIEW] = rect;
                    } else {
                        _aRect_Present[SECONDARY_VIEW] = rect;
                    }

                }
            }
        }
#ifdef MY_DEBUG
        _TRACE_("GgafDxGod::adjustGameWindow(" << (prm_pHWnd == _pHWndPrimary ? "Primary" : "Secondary") <<") R[");
        if (PROPERTY::DUAL_VIEW) {
            _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left   = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].left  );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top    = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].top   );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].right  = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].right );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].bottom = "<<_aRect_HarfRenderTargetBuffer[PRIMARY_VIEW].bottom);
            _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left   = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].left  );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top    = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].top   );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].right  = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].right );
            _TRACE_(" _aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].bottom = "<<_aRect_HarfRenderTargetBuffer[SECONDARY_VIEW].bottom);
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].left   = "<<_aRect_Present[PRIMARY_VIEW].left  );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].top    = "<<_aRect_Present[PRIMARY_VIEW].top   );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].right  = "<<_aRect_Present[PRIMARY_VIEW].right );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].bottom = "<<_aRect_Present[PRIMARY_VIEW].bottom);
            _TRACE_(" _aRect_Present[SECONDARY_VIEW].left   = "<<_aRect_Present[SECONDARY_VIEW].left  );
            _TRACE_(" _aRect_Present[SECONDARY_VIEW].top    = "<<_aRect_Present[SECONDARY_VIEW].top   );
            _TRACE_(" _aRect_Present[SECONDARY_VIEW].right  = "<<_aRect_Present[SECONDARY_VIEW].right );
            _TRACE_(" _aRect_Present[SECONDARY_VIEW].bottom = "<<_aRect_Present[SECONDARY_VIEW].bottom);
        } else {
            _TRACE_(" _rectRenderTargetBuffer.left   = "<<_rectRenderTargetBuffer.left  );
            _TRACE_(" _rectRenderTargetBuffer.top    = "<<_rectRenderTargetBuffer.top   );
            _TRACE_(" _rectRenderTargetBuffer.right  = "<<_rectRenderTargetBuffer.right );
            _TRACE_(" _rectRenderTargetBuffer.bottom = "<<_rectRenderTargetBuffer.bottom);
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].left   = "<<_aRect_Present[PRIMARY_VIEW].left  );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].top    = "<<_aRect_Present[PRIMARY_VIEW].top   );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].right  = "<<_aRect_Present[PRIMARY_VIEW].right );
            _TRACE_(" _aRect_Present[PRIMARY_VIEW].bottom = "<<_aRect_Present[PRIMARY_VIEW].bottom);
        }
#endif
    } else {
        //tXN[
    }
    GgafDxCamera* pCam = getSpacetime()->getCamera();
    GgafDxGod::_pID3DDevice9->GetViewport(&(pCam->_viewport));
    _adjustGameWindow = false;
    _pHWnd_adjustScreen = nullptr;
}

void GgafDxGod::setPositionPresentRect(int prm_pos, RECT& inout_rectPresent, pixcoord prm_screen_width, pixcoord prm_screen_height) {
    // V@W@X
    // @_b^
    // S\T\U
    // @^b_
    // P@Q@R
    //1:A2:A3:EA4:A5:^񒆁A6:EA7:A8:A9:E
    if (prm_pos == 5) {
        return;
    }
    if (prm_pos == 7 || prm_pos == 8 || prm_pos == 9) {
        inout_rectPresent.bottom = inout_rectPresent.bottom - inout_rectPresent.top;
        inout_rectPresent.top = 0;
    } else if (prm_pos == 1 || prm_pos == 2 || prm_pos == 3) {
        inout_rectPresent.top = prm_screen_height - (inout_rectPresent.bottom - inout_rectPresent.top);
        inout_rectPresent.bottom = prm_screen_height;
    }

    if (prm_pos == 7 || prm_pos == 4 || prm_pos == 1) {
        inout_rectPresent.right = inout_rectPresent.right - inout_rectPresent.left;
        inout_rectPresent.left = 0;
    } else if (prm_pos == 9 || prm_pos == 6 || prm_pos == 3) {
        inout_rectPresent.left = prm_screen_width - (inout_rectPresent.right - inout_rectPresent.left);
        inout_rectPresent.right = prm_screen_width;
    }
}

GgafDxGod::~GgafDxGod() {
    _TRACE_(FUNC_NAME<<" Jn");
    clean();
    _was_cleaned = true;
    //DirectSound
    GgafDxSound::release();
    //DirectInput
    GgafDxInput::release();

    if(PROPERTY::FULL_SCREEN) {
        releaseFullScreenRenderTarget();
    }

    _TRACE_("_pID3DDevice9 ");
    Sleep(60);
    GGAF_DELETEARR(_paAvailableAdapter);
    GGAF_DELETEARR(_paAdapterRezos);
    GGAF_DELETEARR(_paPresetPrm);
    GGAF_DELETEARR(_paDisplayMode);
    GGAF_DELETEARR(_paHWnd);
    GGAF_RELEASE(_pID3DDevice9);
    GGAF_RELEASE(_pID3D9);
    _TRACE_(FUNC_NAME<<" I");
}




// 2011/07/26
//
//yPʃEBhE[hz
//                                 QQQQQQQQQQQQQQQQQQQQQ
//                               ^                                        ^
//    tgobt@         ^                                        ^
//    (EChE)           ^                                        ^
//                           PPPPPPPPPPPPPPPPPPPPP
//                           SINGLE_VIEW_WINDOW_WIDTH x SINGLE_VIEW_WINDOW_HEIGHT
//
//                                               
//                                               b Present
//                                               b(D3DSWAPEFFECT_COPY)
//                                               b
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    obNobt@              ^                                        ^
//                              ^                                        ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                       RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yQʃEBhE[hz
//                            QQQQQQQQQQQ             QQQQQQQQQQQ
//                          ^                    ^           ^                    ^
//    tgobt@    ^                    ^           ^                    ^
//    (EChE)      ^                    ^           ^                    ^
//                      PPPPPPPPPPP             PPPPPPPPPPP
//                     DUAL_VIEW_WINDOW1_WIDTH x            DUAL_VIEW_WINDOW2_WIDTH x
//                       DUAL_VIEW_WINDOW1_HEIGHT             DUAL_VIEW_WINDOW2_HEIGHT
//
//                                                                
//                                 b Present                       b Present
//                                 b(D3DSWAPEFFECT_COPY)           b (D3DSWAPEFFECT_COPY)
//
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    obNobt@              ^                                        ^
//                              ^                                        ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                    RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yPʃtXN[[hz
//                                         QQQQQQQQQQQQQQQQ
//                                       ^                              ^
//                                     ^                              ^
//    tgobt@               ^                              ^
//    (fBXvC)               ^                              ^
//                               ^                              ^
//                               PPPPPPPPPPPPPPPP
//                                SINGLE_VIEW_FULL_SCREEN_WIDTH x
//                                  SINGLE_VIEW_FULL_SCREEN_HEIGHT
//
//                                                 
//                                                 b Present (flip)
//                                                 b(D3DSWAPEFFECT_DISCARD)
//                                                 
//                                        QQQQQQQQQQQQQQQQ
//                                      ^                              ^
//                                    ^                              ^
//    obNobt@                ^      _apBackBuffer[0]        ^
//                                ^                              ^
//                              ^                              ^
//                              PPPPPPPPPPPPPPPP
//                               SINGLE_VIEW_FULL_SCREEN_WIDTH x
//                                 SINGLE_VIEW_FULL_SCREEN_HEIGHT
//
//                                                 
//                                                 b StretchRect
//                                                 b
//                                 QQQQQQQQQQQQQQQQQQQQQ
//    _[^[Qbg         ^                                        ^
//    eNX`[             ^       _pRenderTextureSurface           ^ Draw   QQQ
//                           ^                                        ^      ^    ^Q[obt@
//                           PPPPPPPPPPPPPPPPPPPPP          PPP
//                     RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yQʃtXN[[hz
//                            QQQQQQQQQQQ     |        QQQQQQQQQQQ
//                          ^                    ^     |      ^                    ^
//    tgobt@    ^                    ^       |    ^                    ^
//    (fBXvC)    ^                    ^         |  ^                    ^
//                      PPPPPPPPPPP           |  PPPPPPPPPPP
//                     DUAL_VIEW_FULL_SCREEN1_WIDTH x    |   DUAL_VIEW_FULL_SCREEN2_WIDTH x
//                       DUAL_VIEW_FULL_SCREEN1_HEIGHT   |     DUAL_VIEW_FULL_SCREEN2_HEIGHT
//
//                                                                
//                               b Present (flip)                  b Present (flip)
//                               b(D3DSWAPEFFECT_DISCARD)          b (D3DSWAPEFFECT_DISCARD)
//                                                                
//                            QQQQQQQQQQQ             QQQQQQQQQQQ
//                          ^                    ^           ^                    ^
//    obNobt@      ^  _apBackBuffer[0]  ^           ^  _apBackBuffer[1]  ^
//                      ^                    ^           ^                    ^
//                      PPPPPPPPPPP             PPPPPPPPPPP
//                     DUAL_VIEW_FULL_SCREEN1_WIDTH x        DUAL_VIEW_FULL_SCREEN2_WIDTH x
//                       DUAL_VIEW_FULL_SCREEN1_HEIGHT         DUAL_VIEW_FULL_SCREEN2_HEIGHT
//
//                                                                
//                                    b StretchRect                b StretchRect
//                                    b                            b
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    _[^[Qbg          ^                                        ^
//    eNX`[              ^       _pRenderTextureSurface           ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                       RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT




//ĂP
//                 <-------------------------------------------- 2048 --------------------------------------------->
//                 <--------- 512 --------->
//                 <------------------------- 1600 ------------------------------------------><------ 448 --------->
//
//         ^       +-----------------------+-----------------------+-----------------------+-+---------------------+
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//        512      |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         v       +-----------------------+-----------------------+-----------------------+-+---------------------+
//                                                                                         >-<-- 64


//ĂQ
//                 <-------------------------------------------- 2048 --------------------------------------------->
//                 <--------- 512 --------->
//                 <------------------------- 1280 ----------------------------><-------------- 768 --------------->
//
//         ^   ^   +-----------------------+-----------------------+-----------+-----------+-----------------------+
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//        512 480  |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   v   +-----------------------+-----------------------+-----------+           |                       |
//         v  32   +-----------------------+-----------------------+-----------------------+-----------------------+
//
//                                                                 <----256----><---256---->


