#ifndef GGAFDXCORE_GGAFDXCOLLISIONPART_H_
#define GGAFDXCORE_GGAFDXCOLLISIONPART_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * 蔻vfNX .
 * 蔻vfA蔻̈AƂQ̌t̂悤ɒ`܂B<BR>
 * a)蔻vf EEE P  or AAB or vY ̓蔻̗̐}`B<BR>
 * b)蔻̈ EEE L̓̕蔻vfW܂āAO[vB<BR>
 * {NX a) 蔻uvfvNXłB<BR>
 * ` AAB ܂ vY ܂  T|[gBi㑝邩Ȃj<BR>
 * 蔻̃[J]sړT|[g .
 * @version 1.00
 * @since 2010/01/21
 * @author Masatoshi Tsuge
 */
class GgafDxCollisionPart : public GgafCore::GgafObject {

public:
    /** 蔻(COLLI_AABOX / COLLI_AAPRISM / COLLI_AAPYRAMID / COLLI_SPHERE) */
    int _shape_kind;
    /** LtO */
    bool _is_valid_flg;
    /** 蔻苫Ễ[JW */
    coord _x1, _y1, _z1, _x2, _y2, _z2;
    /** 蔻苫ÊX */
    coord _dx;
    /** 蔻苫ÊY */
    coord _dy;
    /** 蔻苫ÊZ */
    coord _dz;
    /** 蔻苫Ê̒S̃[JXW */
    coord _cx;
    /** 蔻苫Ê̒S̃[JYW */
    coord _cy;
    /** 蔻苫Ê̒S̃[JZW */
    coord _cz;
    /** 蔻苫Ê̒S̃[JXWi]Ȍlj */
    coord _base_cx;
    /** 蔻苫Ê̒S̃[JYWi]Ȍlj */
    coord _base_cy;
    /** 蔻苫Ê̒S̃[JZWi]Ȍlj */
    coord _base_cz;

    /** _dx ̔ivZpj*/
    coord _hdx;
    /** _dy ̔ivZpj*/
    coord _hdy;
    /** _dz ̔ivZpj*/
    coord _hdz;
    /** {̂̃[JW(0,0,0)𒆐SX]̋OՂɕsړ邩ǂi]OՂ̕sړłAvf]̂ł͂Ȃj */
    bool _rot_x;
    /** {̂̃[JW(0,0,0)𒆐SY]̋OՂɕsړ邩ǂi]OՂ̕sړłAvf]̂ł͂Ȃj */
    bool _rot_y;
    /** {̂̃[JW(0,0,0)𒆐SZ]̋OՂɕsړ邩ǂi]OՂ̕sړłAvf]̂ł͂Ȃj */
    bool _rot_z;
    /** ]̋OՂɕsړ̂ǂ */
    bool _rot;

public:
    GgafDxCollisionPart();

    /**
     * ̈̎񕽍sړsB
     * @param rx [JX]AOl(0~360000)
     * @param ry [JY]AOl(0~360000)
     * @param rz [JZ]AOl(0~360000)
     * @return
     */
    virtual void rotateRxRzRy(angle rx, angle ry, angle rz) = 0;

    virtual ~GgafDxCollisionPart();
};

}
#endif /*GGAFDXCORE_GGAFDXCOLLISIONPART_H_*/
